/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components;

import de.neemann.digital.gui.components.ConstraintsBuilder;
import de.neemann.gui.ToolTipAction;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class EditorPanel {
    public static final String PRIMARY = "primary";
    public static final String SECONDARY = "secondary";
    private final JPanel panel;
    private final ConstraintsBuilder constraints;
    private final String id;

    public EditorPanel(String id) {
        this.id = id;
        this.panel = new JPanel(new GridBagLayout());
        this.constraints = new ConstraintsBuilder().inset(3).fill();
    }

    public void nextRow() {
        this.constraints.nextRow();
    }

    public Component getScrollPane() {
        return new JScrollPane(this.panel);
    }

    public String getLangKey() {
        return "attr_panel_" + this.id;
    }

    public void add(JComponent component) {
        this.panel.add((Component)component, this.constraints);
    }

    public void add(JComponent component, Constraints c) {
        this.panel.add((Component)component, c.create(this.constraints));
    }

    public void addButton(String label, ToolTipAction action) {
        this.panel.add((Component)new JLabel(label), this.constraints);
        this.panel.add((Component)action.createJButton(), this.constraints.x(1));
        this.constraints.nextRow();
    }

    public String getPanelId() {
        return this.id;
    }

    static interface Constraints {
        public ConstraintsBuilder create(ConstraintsBuilder var1);
    }
}

