/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.core.Value;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.element.Rotation;
import de.neemann.digital.core.extern.Application;
import de.neemann.digital.core.extern.PortDefinition;
import de.neemann.digital.core.io.InValue;
import de.neemann.digital.core.io.MIDIHelper;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.rom.ROMManagerFile;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.graphics.ColorScheme;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.draw.model.InverterConfig;
import de.neemann.digital.draw.model.ModelCreator;
import de.neemann.digital.draw.shapes.custom.CustomShapeDescription;
import de.neemann.digital.gui.Main;
import de.neemann.digital.gui.components.AttributeDialog;
import de.neemann.digital.gui.components.CircuitComponent;
import de.neemann.digital.gui.components.ColorSchemeEditor;
import de.neemann.digital.gui.components.CustomShapeEditor;
import de.neemann.digital.gui.components.DataEditor;
import de.neemann.digital.gui.components.Editor;
import de.neemann.digital.gui.components.EditorPanel;
import de.neemann.digital.gui.components.ROMEditorDialog;
import de.neemann.digital.gui.components.TextLineNumber;
import de.neemann.digital.gui.components.table.ShowStringDialog;
import de.neemann.digital.gui.components.testing.TestCaseDescriptionEditor;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.TestCaseDescription;
import de.neemann.gui.ErrorMessage;
import de.neemann.gui.LineBreaker;
import de.neemann.gui.MyFileChooser;
import de.neemann.gui.Screen;
import de.neemann.gui.ToolTipAction;
import de.neemann.gui.language.Bundle;
import de.neemann.gui.language.Language;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;

public final class EditorFactory {
    static final EditorFactory INSTANCE = new EditorFactory();
    private final HashMap<Class<?>, Class<? extends Editor>> map = new HashMap();

    private EditorFactory() {
        this.add(String.class, StringEditor.class);
        this.add(Integer.class, IntegerEditor.class);
        this.add(Long.class, LongEditor.class);
        this.add(InValue.class, InValueEditor.class);
        this.add(File.class, FileEditor.class);
        this.add(Color.class, ColorEditor.class);
        this.add(Boolean.class, BooleanEditor.class);
        this.add(DataField.class, DataFieldEditor.class);
        this.add(Rotation.class, RotationEditor.class);
        this.add(Language.class, LanguageEditor.class);
        this.add(TestCaseDescription.class, TestCaseDescriptionEditor.class);
        this.add(InverterConfig.class, InverterConfigEditor.class);
        this.add(ROMManagerFile.class, ROMManagerEditor.class);
        this.add(Application.Type.class, ApplicationTypeEditor.class);
        this.add(CustomShapeDescription.class, CustomShapeEditor.class);
        this.add(ColorScheme.class, ColorSchemeEditor.class);
    }

    private <T> void add(Class<T> clazz, Class<? extends Editor<T>> editor) {
        this.map.put(clazz, editor);
    }

    public <T> Editor<T> create(Key<T> key, T value) {
        if (key == Keys.MIDI_INSTRUMENT) {
            return new MidiInstrumentEditor(value.toString());
        }
        Class<? extends Editor> fac = this.map.get(key.getValueClass());
        if (fac == null) {
            if (key instanceof Key.KeyEnum) {
                return new EnumEditor<T>((Enum)value, key);
            }
            throw new RuntimeException("no editor found for " + key.getValueClass().getSimpleName());
        }
        try {
            Constructor<? extends Editor> c = fac.getConstructor(value.getClass(), Key.class);
            return c.newInstance(value, key);
        }
        catch (Exception e) {
            throw new RuntimeException("error creating editor", e);
        }
    }

    public static <TC extends JTextComponent> TC addF1Traversal(TC text) {
        HashSet<AWTKeyStroke> set = new HashSet<AWTKeyStroke>(text.getFocusTraversalKeys(0));
        set.add(KeyStroke.getKeyStroke("F1"));
        text.setFocusTraversalKeys(0, set);
        return text;
    }

    public static UndoManager createUndoManager(JTextComponent text) {
        final UndoManager undoManager = new UndoManager();
        text.getDocument().addUndoableEditListener(undoManager);
        text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 90 && (e.getModifiersEx() & ToolTipAction.getCTRLMask()) != 0) {
                    if (undoManager.canUndo()) {
                        undoManager.undo();
                    }
                } else if (e.getKeyCode() == 89 && (e.getModifiersEx() & ToolTipAction.getCTRLMask()) != 0 && undoManager.canRedo()) {
                    undoManager.redo();
                }
            }
        });
        return undoManager;
    }

    private static final class MidiInstrumentEditor
    extends LabelEditor<String> {
        private JComboBox<String> comb;

        private MidiInstrumentEditor(String instrument) {
            String[] instruments;
            try {
                instruments = MIDIHelper.getInstance().getInstruments();
            }
            catch (NodeException e) {
                instruments = new String[]{"MIDI not available"};
            }
            this.comb = new JComboBox<String>(instruments);
            this.comb.setSelectedItem(instrument);
        }

        @Override
        protected JComponent getComponent(ElementAttributes elementAttributes) {
            return this.comb;
        }

        @Override
        public String getValue() {
            return (String)this.comb.getSelectedItem();
        }

        @Override
        public void setValue(String value) {
            this.comb.setSelectedItem(value);
        }
    }

    private static class ROMManagerEditor
    extends LabelEditor<ROMManagerFile> {
        private final JPanel buttons;
        private ROMManagerFile romManager;

        public ROMManagerEditor(ROMManagerFile aRomManager, Key<ROMManagerFile> key) {
            this.romManager = aRomManager;
            this.buttons = new JPanel(new GridLayout(1, 2));
            this.buttons.add(new ToolTipAction(Lang.get("btn_help", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    new ShowStringDialog((Window)this.getAttributeDialog(), Lang.get("win_romDialogHelpTitle", new Object[0]), Lang.get("msg_romDialogHelp", new Object[0]), true).setVisible(true);
                }
            }.createJButton());
            this.buttons.add(new ToolTipAction(Lang.get("btn_edit", new Object[0])){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Main main = this.getAttributeDialog().getMain();
                    if (main != null) {
                        try {
                            CircuitComponent circuitComponent = main.getCircuitComponent();
                            try (Model model = new ModelCreator(circuitComponent.getCircuit(), circuitComponent.getLibrary()).createModel(false);){
                                ROMEditorDialog romEditorDialog = new ROMEditorDialog(this.getAttributeDialog(), model, romManager);
                                if (romEditorDialog.showDialog()) {
                                    romManager = romEditorDialog.getROMManager();
                                }
                            }
                        }
                        catch (NodeException | PinException | ElementNotFoundException e) {
                            new ErrorMessage(Lang.get("msg_errorCreatingModel", new Object[0])).addCause(e).show(this.getAttributeDialog());
                        }
                    }
                }
            }.createJButton());
        }

        @Override
        protected JComponent getComponent(ElementAttributes elementAttributes) {
            return this.buttons;
        }

        @Override
        public ROMManagerFile getValue() {
            return this.romManager;
        }

        @Override
        public void setValue(ROMManagerFile value) {
            this.romManager = value;
        }
    }

    private static final class InputSelectDialog
    extends JDialog {
        private final ArrayList<JCheckBox> boxes;
        private boolean ok = false;

        private InputSelectDialog(JDialog parent, PinDescriptions pins, InverterConfig inverterConfig) {
            super(parent, Lang.get("msg_inputsToInvert", new Object[0]), true);
            this.setDefaultCloseOperation(2);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            this.boxes = new ArrayList();
            for (PinDescription p : pins) {
                JCheckBox cb = new JCheckBox(p.getName());
                cb.setSelected(inverterConfig.contains(p.getName()));
                this.boxes.add(cb);
                panel.add(cb);
            }
            int pad = Screen.getInstance().getFontSize();
            panel.setBorder(BorderFactory.createEmptyBorder(pad, pad, pad, pad));
            this.getContentPane().add(panel);
            this.getContentPane().add((Component)new JButton(new AbstractAction(Lang.get("ok", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ok = true;
                    this.dispose();
                }
            }), "South");
            this.pack();
            this.setLocationRelativeTo(parent);
        }

        public boolean showDialog() {
            this.setVisible(true);
            return this.ok;
        }

        private InverterConfig getInverterConfig() {
            InverterConfig.Builder ic = new InverterConfig.Builder();
            for (JCheckBox cb : this.boxes) {
                if (!cb.isSelected()) continue;
                ic.add(cb.getText());
            }
            return ic.build();
        }
    }

    private static class InverterConfigEditor
    extends LabelEditor<InverterConfig> {
        private final JButton button;
        private InverterConfig inverterConfig;
        private ElementAttributes elementAttributes;

        public InverterConfigEditor(InverterConfig aInverterConfig, Key<InverterConfig> key) {
            this.inverterConfig = aInverterConfig;
            this.button = new JButton(new ToolTipAction(this.getButtonText()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VisualElement ve = this.getAttributeDialog().getVisualElement();
                    Window p = this.getAttributeDialog().getDialogParent();
                    if (ve != null && p instanceof Main) {
                        try {
                            this.getAttributeDialog().storeEditedValues();
                            ElementTypeDescription d = ((Main)p).getCircuitComponent().getLibrary().getElementType(ve.getElementName());
                            PinDescriptions in = d.getInputDescription(elementAttributes);
                            InputSelectDialog dialog = new InputSelectDialog(this.getAttributeDialog(), in, inverterConfig);
                            if (dialog.showDialog()) {
                                inverterConfig = dialog.getInverterConfig();
                                button.setText(this.getButtonText());
                            }
                        }
                        catch (NodeException | ElementNotFoundException e) {
                            new ErrorMessage(Lang.get("msg_errGettingPinNames", new Object[0])).addCause(e).show(this.getAttributeDialog());
                        }
                        catch (Editor.EditorParseException e) {
                            new ErrorMessage(Lang.get("msg_invalidEditorValue", new Object[0])).addCause(e).show(this.getAttributeDialog());
                        }
                    }
                }
            });
        }

        private String getButtonText() {
            if (this.inverterConfig.isEmpty()) {
                return Lang.get("msg_none", new Object[0]);
            }
            return this.inverterConfig.toString();
        }

        @Override
        public InverterConfig getValue() {
            return this.inverterConfig;
        }

        @Override
        protected JComponent getComponent(ElementAttributes elementAttributes) {
            this.elementAttributes = elementAttributes;
            return this.button;
        }

        @Override
        public void setValue(InverterConfig value) {
            this.inverterConfig = value;
            this.button.setText(this.getButtonText());
        }
    }

    private static class LanguageEditor
    extends LabelEditor<Language> {
        private final JComboBox<Language> comb;

        public LanguageEditor(Language language, Key<Language> key) {
            Bundle b = Lang.getBundle();
            List<Language> supLang = b.getSupportedLanguages();
            this.comb = new JComboBox<Language>(supLang.toArray(new Language[0]));
            this.comb.setSelectedItem(language);
        }

        @Override
        protected JComponent getComponent(ElementAttributes elementAttributes) {
            return this.comb;
        }

        @Override
        public Language getValue() {
            return (Language)this.comb.getSelectedItem();
        }

        @Override
        public void setValue(Language value) {
            this.comb.setSelectedItem(value);
        }
    }

    private static final class ApplicationTypeEditor
    extends EnumEditor<Application.Type> {
        private JComboBox combo;
        private JButton checkButton;

        public ApplicationTypeEditor(Application.Type value, Key<Application.Type> key) {
            super(value, key);
        }

        @Override
        protected JComponent getComponent(final ElementAttributes elementAttributes) {
            this.combo = (JComboBox)super.getComponent(elementAttributes);
            this.checkButton = new ToolTipAction(Lang.get("btn_checkCode", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Application.Type appType;
                    Application app;
                    int n = combo.getSelectedIndex();
                    if (n >= 0 && (app = Application.create(appType = Application.Type.values()[n], elementAttributes)) != null) {
                        try {
                            this.getAttributeDialog().storeEditedValues();
                            File root = this.getAttributeDialog().getRootFile();
                            boolean consistent = app.ensureConsistency(elementAttributes, root);
                            if (consistent) {
                                this.getAttributeDialog().updateEditedValues();
                            }
                            PortDefinition ins = new PortDefinition(elementAttributes.get(Keys.EXTERNAL_INPUTS));
                            PortDefinition outs = new PortDefinition(elementAttributes.get(Keys.EXTERNAL_OUTPUTS));
                            String label = elementAttributes.getLabel();
                            try {
                                String code = Application.getCode(elementAttributes, root);
                                String message = app.checkCode(label, code, ins, outs, root);
                                if (message != null && !message.isEmpty()) {
                                    this.createError(consistent, Lang.get("msg_checkResult", new Object[0]) + "\n\n" + message).show(this.getAttributeDialog());
                                }
                            }
                            catch (IOException e) {
                                this.createError(consistent, Lang.get("msg_checkResult", new Object[0])).addCause(e).show(this.getAttributeDialog());
                            }
                        }
                        catch (Editor.EditorParseException e) {
                            e.printStackTrace();
                        }
                    }
                }

                private ErrorMessage createError(boolean consistent, String message) {
                    if (!consistent) {
                        message = Lang.get("msg_codeNotConsistent", new Object[0]) + "\n\n" + message;
                    }
                    return new ErrorMessage(message);
                }
            }.setToolTip(Lang.get("btn_checkCode_tt", new Object[0])).createJButton();
            this.combo.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.enableButton(elementAttributes);
                }
            });
            JPanel p = new JPanel(new BorderLayout());
            p.add(this.combo);
            p.add((Component)this.checkButton, "East");
            this.enableButton(elementAttributes);
            return p;
        }

        void enableButton(ElementAttributes attr) {
            Application.Type appType;
            Application app;
            int n = this.combo.getSelectedIndex();
            if (n >= 0 && (app = Application.create(appType = Application.Type.values()[n], attr)) != null) {
                this.checkButton.setEnabled(app.checkSupported());
            }
        }
    }

    private static class EnumEditor<E extends Enum>
    extends LabelEditor<E> {
        private final JComboBox comboBox;
        private final E[] values;
        private final String[] names;

        public EnumEditor(Enum value, Key<E> key) {
            if (!(key instanceof Key.KeyEnum)) {
                throw new RuntimeException("wrong enum type");
            }
            this.names = ((Key.KeyEnum)key).getNames();
            this.values = ((Key.KeyEnum)key).getValues();
            this.comboBox = new JComboBox<String>(this.names);
            this.comboBox.setSelectedIndex(value.ordinal());
        }

        @Override
        protected JComponent getComponent(ElementAttributes elementAttributes) {
            return this.comboBox;
        }

        @Override
        public E getValue() {
            return this.values[this.comboBox.getSelectedIndex()];
        }

        @Override
        public void setValue(E value) {
            this.comboBox.setSelectedIndex(((Enum)value).ordinal());
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this.comboBox.addActionListener(actionListener);
        }
    }

    private static final class RotationEditor
    extends LabelEditor<Rotation> {
        private static final String[] LIST = new String[]{Lang.get("rot_0", new Object[0]), Lang.get("rot_90", new Object[0]), Lang.get("rot_180", new Object[0]), Lang.get("rot_270", new Object[0])};
        private final Rotation rotation;
        private JComboBox<String> comb;

        public RotationEditor(Rotation rotation, Key<Rotation> key) {
            this.rotation = rotation;
        }

        @Override
        public JComponent getComponent(ElementAttributes elementAttributes) {
            this.comb = new JComboBox<String>(LIST);
            this.comb.setSelectedIndex(this.rotation.getRotation());
            return this.comb;
        }

        @Override
        public Rotation getValue() {
            return new Rotation(this.comb.getSelectedIndex());
        }

        @Override
        public void setValue(Rotation value) {
            this.comb.setSelectedIndex(value.getRotation());
        }
    }

    private static final class DataFieldEditor
    extends LabelEditor<DataField> {
        private DataField data;
        private boolean majorModification = false;
        private JButton editButton;

        public DataFieldEditor(DataField data, Key<DataField> key) {
            this.data = data;
        }

        @Override
        public JComponent getComponent(final ElementAttributes attr) {
            final JPanel panel = new JPanel(new GridLayout(1, 2));
            this.editButton = new ToolTipAction(Lang.get("btn_edit", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        this.getAttributeDialog().storeEditedValues();
                        int dataBits = attr.get(Keys.BITS);
                        int addrBits = this.getAddrBits(attr);
                        DataEditor de = new DataEditor(panel, data, dataBits, addrBits, false, SyncAccess.NOSYNC, attr.getValueFormatter());
                        if (attr.get(Keys.AUTO_RELOAD_ROM).booleanValue()) {
                            de.setFileName(attr.getFile(Keys.LAST_DATA_FILE, this.getAttributeDialog().getRootFile()));
                        }
                        if (de.showDialog()) {
                            DataField mod = de.getModifiedDataField();
                            if (!data.equals(mod)) {
                                majorModification = true;
                            }
                            data = mod;
                        }
                    }
                    catch (Editor.EditorParseException e1) {
                        new ErrorMessage(Lang.get("msg_invalidEditorValue", new Object[0])).addCause(e1).show(panel);
                    }
                }
            }.createJButton();
            panel.add(this.editButton);
            return panel;
        }

        private int getAddrBits(ElementAttributes attr) {
            if (attr.contains(Keys.INPUT_COUNT)) {
                return attr.get(Keys.INPUT_COUNT);
            }
            return attr.get(Keys.ADDR_BITS);
        }

        @Override
        public DataField getValue() {
            this.data.trim();
            return this.data;
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.editButton.setEnabled(enabled);
        }

        @Override
        public boolean invisibleModification() {
            return this.majorModification;
        }

        @Override
        public void setValue(DataField value) {
            this.data = value;
        }
    }

    private static final class FileEditor
    extends LabelEditor<File> {
        private final JPanel panel;
        private final JTextField textField;
        private final boolean directoryOnly;
        private final JButton button;

        public FileEditor(File value, Key<File> key) {
            this.directoryOnly = key instanceof Key.KeyFile ? ((Key.KeyFile)key).isDirectoryOnly() : false;
            this.panel = new JPanel(new BorderLayout());
            this.textField = new JTextField(value.getPath(), 20);
            this.button = new JButton(new AbstractAction("..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyFileChooser fc = new MyFileChooser(this.getValue());
                    if (directoryOnly) {
                        fc.setFileSelectionMode(1);
                    }
                    if (fc.showOpenDialog(panel) == 0) {
                        textField.setText(fc.getSelectedFile().getPath());
                    }
                }
            });
            this.panel.add((Component)this.textField, "Center");
            this.panel.add((Component)this.button, "East");
        }

        @Override
        public JComponent getComponent(ElementAttributes attr) {
            return this.panel;
        }

        @Override
        public File getValue() {
            return new File(this.textField.getText());
        }

        @Override
        public void setValue(File value) {
            this.textField.setText(value.getPath());
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.textField.setEnabled(enabled);
            this.button.setEnabled(enabled);
        }
    }

    private static final class ColorEditor
    extends LabelEditor<Color> {
        private Color color;
        private final JButton button;

        public ColorEditor(Color value, Key<Color> key) {
            this.color = value;
            this.button = new JButton(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color col = JColorChooser.showDialog(button, Lang.get("msg_color", new Object[0]), color);
                    if (col != null) {
                        color = new Color(col.getRed(), col.getGreen(), col.getBlue(), col.getAlpha());
                        button.setBackground(color);
                    }
                }
            }){

                @Override
                protected void paintComponent(Graphics graphics) {
                    graphics.setColor(Color.WHITE);
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    super.paintComponent(graphics);
                }
            };
            this.button.setPreferredSize(new Dimension(10, Screen.getInstance().getFontSize() * 3 / 2));
            this.button.setBackground(this.color);
        }

        @Override
        public JComponent getComponent(ElementAttributes attr) {
            return this.button;
        }

        @Override
        public Color getValue() {
            return this.color;
        }

        @Override
        public void setValue(Color value) {
            this.color = value;
            this.button.setBackground(this.color);
        }
    }

    static final class BooleanEditor
    implements Editor<Boolean> {
        private final JCheckBox bool;

        public BooleanEditor(Boolean value, Key<Boolean> key) {
            this.bool = new JCheckBox(key.getName(), (boolean)value);
            this.bool.setToolTipText(new LineBreaker().toHTML().breakLines(key.getDescription()));
        }

        @Override
        public Boolean getValue() {
            return this.bool.isSelected();
        }

        @Override
        public void addToPanel(EditorPanel panel, Key key, ElementAttributes elementAttributes, AttributeDialog attributeDialog) {
            panel.add(this.bool, cb -> cb.width(2));
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.bool.setEnabled(enabled);
        }

        @Override
        public void setValue(Boolean value) {
            this.bool.setEnabled(value);
        }

        @Override
        public void addActionListener(ActionListener al) {
            this.bool.addActionListener(al);
        }
    }

    private static final class InValueEditor
    extends LabelEditor<InValue> {
        private static final String[] DEFAULTS = new String[]{"Z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"};
        private final JComboBox<String> comboBox = new JComboBox<String>(DEFAULTS);

        public InValueEditor(InValue value, Key<Integer> key) {
            this.comboBox.setEditable(true);
            this.comboBox.setSelectedItem(value.toString());
        }

        @Override
        public void addToPanel(EditorPanel panel, Key<InValue> key, ElementAttributes attr, AttributeDialog attributeDialog) {
            if (key.isAdaptiveIntFormat()) {
                Value value = new Value(attr.get(key), attr.getBits());
                this.comboBox.setSelectedItem(attr.getValueFormatter().formatToEdit(value));
            }
            super.addToPanel(panel, key, attr, attributeDialog);
        }

        @Override
        public JComponent getComponent(ElementAttributes attr) {
            return this.comboBox;
        }

        @Override
        public InValue getValue() throws Editor.EditorParseException {
            Object item = this.comboBox.getSelectedItem();
            try {
                return new InValue(item.toString());
            }
            catch (Bits.NumberFormatException e) {
                throw new Editor.EditorParseException(e);
            }
        }

        @Override
        public void setValue(InValue value) {
            this.comboBox.setSelectedItem(value.toString());
        }
    }

    private static final class LongEditor
    extends LabelEditor<Long> {
        private static final Long[] DEFAULTS = new Long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L};
        private final JComboBox<Long> comboBox = new JComboBox<Long>(DEFAULTS);

        public LongEditor(Long value, Key<Long> key) {
            this.comboBox.setEditable(true);
            this.comboBox.setSelectedItem(value.toString());
        }

        @Override
        public JComponent getComponent(ElementAttributes attr) {
            return this.comboBox;
        }

        @Override
        public void addToPanel(EditorPanel panel, Key<Long> key, ElementAttributes attr, AttributeDialog attributeDialog) {
            if (key.isAdaptiveIntFormat()) {
                Value value = new Value(attr.get(key), attr.getBits());
                this.comboBox.setSelectedItem(attr.getValueFormatter().formatToEdit(value));
            }
            super.addToPanel(panel, key, attr, attributeDialog);
        }

        @Override
        public Long getValue() throws Editor.EditorParseException {
            Object item = this.comboBox.getSelectedItem();
            long value = 0L;
            if (item instanceof Number) {
                value = ((Number)item).longValue();
            } else {
                try {
                    value = Bits.decode(item.toString(), true);
                }
                catch (Bits.NumberFormatException e) {
                    throw new Editor.EditorParseException(e);
                }
            }
            return value;
        }

        @Override
        public void setValue(Long value) {
            this.comboBox.setSelectedItem(value.toString());
        }
    }

    private static final class IntegerEditor
    extends LabelEditor<Integer> {
        private static final IntegerValue[] DEFAULTS = IntegerEditor.createIntegerValues(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
        private final JComboBox<IntegerValue> comboBox;
        private final Key<Integer> key;

        private static IntegerValue[] createIntegerValues(int ... values) {
            if (values == null) {
                return null;
            }
            IntegerValue[] v = new IntegerValue[values.length];
            for (int i = 0; i < v.length; ++i) {
                v[i] = new IntegerValue(values[i]);
            }
            return v;
        }

        public IntegerEditor(Integer value, Key<Integer> key) {
            this.key = key;
            IntegerValue[] selects = null;
            if (key instanceof Key.KeyInteger) {
                selects = IntegerEditor.createIntegerValues(((Key.KeyInteger)key).getComboBoxValues());
            }
            if (selects == null) {
                selects = DEFAULTS;
            }
            if (key instanceof Key.KeyInteger) {
                selects = IntegerEditor.cleanupSelects((Key.KeyInteger)key, selects);
            }
            this.comboBox = new JComboBox<IntegerValue>(selects);
            this.comboBox.setEditable(true);
            this.comboBox.setSelectedItem(new IntegerValue(value));
        }

        private static IntegerValue[] cleanupSelects(Key.KeyInteger key, IntegerValue[] selects) {
            if (!key.isMinOrMaxSet()) {
                return selects;
            }
            ArrayList<IntegerValue> allowed = new ArrayList<IntegerValue>(selects.length);
            boolean minAdded = false;
            boolean maxAdded = false;
            for (IntegerValue iv : selects) {
                int v = iv.value;
                if (v <= key.getMin()) {
                    if (minAdded) continue;
                    allowed.add(new IntegerValue(key.getMin()));
                    minAdded = true;
                    continue;
                }
                if (v >= key.getMax()) {
                    if (maxAdded) continue;
                    allowed.add(new IntegerValue(key.getMax()));
                    maxAdded = true;
                    continue;
                }
                allowed.add(iv);
            }
            return allowed.toArray(new IntegerValue[0]);
        }

        @Override
        public JComponent getComponent(ElementAttributes attr) {
            return this.comboBox;
        }

        @Override
        public Integer getValue() throws Editor.EditorParseException {
            Object item = this.comboBox.getSelectedItem();
            int value = 0;
            if (item instanceof Number) {
                value = ((Number)item).intValue();
            } else if (item instanceof IntegerValue) {
                value = ((IntegerValue)item).getValue();
            } else {
                try {
                    value = (int)Bits.decode(item.toString());
                }
                catch (Bits.NumberFormatException e) {
                    throw new Editor.EditorParseException(e);
                }
            }
            if (this.key instanceof Key.KeyInteger) {
                int max;
                int min = ((Key.KeyInteger)this.key).getMin();
                if (value < min) {
                    value = min;
                }
                if (value > (max = ((Key.KeyInteger)this.key).getMax())) {
                    value = max;
                }
            }
            return value;
        }

        @Override
        public void setValue(Integer value) {
            this.comboBox.setSelectedItem(new IntegerValue(value));
        }

        private static final class IntegerValue {
            private final int value;

            private IntegerValue(int value) {
                this.value = value;
            }

            private Integer getValue() {
                return this.value;
            }

            public String toString() {
                if (this.value == Integer.MAX_VALUE) {
                    return Lang.get("maxValue", new Object[0]);
                }
                return Integer.toString(this.value);
            }
        }
    }

    static final class StringEditor
    extends LabelEditor<String> {
        private static final String FILE_KEY = "_File";
        private final JTextComponent text;
        private final JComponent compToAdd;
        private final UndoManager undoManager;
        private JPopupMenu popup;

        public StringEditor(String value, final Key<String> key) {
            if (key instanceof Key.LongString) {
                Key.LongString k = (Key.LongString)key;
                this.text = EditorFactory.addF1Traversal(new JTextArea(k.getRows(), k.getColumns()));
                JScrollPane scrollPane = new JScrollPane(this.text);
                if (k.getLineNumbers()) {
                    TextLineNumber textLineNumber = new TextLineNumber(this.text, 3);
                    scrollPane.setRowHeaderView(textLineNumber);
                    this.text.setFont(new Font("Monospaced", 0, Screen.getInstance().getFontSize()));
                }
                this.text.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        this.checkPopup(e);
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        this.checkPopup(e);
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        this.checkPopup(e);
                    }

                    private void checkPopup(MouseEvent e) {
                        if (e.isPopupTrigger()) {
                            this.getPopupMenu(key.getKey()).show(text, e.getX(), e.getY());
                        }
                    }
                });
                this.compToAdd = scrollPane;
                this.setLabelAtTop(true);
            } else {
                this.text = EditorFactory.addF1Traversal(new JTextField(10));
                this.compToAdd = this.text;
            }
            this.text.setText(value);
            this.undoManager = EditorFactory.createUndoManager(this.text);
        }

        JPopupMenu getPopupMenu(String keyName) {
            if (this.popup == null) {
                final String fileKey = keyName + FILE_KEY;
                this.popup = new JPopupMenu();
                this.popup.add(new ToolTipAction(Lang.get("btn_load", new Object[0])){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ElementAttributes attr = this.getAttributeDialog().getModifiedAttributes();
                        MyFileChooser fc = new MyFileChooser();
                        fc.setSelectedFile(attr.getFile(fileKey));
                        if (fc.showOpenDialog(this.getAttributeDialog()) == 0) {
                            File f = fc.getSelectedFile();
                            attr.setFile(fileKey, f);
                            try (FileInputStream in = new FileInputStream(f);){
                                int len;
                                StringBuilder sb = new StringBuilder();
                                byte[] data = new byte[4096];
                                while ((len = ((InputStream)in).read(data)) > 0) {
                                    sb.append(new String(data, 0, len));
                                }
                                text.setText(sb.toString());
                            }
                            catch (IOException e) {
                                new ErrorMessage(Lang.get("msg_errorReadingFile", new Object[0])).addCause(e).show(this.getAttributeDialog());
                            }
                        }
                    }
                }.createJMenuItem());
                this.popup.add(new ToolTipAction(Lang.get("btn_save", new Object[0])){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ElementAttributes attr = this.getAttributeDialog().getModifiedAttributes();
                        MyFileChooser fc = new MyFileChooser();
                        fc.setSelectedFile(attr.getFile(fileKey));
                        if (fc.showSaveDialog(this.getAttributeDialog()) == 0) {
                            File f = fc.getSelectedFile();
                            attr.setFile(fileKey, f);
                            try (FileOutputStream out = new FileOutputStream(f);){
                                String s = text.getText();
                                ((OutputStream)out).write(s.getBytes());
                            }
                            catch (IOException e) {
                                new ErrorMessage(Lang.get("msg_errorWritingFile", new Object[0])).addCause(e).show(this.getAttributeDialog());
                            }
                        }
                    }
                }.createJMenuItem());
            }
            return this.popup;
        }

        @Override
        public JComponent getComponent(ElementAttributes attr) {
            return this.compToAdd;
        }

        @Override
        public String getValue() {
            return this.text.getText().trim();
        }

        @Override
        public void setValue(String value) {
            if (!this.text.getText().equals(value)) {
                this.text.setText(value);
                this.undoManager.discardAllEdits();
            }
        }

        public JTextComponent getTextComponent() {
            return this.text;
        }
    }

    public static abstract class LabelEditor<T>
    implements Editor<T> {
        private AttributeDialog attributeDialog;
        private boolean labelAtTop = false;
        private JComponent component;
        private JLabel label;

        @Override
        public void addToPanel(EditorPanel panel, Key<T> key, ElementAttributes elementAttributes, AttributeDialog attributeDialog) {
            this.attributeDialog = attributeDialog;
            this.label = new JLabel(key.getName() + ":  ");
            String description = new LineBreaker().toHTML().breakLines(key.getDescription());
            this.label.setToolTipText(description);
            this.component = this.getComponent(elementAttributes);
            this.component.setToolTipText(description);
            if (this.labelAtTop) {
                panel.add(this.label, cb -> cb.width(2));
                panel.nextRow();
                panel.add(this.component, cb -> cb.width(2).dynamicWidth().dynamicHeight());
            } else {
                panel.add(this.label);
                panel.add(this.component, cb -> cb.x(1).dynamicWidth());
            }
        }

        public AttributeDialog getAttributeDialog() {
            return this.attributeDialog;
        }

        protected abstract JComponent getComponent(ElementAttributes var1);

        @Override
        public void setEnabled(boolean enabled) {
            this.label.setEnabled(enabled);
            this.component.setEnabled(enabled);
        }

        void setLabelAtTop(boolean labelAtTop) {
            this.labelAtTop = labelAtTop;
        }
    }
}

