/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.IntFormat;
import de.neemann.digital.core.Model;
import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.core.Value;
import de.neemann.digital.core.ValueFormatter;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.importer.Importer;
import de.neemann.digital.gui.SaveAsHelper;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.ErrorMessage;
import de.neemann.gui.MyFileChooser;
import de.neemann.gui.ToolTipAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DataEditor
extends JDialog {
    private static final Color MYGRAY = new Color(230, 230, 230);
    private static File lastUsedFileName;
    private final ValueFormatter addrFormat;
    private final ValueFormatter dataFormat;
    private final int addrBits;
    private final int dataBits;
    private final DataField localDataField;
    private final JTable table;
    private boolean ok = false;
    private File fileName;
    private Node node;

    public DataEditor(Component parent, final DataField dataField, final int dataBits, final int addrBits, boolean modelIsRunning, SyncAccess modelSync, ValueFormatter dataFormat) {
        super(SwingUtilities.windowForComponent(parent), Lang.get("key_Data", new Object[0]), modelIsRunning ? Dialog.ModalityType.MODELESS : Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(2);
        this.addrBits = addrBits;
        this.dataBits = dataBits;
        this.dataFormat = dataFormat;
        this.addrFormat = dataFormat.isSuitedForAddresses() ? dataFormat : IntFormat.HEX_FORMATTER;
        this.localDataField = modelIsRunning ? dataField : new DataField(dataField);
        int size = 1 << addrBits;
        int cols = this.calcCols(size, dataBits, dataFormat);
        int rows = (size - 1) / cols + 1;
        int tableWidth = 0;
        final MyTableModel dm = new MyTableModel(this.localDataField, cols, rows, modelSync);
        this.table = new JTable(dm);
        FontMetrics fontMetrics = this.table.getFontMetrics(this.table.getFont());
        this.table.setRowHeight(fontMetrics.getHeight() * 9 / 8);
        int widthOfZero = fontMetrics.stringWidth("00000000") / 8;
        int widthOfData = widthOfZero * (dataFormat.strLen(dataBits) + 1);
        for (int c = 1; c < this.table.getColumnModel().getColumnCount(); ++c) {
            tableWidth += widthOfData;
            TableColumn col = this.table.getColumnModel().getColumn(c);
            col.setPreferredWidth(widthOfData);
        }
        MyRenderer dataRenderer = new MyRenderer(dataFormat, dataBits);
        dataRenderer.setHorizontalAlignment(4);
        this.table.setDefaultRenderer(Long.class, dataRenderer);
        this.table.setDefaultEditor(Long.class, new MyEditor(dataFormat, dataBits));
        MyRenderer addrRenderer = new MyRenderer(this.addrFormat, addrBits);
        addrRenderer.setBackground(MYGRAY);
        addrRenderer.setHorizontalAlignment(4);
        TableColumn addrColumn = this.table.getColumnModel().getColumn(0);
        addrColumn.setCellRenderer(addrRenderer);
        int widthOfAddr = widthOfZero * (this.addrFormat.strLen(addrBits) + 1);
        addrColumn.setPreferredWidth(widthOfAddr);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.getContentPane().add(scrollPane);
        Dimension dim = this.table.getPreferredScrollableViewportSize();
        scrollPane.setPreferredSize(new Dimension(tableWidth += widthOfAddr, dim.height));
        if (modelIsRunning) {
            dataField.addListener(dm);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    dataField.removeListener(dm);
                }
            });
        } else {
            JPanel buttons = new JPanel(new FlowLayout(2));
            buttons.add(new JButton(new AbstractAction(Lang.get("ok", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DataEditor.this.table.isEditing()) {
                        DataEditor.this.table.getCellEditor().stopCellEditing();
                    } else {
                        DataEditor.this.ok = true;
                        DataEditor.this.dispose();
                    }
                }
            }));
            this.getContentPane().add((Component)buttons, "South");
            JMenuBar menuBar = new JMenuBar();
            JMenu data = new JMenu(Lang.get("menu_file", new Object[0]));
            data.add(new ToolTipAction(Lang.get("btn_clearData", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataEditor.this.localDataField.clearAll();
                    dm.fireEvent(new TableModelEvent(dm));
                }
            }.setToolTip(Lang.get("btn_clearData_tt", new Object[0])).createJMenuItem());
            data.add(new ToolTipAction(Lang.get("btn_load", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyFileChooser fc = new MyFileChooser();
                    JCheckBox bigEndian = new JCheckBox(Lang.get("msg_bigEndian", new Object[0]));
                    if (dataBits > 8) {
                        bigEndian.setToolTipText(Lang.get("key_bigEndian_tt", new Object[0]));
                        fc.setAccessory(bigEndian);
                    }
                    DataEditor.this.setFileNameTo(fc);
                    fc.setFileFilter(new FileNameExtensionFilter("hex", "hex"));
                    if (fc.showOpenDialog(DataEditor.this) == 0) {
                        DataEditor.this.setFileName(fc.getSelectedFile());
                        try {
                            DataField dataRead = Importer.read(fc.getSelectedFile(), dataBits, bigEndian.isSelected()).trimValues(addrBits, dataBits);
                            DataEditor.this.localDataField.setDataFrom(dataRead);
                            dm.fireEvent(new TableModelEvent(dm));
                        }
                        catch (IOException e1) {
                            new ErrorMessage(Lang.get("msg_errorReadingFile", new Object[0])).addCause(e1).show(DataEditor.this);
                        }
                    }
                }
            }.createJMenuItem());
            data.add(new ToolTipAction(Lang.get("btn_save", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyFileChooser fc = new MyFileChooser();
                    DataEditor.this.setFileNameTo(fc);
                    fc.setFileFilter(new FileNameExtensionFilter("hex", "hex"));
                    new SaveAsHelper(DataEditor.this, fc, "hex").checkOverwrite(file -> {
                        DataEditor.this.setFileName(file);
                        DataEditor.this.localDataField.saveTo(file);
                    });
                }
            }.createJMenuItem());
            menuBar.add(data);
            this.setJMenuBar(menuBar);
        }
        new ToolTipAction(Lang.get("menu_paste", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                try {
                    Object data = clpbrd.getData(DataFlavor.stringFlavor);
                    new PasteHandler(data.toString(), DataEditor.this.table).paste();
                }
                catch (UnsupportedFlavorException | IOException e1) {
                    new ErrorMessage(Lang.get("msg_errorPastingData", new Object[0])).addCause(e1).show();
                }
            }
        }.setAcceleratorCTRLplus('V').enableAcceleratorIn(this.table);
        new ToolTipAction(Lang.get("menu_copy", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = DataEditor.this.table.getSelectedRows();
                if (rows.length > 0) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(new StringSelection(((MyTableModel)DataEditor.this.table.getModel()).toString(rows)), null);
                }
            }
        }.setAcceleratorCTRLplus('C').enableAcceleratorIn(this.table);
        this.pack();
        if (this.getWidth() < 150) {
            this.setSize(new Dimension(150, this.getHeight()));
        }
        this.setLocationRelativeTo(parent);
    }

    private int calcCols(int size, int dataBits, ValueFormatter dataFormat) {
        int newCols;
        if (size <= 16) {
            return 1;
        }
        int colWidth = dataFormat.strLen(dataBits);
        int cols = 2;
        while (colWidth * (newCols = cols * 2) <= 100 && size / newCols >= newCols) {
            cols = newCols;
        }
        return cols;
    }

    public DataField getModifiedDataField() {
        this.localDataField.trim();
        return this.localDataField;
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.ok;
    }

    public void showDialog(String label, Model model) {
        if (label.length() > 0) {
            this.setTitle(label);
        }
        this.showDialog();
        if (model != null) {
            model.getWindowPosManager().register("RAM_DATA_" + label, this);
            model.addObserver(event -> {
                if (event.getType().equals((Object)ModelEventType.CLOSED)) {
                    this.detachFromRunningModel();
                }
            }, ModelEventType.CLOSED, new ModelEventType[0]);
        }
    }

    public void detachFromRunningModel() {
        this.table.setForeground(Color.BLUE);
        this.table.setToolTipText(Lang.get("msg_dataNotUpdatedAnymore", new Object[0]));
        this.table.setEnabled(false);
    }

    public void setFileName(File fileName) {
        if (fileName.exists()) {
            this.fileName = fileName;
            lastUsedFileName = fileName;
        }
    }

    private void setFileNameTo(JFileChooser fc) {
        if (this.fileName != null) {
            fc.setSelectedFile(this.fileName);
        } else if (lastUsedFileName != null) {
            fc.setSelectedFile(lastUsedFileName);
        }
    }

    public DataEditor setNode(Node node) {
        this.node = node;
        return this;
    }

    private static final class PasteHandler {
        private final String data;
        private final int yOrigin;
        private final int xOrigin;
        private final MyTableModel model;

        private PasteHandler(String data, JTable table) {
            this.data = data;
            this.xOrigin = table.getSelectedColumn();
            this.yOrigin = table.getSelectedRow();
            this.model = (MyTableModel)table.getModel();
        }

        private void paste() {
            if (this.xOrigin >= 0 && this.yOrigin >= 0) {
                StringTokenizer rows = new StringTokenizer(this.data, "\n\r");
                int y = 0;
                while (rows.hasMoreTokens()) {
                    String line = rows.nextToken();
                    StringTokenizer cols = new StringTokenizer(line, "\t");
                    int x = 0;
                    while (cols.hasMoreTokens()) {
                        String cell = cols.nextToken();
                        this.setData(this.xOrigin + x, this.yOrigin + y, cell.trim());
                        ++x;
                    }
                    ++y;
                }
                this.model.fireEvent(new TableModelEvent(this.model));
            }
        }

        private void setData(int col, int row, String value) {
            Class<?> type;
            if (col < this.model.getColumnCount() && row < this.model.getRowCount() && this.model.isCellEditable(row, col) && (type = this.model.getColumnClass(col)) == Long.class) {
                try {
                    this.model.setValueAt(Bits.decode(value), row, col);
                }
                catch (Bits.NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private static final class MyEditor
    extends DefaultCellEditor {
        private final ValueFormatter intFormat;
        private final int bits;
        private long value;

        private static JTextField createTextField() {
            JTextField tf = new JTextField();
            tf.setHorizontalAlignment(4);
            return tf;
        }

        private MyEditor(ValueFormatter intFormat, int bits) {
            super(MyEditor.createTextField());
            this.intFormat = intFormat;
            this.bits = bits;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object o, boolean isSelected, int row, int col) {
            JTextField editor = (JTextField)super.getTableCellEditorComponent(jTable, o, isSelected, row, col);
            editor.setText(this.intFormat.formatToEdit(new Value((Long)o, this.bits)));
            return editor;
        }

        @Override
        public boolean stopCellEditing() {
            String s = (String)super.getCellEditorValue();
            try {
                this.value = Bits.decode(s);
            }
            catch (Exception e) {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }
    }

    private static final class MyRenderer
    extends DefaultTableCellRenderer {
        private final ValueFormatter intFormat;
        private final int bits;

        private MyRenderer(ValueFormatter intFormat, int bits) {
            this.intFormat = intFormat;
            this.bits = bits;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            long val = 0L;
            if (value != null) {
                val = ((Number)value).longValue();
            }
            this.setText(this.intFormat.formatToView(new Value(val, this.bits)));
            return this;
        }
    }

    private final class MyTableModel
    implements TableModel,
    DataField.DataListener {
        private final DataField dataField;
        private final int cols;
        private final SyncAccess modelSync;
        private final int rows;
        private final ArrayList<TableModelListener> listener = new ArrayList();

        private MyTableModel(DataField dataField, int cols, int rows, SyncAccess modelSync) {
            this.dataField = dataField;
            this.cols = cols;
            this.rows = rows;
            this.modelSync = modelSync;
        }

        @Override
        public int getRowCount() {
            return this.rows;
        }

        @Override
        public int getColumnCount() {
            return this.cols + 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return Lang.get("addr", new Object[0]);
            }
            if (this.cols > 1) {
                return DataEditor.this.addrFormat.formatToView(new Value(columnIndex - 1, DataEditor.this.addrBits));
            }
            return Lang.get("key_Value", new Object[0]);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Long.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return rowIndex * this.cols;
            }
            return this.dataField.getDataWord(rowIndex * this.cols + (columnIndex - 1));
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            long decode = (Long)aValue;
            this.modelSync.modify(() -> {
                int addr = rowIndex * this.cols + (columnIndex - 1);
                boolean modified = this.dataField.setData(addr, decode);
                if (modified && DataEditor.this.node != null) {
                    DataEditor.this.node.hasChanged();
                }
            });
        }

        private void fireEvent(TableModelEvent e) {
            for (TableModelListener l : this.listener) {
                l.tableChanged(e);
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listener.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listener.remove(l);
        }

        @Override
        public void valueChanged(int addr) {
            if (addr < 0) {
                this.fireEvent(new TableModelEvent(this));
            } else {
                this.fireEvent(new TableModelEvent(this, addr / this.cols));
            }
        }

        public String toString(int[] rows) {
            StringBuilder sb = new StringBuilder();
            for (int r : rows) {
                int offs = r * this.cols;
                sb.append(DataEditor.this.addrFormat.formatToEdit(new Value(offs, DataEditor.this.addrBits)));
                for (int c = 0; c < this.cols; ++c) {
                    long val = this.dataField.getDataWord(offs + c);
                    sb.append("\t").append(DataEditor.this.dataFormat.formatToEdit(new Value(val, DataEditor.this.dataBits)));
                }
                sb.append(System.lineSeparator());
            }
            return sb.toString();
        }
    }
}

