/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.shapes.custom.CustomShapeDescription;
import de.neemann.digital.draw.shapes.custom.svg.SvgException;
import de.neemann.digital.draw.shapes.custom.svg.SvgImporter;
import de.neemann.digital.draw.shapes.custom.svg.SvgTemplate;
import de.neemann.digital.gui.Main;
import de.neemann.digital.gui.SaveAsHelper;
import de.neemann.digital.gui.components.EditorFactory;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.ErrorMessage;
import de.neemann.gui.MyFileChooser;
import de.neemann.gui.ToolTipAction;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class CustomShapeEditor
extends EditorFactory.LabelEditor<CustomShapeDescription> {
    private CustomShapeDescription customShapeDescription;
    private ToolTipAction clear;
    private ToolTipAction load;
    private ToolTipAction template;
    private static File lastSVGFile;

    public CustomShapeEditor(CustomShapeDescription customShapeDescription, Key<CustomShapeDescription> key) {
        this.customShapeDescription = customShapeDescription;
    }

    @Override
    public JComponent getComponent(ElementAttributes attr) {
        JPanel panel = new JPanel(new GridLayout(1, 2));
        this.clear = new ToolTipAction(Lang.get("btn_clearData", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomShapeEditor.this.customShapeDescription = new CustomShapeDescription.Builder().build();
            }
        };
        panel.add(this.clear.createJButton());
        this.load = new ToolTipAction(Lang.get("btn_loadSvg", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = CustomShapeEditor.this.getjFileChooser();
                if (fc.showOpenDialog(CustomShapeEditor.this.getAttributeDialog()) == 0) {
                    lastSVGFile = fc.getSelectedFile();
                    try {
                        CustomShapeDescription csd = new SvgImporter(fc.getSelectedFile()).create();
                        Main main = CustomShapeEditor.this.getAttributeDialog().getMain();
                        if (main != null) {
                            csd.checkCompatibility(main.getCircuitComponent().getCircuit());
                            CustomShapeEditor.this.customShapeDescription = csd;
                        }
                    }
                    catch (PinException | SvgException | IOException e1) {
                        new ErrorMessage(Lang.get("msg_errorImportingSvg", new Object[0])).addCause(e1).show(CustomShapeEditor.this.getAttributeDialog());
                    }
                }
            }
        }.setToolTip(Lang.get("btn_loadSvg_tt", new Object[0]));
        panel.add(this.load.createJButton());
        this.template = new ToolTipAction(Lang.get("btn_saveTemplate", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                block8: {
                    JFileChooser fc = CustomShapeEditor.this.getjFileChooser();
                    if (fc.showSaveDialog(CustomShapeEditor.this.getAttributeDialog()) == 0) {
                        try {
                            Main main = CustomShapeEditor.this.getAttributeDialog().getMain();
                            if (main == null) break block8;
                            File file = SaveAsHelper.checkSuffix(fc.getSelectedFile(), "svg");
                            lastSVGFile = file;
                            try (SvgTemplate tc = new SvgTemplate(file, main.getCircuitComponent().getCircuit());){
                                tc.create();
                            }
                        }
                        catch (Exception e1) {
                            new ErrorMessage(Lang.get("msg_errorCreatingSvgTemplate", new Object[0])).addCause(e1).show(CustomShapeEditor.this.getAttributeDialog());
                        }
                    }
                }
            }
        }.setToolTip(Lang.get("btn_saveTemplate_tt", new Object[0]));
        panel.add(this.template.createJButton());
        return panel;
    }

    private JFileChooser getjFileChooser() {
        File path = null;
        if (lastSVGFile == null) {
            lastSVGFile = SaveAsHelper.checkSuffix(this.getAttributeDialog().getMain().getBaseFileName(), "svg");
        }
        if (lastSVGFile != null) {
            path = lastSVGFile.getParentFile();
        }
        MyFileChooser fc = new MyFileChooser(path);
        if (lastSVGFile != null) {
            fc.setSelectedFile(lastSVGFile);
        }
        return fc;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.load.setEnabled(enabled);
        this.clear.setEnabled(enabled);
        this.template.setEnabled(enabled);
    }

    @Override
    public CustomShapeDescription getValue() {
        return this.customShapeDescription;
    }

    @Override
    public void setValue(CustomShapeDescription value) {
    }
}

