/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components;

import java.awt.GridBagConstraints;
import java.awt.Insets;

public class ConstraintsBuilder
extends GridBagConstraints {
    public ConstraintsBuilder() {
        this.gridx = 0;
        this.gridy = 0;
    }

    private ConstraintsBuilder(ConstraintsBuilder original) {
        this.gridx = original.gridx;
        this.gridy = original.gridy;
        this.gridwidth = original.gridwidth;
        this.gridheight = original.gridheight;
        this.weightx = original.weightx;
        this.weighty = original.weighty;
        this.ipadx = original.ipadx;
        this.ipady = original.ipady;
        this.fill = original.fill;
        this.insets = original.insets;
    }

    public ConstraintsBuilder pos(int x, int y) {
        ConstraintsBuilder c = new ConstraintsBuilder(this);
        c.gridx = x;
        c.gridy = y;
        return c;
    }

    public ConstraintsBuilder x(int x) {
        ConstraintsBuilder c = new ConstraintsBuilder(this);
        c.gridx = x;
        return c;
    }

    public ConstraintsBuilder width(int x) {
        ConstraintsBuilder c = new ConstraintsBuilder(this);
        c.gridwidth = x;
        return c;
    }

    public ConstraintsBuilder dynamicHeight() {
        ConstraintsBuilder c = new ConstraintsBuilder(this);
        c.weighty = 1.0;
        return c;
    }

    public ConstraintsBuilder dynamicWidth() {
        ConstraintsBuilder c = new ConstraintsBuilder(this);
        c.weightx = 1.0;
        return c;
    }

    public ConstraintsBuilder pad(int x, int y) {
        ConstraintsBuilder c = new ConstraintsBuilder(this);
        c.ipadx = x;
        c.ipady = y;
        return c;
    }

    public ConstraintsBuilder fill() {
        ConstraintsBuilder c = new ConstraintsBuilder(this);
        c.fill = 1;
        return c;
    }

    public ConstraintsBuilder inset(int b) {
        ConstraintsBuilder c = new ConstraintsBuilder(this);
        c.insets = new Insets(b, b, b, b);
        return c;
    }

    public ConstraintsBuilder nextRow() {
        this.gridx = 0;
        ++this.gridy;
        return this;
    }
}

