/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.draw.graphics.ColorKey;
import de.neemann.digital.draw.graphics.ColorScheme;
import de.neemann.digital.gui.components.EditorFactory;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.ToolTipAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public class ColorSchemeEditor
extends EditorFactory.LabelEditor<ColorScheme> {
    private ColorScheme colorScheme;

    public ColorSchemeEditor(ColorScheme colorScheme, Key<ColorScheme> key) {
        this.colorScheme = colorScheme;
    }

    @Override
    public ColorScheme getValue() {
        return this.colorScheme;
    }

    @Override
    public void setValue(ColorScheme value) {
        this.colorScheme = value;
    }

    @Override
    protected JComponent getComponent(ElementAttributes elementAttributes) {
        return new JButton(new AbstractAction(Lang.get("btn_edit", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new SchemeEditor(ColorSchemeEditor.this.colorScheme).setVisible(true);
            }
        });
    }

    private static final class ColorButton
    extends JButton {
        private final ColorScheme.Builder builder;
        private final ColorKey ck;

        private ColorButton(final ColorScheme.Builder builder, final ColorKey ck) {
            super(Lang.get("colorName_" + ck.name(), new Object[0]));
            this.builder = builder;
            this.ck = ck;
            this.setColor(builder.getColor(ck));
            this.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(this, Lang.get("msg_color", new Object[0]), builder.getColor(ck));
                    if (color != null) {
                        builder.set(ck, color);
                        this.setColor(color);
                    }
                }
            });
        }

        private void updateColor() {
            this.setColor(this.builder.getColor(this.ck));
        }

        private void setColor(Color color) {
            this.setBackground(color);
            float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            if ((double)hsb[2] < 0.7) {
                this.setForeground(Color.WHITE);
            } else {
                this.setForeground(Color.BLACK);
            }
        }
    }

    private final class SchemeEditor
    extends JDialog {
        private final ColorScheme.Builder builder;
        private final ArrayList<ColorButton> colorButtons;

        private SchemeEditor(ColorScheme colorScheme) {
            super((Frame)null, Lang.get("key_customColorScheme", new Object[0]), true);
            this.setDefaultCloseOperation(2);
            this.builder = new ColorScheme.Builder(colorScheme);
            this.colorButtons = new ArrayList();
            JPanel colors = new JPanel(new GridLayout(ColorKey.values().length, 1));
            for (ColorKey ck : ColorKey.values()) {
                ColorButton colorButton = new ColorButton(this.builder, ck);
                this.colorButtons.add(colorButton);
                colors.add(colorButton);
            }
            this.getContentPane().add(colors);
            JPanel buttons = new JPanel(new FlowLayout(2));
            buttons.add(new ToolTipAction(Lang.get("cancel", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SchemeEditor.this.dispose();
                }
            }.createJButton());
            buttons.add(new ToolTipAction(Lang.get("ok", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColorSchemeEditor.this.setValue(SchemeEditor.this.builder.build());
                    SchemeEditor.this.dispose();
                }
            }.createJButton());
            JMenu preset = new JMenu(Lang.get("menu_colorSchemePreset", new Object[0]));
            for (ColorScheme.ColorSchemes cs : ColorScheme.ColorSchemes.values()) {
                if (cs.equals((Object)ColorScheme.ColorSchemes.CUSTOM)) continue;
                preset.add(new PresetAction(cs).createJMenuItem());
            }
            JMenuBar bar = new JMenuBar();
            bar.add(preset);
            this.setJMenuBar(bar);
            this.getContentPane().add((Component)buttons, "South");
            this.pack();
            this.setLocationRelativeTo(null);
        }

        private final class PresetAction
        extends ToolTipAction {
            private final ColorScheme.ColorSchemes cs;

            private PresetAction(ColorScheme.ColorSchemes cs) {
                super(Lang.get("key_colorScheme_" + cs.name(), new Object[0]));
                this.cs = cs;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SchemeEditor.this.builder.set(this.cs.getScheme());
                for (ColorButton cb : SchemeEditor.this.colorButtons) {
                    cb.updateColor();
                }
            }
        }
    }
}

