/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.Movable;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.shapes.ShapeFactory;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;

public class CircuitTransferable
implements Transferable {
    private String data;

    CircuitTransferable(ArrayList<Movable> data) {
        XStream xStream = Circuit.getxStream();
        try (StringWriter out = new StringWriter();){
            out.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            xStream.marshal(data, new PrettyPrintWriter(out));
            this.data = out.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == DataFlavor.stringFlavor;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this.data;
    }

    public static ArrayList<Movable> createList(Object data, ShapeFactory shapeFactory) throws IOException {
        if (!(data instanceof String)) {
            return null;
        }
        XStream xStream = Circuit.getxStream();
        try (StringReader in = new StringReader(data.toString());){
            ArrayList elements = (ArrayList)xStream.fromXML(in);
            if (elements == null) {
                ArrayList<Movable> arrayList = null;
                return arrayList;
            }
            for (Movable m : elements) {
                if (!(m instanceof VisualElement)) continue;
                ((VisualElement)m).setShapeFactory(shapeFactory);
            }
            ArrayList arrayList = elements;
            return arrayList;
        }
    }
}

