/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components;

import de.neemann.digital.draw.graphics.GraphicMinMax;
import de.neemann.digital.gui.components.CircuitComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class CircuitScrollPanel
extends JPanel {
    private static final int BORDER = 200;
    private final CircuitComponent circuitComponent;
    private final JScrollBar horizontal = new JScrollBar(0);
    private final JScrollBar vertical = new JScrollBar(1);
    private GraphicMinMax graphicMinMax;
    private AffineTransform transform;

    public CircuitScrollPanel(CircuitComponent circuitComponent) {
        super(new BorderLayout());
        this.circuitComponent = circuitComponent;
        this.add((Component)circuitComponent, "Center");
        this.add((Component)this.horizontal, "South");
        this.add((Component)this.vertical, "East");
        this.horizontal.addAdjustmentListener(adjustmentEvent -> {
            if (adjustmentEvent.getValueIsAdjusting() && this.transform != null) {
                circuitComponent.translateCircuitToX((double)(-adjustmentEvent.getValue()) * this.transform.getScaleX());
            }
        });
        this.vertical.addAdjustmentListener(adjustmentEvent -> {
            if (adjustmentEvent.getValueIsAdjusting() && this.transform != null) {
                circuitComponent.translateCircuitToY((double)(-adjustmentEvent.getValue()) * this.transform.getScaleY());
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (CircuitScrollPanel.this.transform != null) {
                    CircuitScrollPanel.this.updateBars();
                }
            }
        });
        circuitComponent.setCircuitScrollPanel(this);
    }

    private GraphicMinMax getCircuitSize() {
        if (this.graphicMinMax == null) {
            this.graphicMinMax = new GraphicMinMax();
            this.circuitComponent.getCircuit().drawTo(this.graphicMinMax);
        }
        return this.graphicMinMax;
    }

    void sizeChanged() {
        this.graphicMinMax = null;
        if (this.transform != null) {
            this.updateBars();
        }
    }

    void transformChanged(AffineTransform transform) {
        this.transform = transform;
        this.updateBars();
    }

    private void updateBars() {
        GraphicMinMax gr = this.getCircuitSize();
        if (gr.getMin() == null || gr.getMax() == null || !this.circuitComponent.isManualScale()) {
            this.horizontal.setVisible(false);
            this.vertical.setVisible(false);
        } else {
            Point2D.Float min = new Point2D.Float();
            Point2D.Float max = new Point2D.Float();
            try {
                this.transform.inverseTransform(new Point2D.Float(0.0f, 0.0f), min);
                this.transform.inverseTransform(new Point2D.Float(this.getWidth(), this.getHeight()), max);
                this.setValues(this.horizontal, ((Point2D)min).getX(), ((Point2D)max).getX(), gr.getMin().x, gr.getMax().x);
                this.setValues(this.vertical, ((Point2D)min).getY(), ((Point2D)max).getY(), gr.getMin().y, gr.getMax().y);
            }
            catch (NoninvertibleTransformException e) {
                e.printStackTrace();
            }
        }
    }

    private void setValues(JScrollBar bar, double viewMin, double viewMax, int circuitMin, int circuitMax) {
        int border = Math.max(200, (circuitMax - circuitMin) / 10);
        int extent = (int)(viewMax - viewMin);
        bar.setValues((int)viewMin, extent, circuitMin -= border, circuitMax += border);
        bar.setVisible(viewMin > (double)circuitMin || viewMax < (double)circuitMax);
    }

    int getBarWidth() {
        return this.vertical.getPreferredSize().width;
    }
}

