/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui;

import de.neemann.digital.lang.Lang;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public final class WindowManager {
    private final ArrayList<FrameHolder> list = new ArrayList();

    public static WindowManager getInstance() {
        return InstanceHolderClass.INSTANCE;
    }

    private WindowManager() {
    }

    public JMenu registerAndCreateMenu(JFrame frame) {
        FrameHolder frameHolder = new FrameHolder(frame);
        this.list.add(frameHolder);
        this.update();
        return frameHolder.getMenu(this.list);
    }

    private void remove(FrameHolder holder) {
        this.list.remove(holder);
        this.update();
    }

    private void update() {
        for (FrameHolder wh : this.list) {
            wh.update(this.list);
        }
    }

    private static final class FrameHolder {
        private final JFrame frame;
        private JMenu menu;

        private FrameHolder(JFrame frame) {
            this.frame = frame;
            frame.addPropertyChangeListener(propertyChangeEvent -> {
                if (propertyChangeEvent.getPropertyName().equals("title")) {
                    WindowManager.getInstance().update();
                }
            });
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    WindowManager.getInstance().remove(this);
                }
            });
        }

        public String getTitle() {
            return this.frame.getTitle();
        }

        public void update(ArrayList<FrameHolder> list) {
            if (this.menu != null) {
                this.menu.removeAll();
                for (FrameHolder wh : list) {
                    this.menu.add(wh.createItem());
                }
            }
        }

        private JMenuItem createItem() {
            return new JMenuItem(new AbstractAction(this.frame.getTitle()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    frame.setVisible(true);
                    frame.toFront();
                }
            });
        }

        private JMenu getMenu(ArrayList<FrameHolder> list) {
            if (this.menu == null) {
                this.menu = new JMenu(Lang.get("menu_window", new Object[0]));
                this.update(list);
            }
            return this.menu;
        }
    }

    private static final class InstanceHolderClass {
        private static final WindowManager INSTANCE = new WindowManager();

        private InstanceHolderClass() {
        }
    }
}

