/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import de.neemann.digital.core.element.AttributeListener;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.draw.elements.Circuit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsBase
implements AttributeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsBase.class);
    private final ElementAttributes attributes;
    private final File filename;
    private final List<Key> settingsKeys;

    protected SettingsBase(List<Key> settingsKeys, String name) {
        this.settingsKeys = settingsKeys;
        File defaultSettings = new File(new File(System.getProperty("user.home")), name);
        String settingsDir = System.getenv("XDG_CONFIG_HOME");
        this.filename = defaultSettings.isFile() || settingsDir == null ? defaultSettings : new File(settingsDir, name);
        ElementAttributes attr = null;
        if (this.filename.exists()) {
            XStream xStream = Circuit.getxStream();
            try (FileInputStream in = new FileInputStream(this.filename);){
                attr = (ElementAttributes)xStream.fromXML(in);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            LOGGER.debug("no settings file: " + this.filename);
        }
        if (attr == null) {
            LOGGER.debug("Use default settings!");
            this.attributes = new ElementAttributes();
        } else {
            this.attributes = attr;
        }
        this.attributes.addListener(this);
    }

    public ElementAttributes getAttributes() {
        return this.attributes;
    }

    public <VALUE> VALUE get(Key<VALUE> key) {
        return this.attributes.get(key);
    }

    @Override
    public void attributeChanged() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("write settings " + this.filename);
        }
        XStream xStream = Circuit.getxStream();
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.filename), StandardCharsets.UTF_8);){
            out.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            xStream.marshal(this.attributes, new PrettyPrintWriter(out));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Key> getKeys() {
        return this.settingsKeys;
    }
}

