/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.draw.graphics.ColorScheme;
import de.neemann.digital.gui.SettingsBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Settings
extends SettingsBase {
    public static Settings getInstance() {
        return SettingsHolder.INSTANCE;
    }

    private Settings() {
        super(Settings.createKeyList(), ".digital.cfg");
    }

    private static List<Key> createKeyList() {
        ArrayList<Key<Object>> intList = new ArrayList<Key<Object>>();
        intList.add(Keys.SETTINGS_IEEE_SHAPES);
        intList.add(Keys.SETTINGS_LANGUAGE);
        intList.add(Keys.SETTINGS_EXPRESSION_FORMAT);
        intList.add(ColorScheme.COLOR_SCHEME);
        intList.add(ColorScheme.CUSTOM_COLOR_SCHEME);
        intList.add(Keys.SETTINGS_DEFAULT_TREESELECT);
        intList.add(Keys.SETTINGS_GRID);
        intList.add(Keys.SETTINGS_SHOW_WIRE_BITS);
        intList.add(Keys.SETTINGS_WIRETOOLTIP);
        intList.add(Keys.SETTINGS_LIBRARY_PATH);
        intList.add(Keys.SETTINGS_JAR_PATH);
        intList.add(Keys.SETTINGS_ATF1502_FITTER);
        intList.add(Keys.SETTINGS_ATMISP);
        intList.add(Keys.SETTINGS_GHDL_PATH);
        intList.add(Keys.SETTINGS_IVERILOG_PATH);
        intList.add(Keys.SETTINGS_TOOLCHAIN_CONFIG);
        intList.add(Keys.SETTINGS_FONT_SCALING);
        intList.add(Keys.SETTINGS_MAC_MOUSE);
        intList.add(Keys.SETTINGS_USE_EQUALS_KEY);
        intList.add(Keys.SETTINGS_RENAME_LABELS);
        intList.add(Keys.SETTINGS_SHOW_TUNNEL_RENAME_DIALOG);
        intList.add(Keys.SETTINGS_OPEN_REMOTE_PORT);
        intList.add(Keys.SETTINGS_REMOTE_PORT);
        return Collections.unmodifiableList(intList);
    }

    public boolean requiresRestart(ElementAttributes modified) {
        for (Key key : this.getKeys()) {
            if (!key.getRequiresRestart() || this.getAttributes().equalsKey(key, modified)) continue;
            return true;
        }
        return false;
    }

    public boolean requiresRepaint(ElementAttributes modified) {
        for (Key key : this.getKeys()) {
            if (!key.getRequiresRepaint() || this.getAttributes().equalsKey(key, modified)) continue;
            return true;
        }
        return false;
    }

    private static final class SettingsHolder {
        static final Settings INSTANCE = new Settings();

        private SettingsHolder() {
        }
    }
}

