/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.ProgramMemory;
import de.neemann.digital.core.memory.importer.Importer;
import de.neemann.digital.core.memory.importer.MultiValueArray;
import de.neemann.digital.gui.ModelModifier;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProgramMemoryLoader
implements ModelModifier {
    private final File romHex;
    private final boolean bigEndian;

    public ProgramMemoryLoader(File romHex, boolean bigEndian) {
        this.romHex = romHex;
        this.bigEndian = bigEndian;
    }

    @Override
    public void preInit(Model model) throws NodeException {
        List<Node> progMem = model.findNode(n -> n instanceof ProgramMemory && ((ProgramMemory)((Object)n)).isProgramMemory());
        try {
            switch (progMem.size()) {
                case 0: {
                    throw new NodeException(Lang.get("err_noRomFound", new Object[0]), new ObservableValue[0]);
                }
                case 1: {
                    ProgramMemory memory = (ProgramMemory)((Object)progMem.get(0));
                    memory.setProgramMemory(Importer.read(this.romHex, memory.getDataBits(), this.bigEndian));
                }
            }
            Comparator<Node> comparator = Comparator.comparing(n -> ((ProgramMemory)((Object)n)).getLabel());
            for (Node n2 : progMem) {
                for (Node node : progMem) {
                    if (n2 == node || comparator.compare(n2, node) != 0) continue;
                    throw new NodeException(Lang.get("err_ProgMemLabelsNotDifferent", new Object[0]), new ObservableValue[0]);
                }
            }
            progMem.sort(comparator);
            MultiValueArray.Builder builder = new MultiValueArray.Builder();
            HashMap<ProgramMemory, DataField> memMap = new HashMap<ProgramMemory, DataField>();
            for (Node node : progMem) {
                ProgramMemory mem = (ProgramMemory)((Object)node);
                DataField df = new DataField(1024);
                builder.add(df, mem.getDataBits());
                memMap.put(mem, df);
            }
            Importer.read(this.romHex, builder.build(), this.bigEndian);
            for (Map.Entry entry : memMap.entrySet()) {
                ((ProgramMemory)entry.getKey()).setProgramMemory((DataField)entry.getValue());
            }
        }
        catch (MultiValueArray.ValueArrayException | IOException e) {
            throw new NodeException(Lang.get("err_errorLoadingRomData", new Object[0]), e);
        }
    }
}

