/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui;

import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.io.In;
import de.neemann.digital.core.io.Out;
import de.neemann.digital.core.wiring.Clock;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.gui.components.CircuitComponent;
import de.neemann.digital.gui.components.modification.ModifyAttribute;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.Screen;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class NumberingWizard
extends JDialog
implements CircuitComponent.WizardNotification {
    private final CircuitComponent circuitComponent;
    private final JLabel label;
    private int pinNumber;

    public NumberingWizard(JFrame parent, final CircuitComponent circuitComponent) {
        super(parent, Lang.get("msg_numberingWizard", new Object[0]), false);
        this.setDefaultCloseOperation(2);
        this.circuitComponent = circuitComponent;
        this.label = new JLabel();
        this.label.setFont(Screen.getInstance().getFont(1.5f));
        int b = Screen.getInstance().getFontSize();
        this.label.setBorder(BorderFactory.createEmptyBorder(b, b, b, b));
        this.setPinNumber(999);
        this.getContentPane().add(this.label);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                circuitComponent.deactivateWizard();
            }
        });
        this.pack();
        this.pinNumber = 1;
        this.setPinNumber(this.pinNumber);
        this.setLocation(parent.getLocation());
    }

    private void setPinNumber(int num) {
        this.label.setText(Lang.get("msg_pin_numbering_N", num));
    }

    public void start() {
        this.setVisible(true);
        this.circuitComponent.activateWizard(this);
    }

    @Override
    public void notify(VisualElement clicked) {
        if (clicked.equalsDescription(In.DESCRIPTION) || clicked.equalsDescription(Clock.DESCRIPTION) || clicked.equalsDescription(Out.DESCRIPTION)) {
            this.circuitComponent.modify(new ModifyAttribute<String>(clicked, Keys.PINNUMBER, Integer.toString(this.pinNumber)));
            ++this.pinNumber;
            this.setPinNumber(this.pinNumber);
        }
    }

    @Override
    public void closed() {
        this.dispose();
    }
}

