/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui;

import de.neemann.digital.FileLocator;
import de.neemann.digital.analyse.AnalyseException;
import de.neemann.digital.analyse.ModelAnalyser;
import de.neemann.digital.analyse.SubstituteLibrary;
import de.neemann.digital.analyse.TruthTable;
import de.neemann.digital.core.BacktrackException;
import de.neemann.digital.core.BurnException;
import de.neemann.digital.core.Model;
import de.neemann.digital.core.ModelEvent;
import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.ModelStateObserverTyped;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.SpeedTest;
import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.io.Button;
import de.neemann.digital.core.io.In;
import de.neemann.digital.core.io.InValue;
import de.neemann.digital.core.io.Out;
import de.neemann.digital.core.io.PowerSupply;
import de.neemann.digital.core.io.Probe;
import de.neemann.digital.core.memory.ProgramCounter;
import de.neemann.digital.core.stats.Statistics;
import de.neemann.digital.core.wiring.AsyncSeq;
import de.neemann.digital.core.wiring.Clock;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.ElementOrder;
import de.neemann.digital.draw.elements.Movable;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.elements.Wire;
import de.neemann.digital.draw.gif.GifExporter;
import de.neemann.digital.draw.graphics.ColorScheme;
import de.neemann.digital.draw.graphics.Export;
import de.neemann.digital.draw.graphics.ExportFactory;
import de.neemann.digital.draw.graphics.GraphicSVG;
import de.neemann.digital.draw.graphics.GraphicsImage;
import de.neemann.digital.draw.graphics.SVGSettings;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.draw.library.ElementTypeDescriptionCustom;
import de.neemann.digital.draw.model.AsyncSequentialClock;
import de.neemann.digital.draw.model.ModelCreator;
import de.neemann.digital.draw.model.RealTimeClock;
import de.neemann.digital.draw.shapes.Drawable;
import de.neemann.digital.draw.shapes.ShapeFactory;
import de.neemann.digital.fsm.gui.FSMFrame;
import de.neemann.digital.gui.DigitalRemoteInterface;
import de.neemann.digital.gui.DigitalUncaughtExceptionHandler;
import de.neemann.digital.gui.DocumentationLocator;
import de.neemann.digital.gui.ExportZipAction;
import de.neemann.digital.gui.FileHistory;
import de.neemann.digital.gui.InsertAction;
import de.neemann.digital.gui.InsertHistory;
import de.neemann.digital.gui.LibrarySelector;
import de.neemann.digital.gui.ModelModifier;
import de.neemann.digital.gui.NumberingWizard;
import de.neemann.digital.gui.ProgramMemoryLoader;
import de.neemann.digital.gui.SaveAsHelper;
import de.neemann.digital.gui.SearchTextField;
import de.neemann.digital.gui.Settings;
import de.neemann.digital.gui.StatsDialog;
import de.neemann.digital.gui.StatusInterface;
import de.neemann.digital.gui.TextSearchFilter;
import de.neemann.digital.gui.WindowManager;
import de.neemann.digital.gui.components.AttributeDialog;
import de.neemann.digital.gui.components.BehavioralFixtureCreator;
import de.neemann.digital.gui.components.CircuitComponent;
import de.neemann.digital.gui.components.CircuitModifierPostClosed;
import de.neemann.digital.gui.components.CircuitScrollPanel;
import de.neemann.digital.gui.components.CircuitTransferable;
import de.neemann.digital.gui.components.ElementHelpDialog;
import de.neemann.digital.gui.components.ElementOrderer;
import de.neemann.digital.gui.components.OrderMerger;
import de.neemann.digital.gui.components.ProbeDialog;
import de.neemann.digital.gui.components.WindowPosManager;
import de.neemann.digital.gui.components.data.GraphDialog;
import de.neemann.digital.gui.components.expression.ExpressionDialog;
import de.neemann.digital.gui.components.modification.ModifyAttribute;
import de.neemann.digital.gui.components.modification.ModifyMeasurementOrdering;
import de.neemann.digital.gui.components.table.TableDialog;
import de.neemann.digital.gui.components.terminal.Keyboard;
import de.neemann.digital.gui.components.terminal.KeyboardDialog;
import de.neemann.digital.gui.components.testing.TestAllDialog;
import de.neemann.digital.gui.components.testing.ValueTableDialog;
import de.neemann.digital.gui.components.tree.LibraryTreeModel;
import de.neemann.digital.gui.components.tree.SelectTree;
import de.neemann.digital.gui.release.CheckForNewRelease;
import de.neemann.digital.gui.remote.DigitalHandler;
import de.neemann.digital.gui.remote.RemoteException;
import de.neemann.digital.gui.remote.RemoteSever;
import de.neemann.digital.gui.state.State;
import de.neemann.digital.gui.state.StateManager;
import de.neemann.digital.gui.tutorial.InitialTutorial;
import de.neemann.digital.hdl.printer.CodePrinter;
import de.neemann.digital.hdl.verilog2.VerilogGenerator;
import de.neemann.digital.hdl.vhdl2.VHDLGenerator;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.TestingDataException;
import de.neemann.digital.toolchain.Configuration;
import de.neemann.digital.undo.ChangedListener;
import de.neemann.digital.undo.Modifications;
import de.neemann.gui.ClosingWindowListener;
import de.neemann.gui.ErrorMessage;
import de.neemann.gui.IconCreator;
import de.neemann.gui.InfoDialog;
import de.neemann.gui.MyFileChooser;
import de.neemann.gui.Screen;
import de.neemann.gui.ToolTipAction;
import de.neemann.gui.WindowSizeStorage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main
extends JFrame
implements ClosingWindowListener.ConfirmSave,
FileHistory.OpenInterface,
DigitalRemoteInterface,
StatusInterface,
ChangedListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);
    private static final String KEY_START_STOP_ACTION = "startStop";
    private static boolean experimental;
    private static final String MESSAGE;
    private static final Icon ICON_RUN;
    private static final Icon ICON_MICRO;
    private static final Icon ICON_TEST;
    private static final Icon ICON_STEP;
    private static final Icon ICON_STEP_FINISH;
    private static final Icon ICON_STOP;
    private static final Icon ICON_NEW;
    private static final Icon ICON_NEW_SUB;
    private static final Icon ICON_OPEN;
    private static final Icon ICON_OPEN_WIN;
    private static final Icon ICON_SAVE;
    private static final Icon ICON_SAVE_AS;
    private static final Icon ICON_FAST;
    private static final Icon ICON_EXPAND;
    private static final Icon ICON_ZOOM_IN;
    private static final Icon ICON_ZOOM_OUT;
    private static final Icon ICON_HELP;
    private final CircuitComponent circuitComponent;
    private final CircuitScrollPanel circuitScrollPanel;
    private final ToolTipAction save;
    private final ElementLibrary library;
    private final ShapeFactory shapeFactory;
    private final JLabel statusLabel;
    private final StateManager stateManager = new StateManager();
    private final ScheduledThreadPoolExecutor timerExecutor = new ScheduledThreadPoolExecutor(1);
    private final WindowPosManager windowPosManager;
    private final InsertHistory insertHistory;
    private final boolean keepPrefMainFile;
    private final FileHistory fileHistory;
    private ToolTipAction doMicroStep;
    private ToolTipAction runToBreakMicroAction;
    private ToolTipAction runToBreakAction;
    private ToolTipAction showMeasurementDialog;
    private ToolTipAction showMeasurementGraph;
    private ToolTipAction runTests;
    private File baseFilename;
    private File filename;
    private boolean modifiedPrefixVisible = false;
    private Model model;
    private ModelCreator modelCreator;
    private boolean realTimeClockRunning;
    private State stoppedState;
    private RunModelState runModelState;
    private State runModelMicroState;
    private JComponent componentOnPane;
    private LibraryTreeModel treeModel;

    public static boolean isExperimentalMode() {
        return experimental;
    }

    private Main(MainBuilder builder) {
        super(Lang.get("digital", new Object[0]));
        this.setDefaultCloseOperation(0);
        this.setIconImages(IconCreator.createImages("icon32.png", "icon64.png", "icon128.png"));
        this.windowPosManager = new WindowPosManager(this);
        this.keepPrefMainFile = builder.keepPrefMainFile;
        if (builder.library != null) {
            this.library = builder.library;
        } else {
            this.library = new ElementLibrary(Settings.getInstance().get(Keys.SETTINGS_JAR_PATH));
            Exception e = this.library.checkForException();
            if (e != null) {
                SwingUtilities.invokeLater(new ErrorMessage(Lang.get("err_loadingLibrary", new Object[0])).addCause(e).setComponent(this));
            }
        }
        this.shapeFactory = new ShapeFactory(this.library, Settings.getInstance().get(Keys.SETTINGS_IEEE_SHAPES));
        this.fileHistory = new FileHistory(this);
        this.baseFilename = builder.baseFileName;
        this.circuitComponent = new CircuitComponent(this, this.library, this.shapeFactory);
        this.circuitComponent.addListener(this);
        if (builder.circuit != null) {
            LOGGER.debug("create with given circuit: " + builder.circuit.getOrigin());
            SwingUtilities.invokeLater(() -> this.circuitComponent.setCircuit(builder.circuit));
            this.setFilename(builder.fileToOpen, false);
        } else if (builder.fileToOpen != null) {
            LOGGER.debug("create with given file " + builder.fileToOpen);
            SwingUtilities.invokeLater(() -> this.loadFile(builder.fileToOpen, builder.library == null, builder.library == null));
        } else {
            File name = this.fileHistory.getMostRecent();
            LOGGER.debug("create with history file " + name);
            if (name != null) {
                SwingUtilities.invokeLater(() -> this.loadFile(name, true, false));
            }
        }
        this.circuitScrollPanel = new CircuitScrollPanel(this.circuitComponent);
        this.library.addListener(this.circuitComponent);
        this.getContentPane().add(this.circuitScrollPanel);
        this.componentOnPane = this.circuitScrollPanel;
        this.circuitComponent.addKeyListener(new ModelKeyListener());
        this.statusLabel = new JLabel(" ");
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(0, Screen.getInstance().getFontSize() * 2 / 3, 0, 0));
        this.getContentPane().add((Component)this.statusLabel, "South");
        this.setupStates();
        JMenuBar menuBar = new JMenuBar();
        JToolBar toolBar = new JToolBar();
        this.save = this.createFileMenu(menuBar, toolBar, builder.allowAllFileActions);
        toolBar.addSeparator();
        this.createEditMenu(menuBar);
        this.createViewMenu(menuBar, toolBar, builder.presentationMode);
        this.circuitComponent.setPresentationMode(builder.presentationMode);
        toolBar.addSeparator();
        toolBar.add(this.circuitComponent.getUndoAction().createJButtonNoText());
        toolBar.add(this.circuitComponent.getRedoAction().createJButtonNoText());
        toolBar.add(this.circuitComponent.getDeleteAction().createJButtonNoText());
        toolBar.addSeparator();
        this.createStartMenu(menuBar, toolBar);
        this.createAnalyseMenu(menuBar);
        toolBar.addSeparator();
        this.insertHistory = new InsertHistory(toolBar, this.library);
        this.library.addListener(this.insertHistory);
        final LibrarySelector librarySelector = new LibrarySelector(this.library, this.shapeFactory);
        this.library.addListener(librarySelector);
        menuBar.add(librarySelector.buildMenu(this.insertHistory, this.circuitComponent));
        menuBar.add(WindowManager.getInstance().registerAndCreateMenu(this));
        JMenu helpMenu = new JMenu(Lang.get("menu_help", new Object[0]));
        helpMenu.add(new ToolTipAction(Lang.get("menu_help_elements", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    new ElementHelpDialog(Main.this, Main.this.library, Main.this.shapeFactory).setVisible(true);
                }
                catch (NodeException | PinException e) {
                    new ErrorMessage(Lang.get("msg_creatingHelp", new Object[0])).addCause(e).show(Main.this);
                }
            }
        }.setToolTip(Lang.get("menu_help_elements_tt", new Object[0])).createJMenuItem());
        new DocumentationLocator().addMenuTo(helpMenu);
        helpMenu.addSeparator();
        helpMenu.add(InfoDialog.getInstance().createMenuItem(this, MESSAGE));
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
        this.addWindowListener(new ClosingWindowListener(this, this));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Main.this.clearModelDescription();
                Main.this.timerExecutor.shutdown();
                Main.this.library.removeListener(librarySelector);
                Main.this.library.removeListener(Main.this.insertHistory);
                Main.this.library.removeListener(Main.this.circuitComponent);
                if (Main.this.treeModel != null) {
                    Main.this.library.removeListener(Main.this.treeModel);
                }
                Main.this.windowPosManager.shutdown();
            }
        });
        this.getContentPane().add((Component)toolBar, "North");
        new ToolTipAction("insertLast"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InsertAction lastInsertAction = Main.this.insertHistory.getLastInsertAction();
                if (lastInsertAction != null && Main.this.model == null) {
                    lastInsertAction.actionPerformed(actionEvent);
                }
            }
        }.setAccelerator("L").enableAcceleratorIn(this.circuitComponent);
        this.enableClockShortcut();
        new WindowSizeStorage(builder.mainFrame ? "main" : "sub").restore(this);
        if (builder.parent != null) {
            Point p = builder.parent.getLocation();
            float d = 20.0f * Screen.getInstance().getScaling();
            p.x = (int)((float)p.x + d);
            p.y = (int)((float)p.y + d);
            Screen.setLocation(this, p, false);
        } else {
            this.setLocationRelativeTo(null);
        }
        this.checkIDEIntegration(builder, menuBar);
    }

    private void checkIDEIntegration(MainBuilder builder, JMenuBar menuBar) {
        File f;
        if (builder.mainFrame && (f = Settings.getInstance().get(Keys.SETTINGS_TOOLCHAIN_CONFIG)).getPath().length() > 0) {
            try {
                menuBar.add(Configuration.load(f).setCircuitProvider(() -> this.getCircuitComponent().getCircuit()).setFilenameProvider(() -> {
                    this.saveChanges();
                    return this.filename;
                }).setLibraryProvider(() -> this.library).createMenu(this));
            }
            catch (IOException e) {
                SwingUtilities.invokeLater(new ErrorMessage(Lang.get("msg_errorReadingToolchainConfig_N", f.getPath())).addCause(e).setComponent(this));
            }
        }
    }

    private void enableClockShortcut() {
        new ToolTipAction("doClock"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Main.this.model != null && !Main.this.realTimeClockRunning) {
                    if (Main.this.stateManager.isActive(Main.this.runModelMicroState)) {
                        if (Main.this.doMicroStep.isEnabled()) {
                            Main.this.model.doMicroStep(false);
                        } else {
                            ArrayList<Clock> cl = Main.this.model.getClocks();
                            if (cl.size() == 1) {
                                Main.this.model.modifyWithoutDoStep(() -> {
                                    ObservableValue clkVal;
                                    clkVal.setBool(!(clkVal = ((Clock)cl.get(0)).getClockOutput()).getBool());
                                });
                            }
                        }
                    } else {
                        ArrayList<Clock> cl = Main.this.model.getClocks();
                        if (cl.size() == 1) {
                            Main.this.model.modify(() -> {
                                ObservableValue clkVal;
                                clkVal.setBool(!(clkVal = ((Clock)cl.get(0)).getClockOutput()).getBool());
                            });
                        }
                    }
                }
            }
        }.setAccelerator("C").enableAcceleratorIn(this.circuitComponent);
    }

    private void createViewMenu(JMenuBar menuBar, JToolBar toolBar, boolean presentationModeDefault) {
        ToolTipAction maximize = new ToolTipAction(Lang.get("menu_maximize", new Object[0]), ICON_EXPAND){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.circuitComponent.fitCircuit();
            }
        }.setAccelerator("F1");
        ToolTipAction zoomIn = new ToolTipAction(Lang.get("menu_zoomIn", new Object[0]), ICON_ZOOM_IN){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.circuitComponent.scaleCircuit(1.1111111111111112);
            }
        }.setAcceleratorCTRLplus("PLUS").enableAcceleratorIn(this.circuitComponent);
        this.circuitComponent.getInputMap().put(KeyStroke.getKeyStroke(107, ToolTipAction.getCTRLMask()), zoomIn);
        ToolTipAction zoomOut = new ToolTipAction(Lang.get("menu_zoomOut", new Object[0]), ICON_ZOOM_OUT){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.circuitComponent.scaleCircuit(0.9);
            }
        }.setAcceleratorCTRLplus("MINUS").enableAcceleratorIn(this.circuitComponent);
        this.circuitComponent.getInputMap().put(KeyStroke.getKeyStroke(109, ToolTipAction.getCTRLMask()), zoomOut);
        ToolTipAction viewHelp = new ToolTipAction(Lang.get("menu_viewHelp", new Object[0]), ICON_HELP){

            @Override
            public void actionPerformed(ActionEvent e) {
                Circuit circuit = Main.this.circuitComponent.getCircuit();
                String name = Lang.get("msg_actualCircuit", new Object[0]);
                File file = Main.this.filename;
                if (file == null) {
                    file = new File(name);
                }
                try {
                    ElementTypeDescriptionCustom description = ElementLibrary.createCustomDescription(file, circuit, Main.this.library);
                    description.setShortName(name);
                    description.setDescription(Lang.evalMultilingualContent(circuit.getAttributes().get(Keys.DESCRIPTION)));
                    new ElementHelpDialog((Window)Main.this, description, circuit.getAttributes()).setVisible(true);
                }
                catch (NodeException | PinException e1) {
                    new ErrorMessage(Lang.get("msg_creatingHelp", new Object[0])).addCause(e1).show(Main.this);
                }
            }
        }.setToolTip(Lang.get("menu_viewHelp_tt", new Object[0]));
        JCheckBoxMenuItem treeCheckBox = new JCheckBoxMenuItem(Lang.get("menu_treeSelect", new Object[0]));
        treeCheckBox.setToolTipText(Lang.get("menu_treeSelect_tt", new Object[0]));
        treeCheckBox.addActionListener(actionEvent -> {
            this.getContentPane().remove(this.componentOnPane);
            if (treeCheckBox.isSelected()) {
                JSplitPane split = new JSplitPane(1);
                split.getInputMap(1).put(KeyStroke.getKeyStroke(117, 0), "digNone");
                this.treeModel = new LibraryTreeModel(this.library);
                split.setLeftComponent(this.createTreeComponent());
                split.setRightComponent(this.circuitScrollPanel);
                this.getContentPane().add(split);
                this.componentOnPane = split;
            } else {
                if (this.treeModel != null) {
                    this.treeModel.close();
                    this.treeModel = null;
                }
                this.getContentPane().add(this.circuitScrollPanel);
                this.componentOnPane = this.circuitScrollPanel;
            }
            this.revalidate();
        });
        treeCheckBox.setAccelerator(KeyStroke.getKeyStroke("F5"));
        JCheckBoxMenuItem presentationMode = new JCheckBoxMenuItem(Lang.get("menu_presentationMode", new Object[0]));
        presentationMode.setSelected(presentationModeDefault);
        presentationMode.setToolTipText(Lang.get("menu_presentationMode_tt", new Object[0]));
        presentationMode.addActionListener(actionEvent -> this.circuitComponent.setPresentationMode(presentationMode.isSelected()));
        presentationMode.setAccelerator(KeyStroke.getKeyStroke("F4"));
        ToolTipAction tutorial = new ToolTipAction(Lang.get("menu_tutorial", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ClosingWindowListener.checkForSave(Main.this, Main.this)) {
                    Main.this.clearPane();
                    new InitialTutorial(Main.this).setVisible(true);
                }
            }
        }.setToolTip(Lang.get("menu_tutorial_tt", new Object[0]));
        if (Settings.getInstance().get(Keys.SETTINGS_DEFAULT_TREESELECT).booleanValue()) {
            SwingUtilities.invokeLater(treeCheckBox::doClick);
        }
        toolBar.add(viewHelp.createJButtonNoText());
        toolBar.add(zoomIn.createJButtonNoText());
        toolBar.add(zoomOut.createJButtonNoText());
        toolBar.add(maximize.createJButtonNoText());
        JMenu scaleMenu = new JMenu(Lang.get("menu_scale", new Object[0]));
        for (int i = 0; i < 10; ++i) {
            final int f = 20 + i * 20;
            scaleMenu.add(new JMenuItem(new AbstractAction(f + "%"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Main.this.getCircuitComponent().setScale((float)f / 100.0f);
                }
            }));
        }
        JMenu view = new JMenu(Lang.get("menu_view", new Object[0]));
        menuBar.add(view);
        view.add(maximize.createJMenuItem());
        view.add(zoomOut.createJMenuItem());
        view.add(zoomIn.createJMenuItem());
        view.add(scaleMenu);
        view.addSeparator();
        view.add(treeCheckBox);
        view.add(presentationMode);
        view.addSeparator();
        view.add(tutorial.createJMenuItem());
        view.addSeparator();
        view.add(viewHelp.createJMenuItem());
    }

    private JComponent createTreeComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel field = new JPanel(new BorderLayout());
        final SearchTextField textField = new SearchTextField();
        field.add(textField);
        JButton clearButton = new JButton(new AbstractAction("\u2717"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                textField.setText("");
            }
        });
        clearButton.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        field.add((Component)clearButton, "East");
        panel.add((Component)field, "North");
        textField.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        final SelectTree tree = new SelectTree(this.treeModel, this.circuitComponent, this.shapeFactory, this.insertHistory);
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                String text = textField.getText().trim();
                if (text.isEmpty()) {
                    Main.this.treeModel = new LibraryTreeModel(Main.this.library);
                } else {
                    Main.this.treeModel = new LibraryTreeModel(Main.this.library, new TextSearchFilter(text));
                }
                tree.setModel(Main.this.treeModel);
            }
        });
        panel.add(new JScrollPane(tree));
        return panel;
    }

    private void clearPane() {
        this.circuitComponent.setCircuit(new Circuit());
        this.setFilename(null, true);
        this.windowPosManager.closeAll();
        try {
            this.library.setRootFilePath(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ToolTipAction createFileMenu(JMenuBar menuBar, JToolBar toolBar, boolean allowAll) {
        ToolTipAction newFile = new ToolTipAction(Lang.get("menu_new", new Object[0]), ICON_NEW){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ClosingWindowListener.checkForSave(Main.this, Main.this)) {
                    Main.this.clearPane();
                }
            }
        }.setAcceleratorCTRLplus('N').setToolTip(Lang.get("menu_new_tt", new Object[0])).setEnabledChain(allowAll);
        ToolTipAction newSubFile = new ToolTipAction(Lang.get("menu_newSub", new Object[0]), ICON_NEW_SUB){

            @Override
            public void actionPerformed(ActionEvent e) {
                new MainBuilder().setParent(Main.this).setLibrary(Main.this.library).setCircuit(new Circuit()).setBaseFileName(Main.this.getBaseFileName()).keepPrefMainFile().build().setVisible(true);
            }
        }.setToolTip(Lang.get("menu_newSub_tt", new Object[0]));
        ToolTipAction open = new ToolTipAction(Lang.get("menu_open", new Object[0]), ICON_OPEN){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ClosingWindowListener.checkForSave(Main.this, Main.this)) {
                    JFileChooser fc = Main.getJFileChooser(Main.this.baseFilename);
                    fc.addChoosableFileFilter(new FileNameExtensionFilter("FSM", "fsm"));
                    fc.addChoosableFileFilter(new FileNameExtensionFilter(Lang.get("msg_truthTable", new Object[0]), "tru"));
                    if (fc.showOpenDialog(Main.this) == 0) {
                        File file = fc.getSelectedFile();
                        if (file.getName().endsWith(".fsm")) {
                            new FSMFrame(Main.this, Main.this.library, file).setVisible(true);
                        } else if (file.getName().endsWith(".tru")) {
                            try {
                                new TableDialog((Window)Main.this, TruthTable.readFromFile(file), Main.this.library, Main.this.filename).setVisible(true);
                            }
                            catch (IOException ex) {
                                new ErrorMessage().addCause(ex).show(Main.this);
                            }
                        } else {
                            Main.this.loadFile(file, true, true);
                        }
                    }
                }
            }
        }.setAcceleratorCTRLplus('O').setEnabledChain(allowAll);
        ToolTipAction openWin = new ToolTipAction(Lang.get("menu_openWin", new Object[0]), ICON_OPEN_WIN){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = Main.getJFileChooser(Main.this.baseFilename);
                if (fc.showOpenDialog(Main.this) == 0) {
                    new MainBuilder().setParent(Main.this).setFileToOpen(fc.getSelectedFile()).build().setVisible(true);
                }
            }
        }.setToolTip(Lang.get("menu_openWin_tt", new Object[0])).setEnabledChain(allowAll);
        JMenu openRecent = new JMenu(Lang.get("menu_openRecent", new Object[0]));
        JMenu openRecentNewWindow = new JMenu(Lang.get("menu_openRecentNewWindow", new Object[0]));
        this.fileHistory.setMenu(openRecent, openRecentNewWindow);
        openRecent.setEnabled(allowAll);
        openRecentNewWindow.setEnabled(allowAll);
        final ToolTipAction saveAs = new ToolTipAction(Lang.get("menu_saveAs", new Object[0]), ICON_SAVE_AS){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = Main.getJFileChooser(Main.this.baseFilename);
                SaveAsHelper saveAsHelper = new SaveAsHelper(Main.this, fc, "dig");
                saveAsHelper.checkOverwrite(file -> {
                    if (Main.this.library.isFileAccessible(file)) {
                        Main.this.saveFile(file, !Main.this.keepPrefMainFile);
                    } else {
                        Object[] options = new Object[]{Lang.get("btn_saveAnyway", new Object[0]), Lang.get("btn_newName", new Object[0]), Lang.get("cancel", new Object[0])};
                        int res = JOptionPane.showOptionDialog(Main.this, Lang.get("msg_fileNotAccessible", new Object[0]), Lang.get("msg_warning", new Object[0]), -1, 2, null, options, options[0]);
                        switch (res) {
                            case 0: {
                                Main.this.saveFile(file, true);
                                Main.this.library.setRootFilePath(file.getParentFile());
                                if (Main.this.library.getWarningMessage() == null) break;
                                SwingUtilities.invokeLater(new ErrorMessage(Main.this.library.getWarningMessage().toString()).setComponent(Main.this));
                                break;
                            }
                            case 1: {
                                saveAsHelper.retryFileSelect();
                            }
                        }
                    }
                });
            }
        };
        ToolTipAction save = new ToolTipAction(Lang.get("menu_save", new Object[0]), ICON_SAVE){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Main.this.filename == null) {
                    saveAs.actionPerformed(e);
                } else {
                    Main.this.saveFile(Main.this.filename, false);
                }
            }
        }.setAcceleratorCTRLplus('S').setEnabledChain(false);
        JMenu export = new JMenu(Lang.get("menu_export", new Object[0]));
        export.add(new ExportAction(Lang.get("menu_exportSVG", new Object[0]), "svg", GraphicSVG::new));
        export.add(new ToolTipAction(Lang.get("menu_exportSVGSettings", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ElementAttributes modified = new AttributeDialog((Window)Main.this, SVGSettings.getInstance().getKeys(), SVGSettings.getInstance().getAttributes()).showDialog();
                SVGSettings.getInstance().getAttributes().getValuesFrom(modified);
            }
        });
        export.addSeparator();
        export.add(new ExportAction(Lang.get("menu_exportPNGSmall", new Object[0]), "png", out -> new GraphicsImage(out, "PNG", 1.0f)));
        export.add(new ExportAction(Lang.get("menu_exportPNGLarge", new Object[0]), "png", out -> new GraphicsImage(out, "PNG", 2.0f)));
        if (Main.isExperimentalMode()) {
            export.add(new ExportGifAction(Lang.get("menu_exportAnimatedGIF", new Object[0])));
        }
        export.addSeparator();
        export.add(this.createVHDLExportAction().createJMenuItem());
        export.add(this.createVerilogExportAction().createJMenuItem());
        export.addSeparator();
        export.add(new ExportZipAction(this).createJMenuItem());
        JMenu file = new JMenu(Lang.get("menu_file", new Object[0]));
        menuBar.add(file);
        file.add(newFile.createJMenuItem());
        file.add(newSubFile.createJMenuItem());
        file.add(open.createJMenuItem());
        file.add(openRecent);
        file.add(openWin.createJMenuItem());
        file.add(openRecentNewWindow);
        file.add(save.createJMenuItem());
        file.add(saveAs.createJMenuItem());
        file.add(export);
        toolBar.add(newFile.createJButtonNoText());
        toolBar.add(open.createJButtonNoText());
        toolBar.add(save.createJButtonNoText());
        return save;
    }

    private ToolTipAction createVHDLExportAction() {
        return new ToolTipAction(Lang.get("menu_exportVHDL", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ElementAttributes settings;
                File exportDir;
                try {
                    new ModelCreator(Main.this.circuitComponent.getCircuit(), Main.this.library).createModel(false).close();
                }
                catch (NodeException | PinException | ElementNotFoundException | RuntimeException e) {
                    Main.this.showError(Lang.get("msg_modelHasErrors", new Object[0]), e);
                    return;
                }
                MyFileChooser fc = new MyFileChooser();
                if (Main.this.filename != null) {
                    fc.setSelectedFile(SaveAsHelper.checkSuffix(Main.this.filename, "vhdl"));
                }
                if ((exportDir = (settings = Settings.getInstance().getAttributes()).getFile("exportDirectory")) != null) {
                    fc.setCurrentDirectory(exportDir);
                }
                fc.addChoosableFileFilter(new FileNameExtensionFilter("VHDL", "vhdl"));
                new SaveAsHelper(Main.this, fc, "vhdl").checkOverwrite(file -> {
                    settings.setFile("exportDirectory", file.getParentFile());
                    try (VHDLGenerator vhdl = new VHDLGenerator(Main.this.library, new CodePrinter(file));){
                        vhdl.export(Main.this.circuitComponent.getCircuit());
                    }
                });
            }
        }.setToolTip(Lang.get("menu_exportVHDL_tt", new Object[0]));
    }

    private ToolTipAction createVerilogExportAction() {
        return new ToolTipAction(Lang.get("menu_exportVerilog", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ElementAttributes settings;
                File exportDir;
                try {
                    new ModelCreator(Main.this.circuitComponent.getCircuit(), Main.this.library).createModel(false);
                }
                catch (NodeException | PinException | ElementNotFoundException e) {
                    Main.this.showError(Lang.get("msg_modelHasErrors", new Object[0]), e);
                    return;
                }
                MyFileChooser fc = new MyFileChooser();
                if (Main.this.filename != null) {
                    fc.setSelectedFile(SaveAsHelper.checkSuffix(Main.this.filename, "v"));
                }
                if ((exportDir = (settings = Settings.getInstance().getAttributes()).getFile("exportDirectory")) != null) {
                    fc.setCurrentDirectory(exportDir);
                }
                fc.addChoosableFileFilter(new FileNameExtensionFilter("Verilog", "v"));
                new SaveAsHelper(Main.this, fc, "v").checkOverwrite(file -> {
                    settings.setFile("exportDirectory", file.getParentFile());
                    try (VerilogGenerator vlog = new VerilogGenerator(Main.this.library, new CodePrinter(file));){
                        vlog.export(Main.this.circuitComponent.getCircuit());
                    }
                });
            }
        }.setToolTip(Lang.get("menu_exportVerilog_tt", new Object[0]));
    }

    public File getBaseFileName() {
        if (this.filename != null) {
            return this.filename;
        }
        return this.baseFilename;
    }

    public CircuitComponent getCircuitComponent() {
        return this.circuitComponent;
    }

    public ElementLibrary getLibrary() {
        return this.library;
    }

    private void createEditMenu(JMenuBar menuBar) {
        JMenu edit = new JMenu(Lang.get("menu_edit", new Object[0]));
        menuBar.add(edit);
        ToolTipAction orderInputs = new ToolTipAction(Lang.get("menu_orderInputs", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Main.this.getCircuitComponent().isLocked()) {
                    ElementOrder o = new ElementOrder(Main.this.circuitComponent, element -> element.equalsDescription(In.DESCRIPTION) || element.equalsDescription(Clock.DESCRIPTION), Lang.get("menu_orderInputs", new Object[0]));
                    if (new ElementOrderer<String>((Window)Main.this, Lang.get("menu_orderInputs", new Object[0]), o).addOkButton().showDialog()) {
                        Main.this.circuitComponent.modify(o.getModifications());
                    }
                }
            }
        }.setToolTip(Lang.get("menu_orderInputs_tt", new Object[0]));
        ToolTipAction orderOutputs = new ToolTipAction(Lang.get("menu_orderOutputs", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Main.this.getCircuitComponent().isLocked()) {
                    ElementOrder o = new ElementOrder(Main.this.circuitComponent, element -> element.equalsDescription(Out.DESCRIPTION), Lang.get("menu_orderOutputs", new Object[0]));
                    if (new ElementOrderer<String>((Window)Main.this, Lang.get("menu_orderOutputs", new Object[0]), o).addOkButton().showDialog()) {
                        Main.this.circuitComponent.modify(o.getModifications());
                    }
                }
            }
        }.setToolTip(Lang.get("menu_orderOutputs_tt", new Object[0]));
        ToolTipAction orderMeasurements = new ToolTipAction(Lang.get("menu_orderMeasurements", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Main.this.getCircuitComponent().isLocked()) {
                    Main.this.orderMeasurements();
                }
            }
        }.setToolTip(Lang.get("menu_orderMeasurements_tt", new Object[0]));
        ToolTipAction editAttributes = new ToolTipAction(Lang.get("menu_editAttributes", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.circuitComponent.editCircuitAttributes();
            }
        }.setToolTip(Lang.get("menu_editAttributes_tt", new Object[0]));
        ToolTipAction editSettings = new ToolTipAction(Lang.get("menu_editSettings", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                ElementAttributes modified = new AttributeDialog((Window)Main.this, Settings.getInstance().getKeys(), Settings.getInstance().getAttributes()).setDialogTitle(Lang.get("menu_editSettings", new Object[0])).showDialog();
                if (modified != null) {
                    ColorScheme.updateCustomColorScheme(modified);
                    if (Settings.getInstance().requiresRestart(modified)) {
                        Lang.setLanguage(modified.get(Keys.SETTINGS_LANGUAGE));
                        JOptionPane.showMessageDialog(Main.this, Lang.get("msg_restartNeeded", new Object[0]));
                    }
                    if (Settings.getInstance().requiresRepaint(modified)) {
                        Main.this.circuitComponent.graphicHasChanged();
                    }
                    Settings.getInstance().getAttributes().getValuesFrom(modified);
                }
            }
        }.setToolTip(Lang.get("menu_editSettings_tt", new Object[0]));
        ToolTipAction actualToDefault = new ToolTipAction(Lang.get("menu_actualToDefault", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Main.this.getCircuitComponent().isLocked()) {
                    Main.this.circuitComponent.currentToDefault();
                    Main.this.ensureModelIsStopped();
                }
            }
        }.setToolTip(Lang.get("menu_actualToDefault_tt", new Object[0]));
        ToolTipAction restoreAllFuses = new ToolTipAction(Lang.get("menu_restoreAllFuses", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.circuitComponent.restoreAllFuses();
                Main.this.ensureModelIsStopped();
            }
        }.setToolTip(Lang.get("menu_restoreAllFuses_tt", new Object[0]));
        ToolTipAction insertAsNew = new ToolTipAction(Lang.get("menu_insertAsNew", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                try {
                    ArrayList<Movable> elements;
                    Object data = clipboard.getData(DataFlavor.stringFlavor);
                    if (data instanceof String && (elements = CircuitTransferable.createList(data, Main.this.shapeFactory)) != null) {
                        Circuit circuit = new Circuit();
                        for (Movable m : elements) {
                            if (m instanceof Wire) {
                                circuit.add((Wire)m);
                            }
                            if (!(m instanceof VisualElement)) continue;
                            circuit.add((VisualElement)m);
                        }
                        new MainBuilder().setParent(Main.this).setLibrary(Main.this.library).setCircuit(circuit).setBaseFileName(Main.this.getBaseFileName()).keepPrefMainFile().build().setVisible(true);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    SwingUtilities.invokeLater(new ErrorMessage(Lang.get("msg_clipboardContainsNoImportableData", new Object[0])).setComponent(Main.this));
                }
            }
        }.setToolTip(Lang.get("menu_insertAsNew_tt", new Object[0]));
        ToolTipAction labelPins = new ToolTipAction(Lang.get("menu_labelPins", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.circuitComponent.labelPins();
                Main.this.ensureModelIsStopped();
            }
        }.setToolTip(Lang.get("menu_labelPins_tt", new Object[0]));
        ToolTipAction createTestCaseAction = new CreateTestCaseAction(Lang.get("menu_createBehavioralFixture", new Object[0])).setToolTip(Lang.get("menu_createBehavioralFixture_tt", new Object[0]));
        ToolTipAction find = new ToolTipAction(Lang.get("menu_find", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String search = JOptionPane.showInputDialog(Lang.get("menu_find", new Object[0]));
                if (search != null && !search.isEmpty()) {
                    ArrayList<VisualElement> found = Main.this.getCircuitComponent().getCircuit().findElements(search);
                    Main.this.getCircuitComponent().removeHighLighted();
                    Main.this.getCircuitComponent().addHighLighted(found);
                }
            }
        }.setAcceleratorCTRLplus('F').enableAcceleratorIn(this.getCircuitComponent()).setToolTip(Lang.get("menu_find_tt", new Object[0]));
        edit.add(this.circuitComponent.getUndoAction().createJMenuItemNoIcon());
        edit.add(this.circuitComponent.getRedoAction().createJMenuItemNoIcon());
        edit.addSeparator();
        edit.add(editAttributes.createJMenuItem());
        edit.add(actualToDefault.createJMenuItem());
        edit.add(restoreAllFuses.createJMenuItem());
        edit.add(this.createSpecialEditMenu());
        edit.add(labelPins.createJMenuItem());
        edit.addSeparator();
        edit.add(createTestCaseAction.createJMenuItem());
        edit.addSeparator();
        edit.add(orderInputs.createJMenuItem());
        edit.add(orderOutputs.createJMenuItem());
        edit.add(orderMeasurements.createJMenuItem());
        edit.addSeparator();
        edit.add(this.circuitComponent.getCutAction().createJMenuItem());
        edit.add(this.circuitComponent.getCopyAction().createJMenuItem());
        edit.add(this.circuitComponent.getPasteAction().createJMenuItem());
        edit.add(this.circuitComponent.getRotateAction().createJMenuItem());
        edit.add(insertAsNew.createJMenuItem());
        edit.add(find.createJMenuItem());
        edit.addSeparator();
        edit.add(editSettings.createJMenuItem());
    }

    private JMenu createSpecialEditMenu() {
        JMenu special = new JMenu(Lang.get("menu_special", new Object[0]));
        special.add(new ToolTipAction(Lang.get("menu_addPrefix", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String prefix;
                if (!Main.this.circuitComponent.isLocked() && (prefix = JOptionPane.showInputDialog(Lang.get("menu_addPrefix", new Object[0]))) != null && prefix.length() > 0) {
                    Modifications.Builder<Circuit> builder = new Modifications.Builder<Circuit>(Lang.get("menu_addPrefix", new Object[0]));
                    for (Drawable d : Main.this.circuitComponent.getHighLighted()) {
                        VisualElement v;
                        if (!(d instanceof VisualElement) || !(v = (VisualElement)d).equalsDescription(In.DESCRIPTION) && !v.equalsDescription(Out.DESCRIPTION)) continue;
                        ElementAttributes attr = v.getElementAttributes();
                        String l = prefix + attr.getLabel();
                        builder.add(new ModifyAttribute<String>(v, Keys.LABEL, l));
                    }
                    Main.this.circuitComponent.modify(builder.build());
                }
            }
        }.setToolTip(Lang.get("menu_addPrefix_tt", new Object[0])).createJMenuItem());
        special.add(new ToolTipAction(Lang.get("menu_removePrefix", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!Main.this.circuitComponent.isLocked()) {
                    Modifications.Builder<Circuit> builder = new Modifications.Builder<Circuit>(Lang.get("menu_removePrefix", new Object[0]));
                    for (Drawable d : Main.this.circuitComponent.getHighLighted()) {
                        ElementAttributes attr;
                        String l;
                        VisualElement v;
                        if (!(d instanceof VisualElement) || !(v = (VisualElement)d).equalsDescription(In.DESCRIPTION) && !v.equalsDescription(Out.DESCRIPTION) || (l = (attr = v.getElementAttributes()).getLabel()).length() <= 1) continue;
                        builder.add(new ModifyAttribute<String>(v, Keys.LABEL, l.substring(1)));
                    }
                    Main.this.circuitComponent.modify(builder.build());
                }
            }
        }.setToolTip(Lang.get("menu_removePrefix_tt", new Object[0])).createJMenuItem());
        special.add(new ToolTipAction(Lang.get("menu_numbering", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!Main.this.circuitComponent.isLocked()) {
                    new NumberingWizard(Main.this, Main.this.circuitComponent).start();
                }
            }
        }.setToolTip(Lang.get("menu_numbering_tt", new Object[0])).createJMenuItem());
        special.add(new ToolTipAction(Lang.get("menu_removePinNumbers", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!Main.this.circuitComponent.isLocked()) {
                    Modifications.Builder<Circuit> builder = new Modifications.Builder<Circuit>(Lang.get("menu_removePinNumbers", new Object[0]));
                    for (VisualElement v : Main.this.circuitComponent.getCircuit().getElements()) {
                        ElementAttributes attr;
                        String p;
                        if (!v.equalsDescription(In.DESCRIPTION) && !v.equalsDescription(Clock.DESCRIPTION) && !v.equalsDescription(Out.DESCRIPTION) || (p = (attr = v.getElementAttributes()).get(Keys.PINNUMBER)).length() <= 0) continue;
                        builder.add(new ModifyAttribute<String>(v, Keys.PINNUMBER, ""));
                    }
                    Main.this.circuitComponent.modify(builder.build());
                }
            }
        }.setToolTip(Lang.get("menu_removePinNumbers_tt", new Object[0])).createJMenuItem());
        special.add(new ToolTipAction(Lang.get("menu_addPowerSupply", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!Main.this.circuitComponent.isLocked()) {
                    int maxNum = 0;
                    HashSet<Integer> pinsUsed = new HashSet<Integer>();
                    for (VisualElement v : Main.this.circuitComponent.getCircuit().getElements()) {
                        if (!v.equalsDescription(In.DESCRIPTION) && !v.equalsDescription(Out.DESCRIPTION)) continue;
                        int pin = v.getElementAttributes().getIntPinNumber();
                        maxNum = Math.max(maxNum, pin);
                        pinsUsed.add(pin);
                    }
                    int guessedVCC = 0;
                    int guessedGND = 0;
                    if (maxNum & true) {
                        guessedVCC = ++maxNum;
                        guessedGND = maxNum / 2;
                    }
                    if (pinsUsed.contains(guessedGND) || pinsUsed.contains(guessedVCC)) {
                        guessedGND = 0;
                        guessedVCC = 0;
                    }
                    ArrayList<Movable> list = new ArrayList<Movable>();
                    list.add(new VisualElement(PowerSupply.DESCRIPTION.getName()).setShapeFactory(Main.this.shapeFactory).setPos(new Vector(40, 0)));
                    VisualElement vcc = new VisualElement(In.DESCRIPTION.getName()).setShapeFactory(Main.this.shapeFactory).setAttribute(Keys.LABEL, "VCC").setAttribute(Keys.INPUT_DEFAULT, new InValue(1L)).setPos(new Vector(0, 0));
                    if (guessedVCC > 0) {
                        vcc.setAttribute(Keys.PINNUMBER, Integer.toString(guessedVCC));
                    }
                    list.add(vcc);
                    VisualElement gnd = new VisualElement(In.DESCRIPTION.getName()).setShapeFactory(Main.this.shapeFactory).setAttribute(Keys.LABEL, "GND").setPos(new Vector(0, 40));
                    if (guessedGND > 0) {
                        gnd.setAttribute(Keys.PINNUMBER, Integer.toString(guessedGND));
                    }
                    list.add(gnd);
                    list.add(new Wire(new Vector(0, 0), new Vector(40, 0)));
                    list.add(new Wire(new Vector(0, 40), new Vector(20, 40)));
                    list.add(new Wire(new Vector(20, 40), new Vector(20, 20)));
                    list.add(new Wire(new Vector(20, 20), new Vector(40, 20)));
                    Main.this.circuitComponent.setPartsToInsert(list, null);
                }
            }
        }.setToolTip(Lang.get("menu_addPowerSupply_tt", new Object[0])).createJMenuItem());
        return special;
    }

    private void createStartMenu(JMenuBar menuBar, JToolBar toolBar) {
        this.doMicroStep = new ToolTipAction(Lang.get("menu_step", new Object[0]), ICON_STEP){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.model.doMicroStep(false);
            }
        }.setToolTip(Lang.get("menu_step_tt", new Object[0])).setAccelerator("V").setEnabledChain(false);
        this.runToBreakMicroAction = new ToolTipAction(Lang.get("menu_runToBreakMicro", new Object[0]), ICON_STEP_FINISH){

            @Override
            public void actionPerformed(ActionEvent e) {
                new RunToBreakRunnable(Main.this.model, Main.this.statusLabel, Model::runToBreakMicro).run();
            }
        }.setToolTip(Lang.get("menu_runToBreakMicro_tt", new Object[0])).setAccelerator("B").setEnabledChain(false);
        final ToolTipAction runModelAction = this.runModelState.createToolTipAction(Lang.get("menu_run", new Object[0]), ICON_RUN).setToolTip(Lang.get("menu_run_tt", new Object[0]));
        ToolTipAction runModelMicroAction = this.runModelMicroState.createToolTipAction(Lang.get("menu_micro", new Object[0]), ICON_MICRO).setToolTip(Lang.get("menu_micro_tt", new Object[0])).setAccelerator("G");
        this.runToBreakAction = new ToolTipAction(Lang.get("menu_fast", new Object[0]), ICON_FAST){

            @Override
            public void actionPerformed(ActionEvent e) {
                new RunToBreakRunnable(Main.this.model, Main.this.statusLabel, Model::runToBreak).run();
            }
        }.setToolTip(Lang.get("menu_fast_tt", new Object[0])).setEnabledChain(false).setAccelerator("F7");
        final ToolTipAction stoppedStateAction = this.stoppedState.createToolTipAction(Lang.get("menu_element", new Object[0]), ICON_STOP).setToolTip(Lang.get("menu_element_tt", new Object[0])).setEnabledChain(false);
        this.runTests = new ToolTipAction(Lang.get("menu_runTests", new Object[0]), ICON_TEST){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.startTests();
            }
        }.setToolTip(Lang.get("menu_runTests_tt", new Object[0])).setAccelerator("F8");
        ToolTipAction runAllTests = new ToolTipAction(Lang.get("menu_runAllTests", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Main.this.filename != null) {
                    new TestAllDialog((Frame)Main.this, Main.this.filename.getParentFile(), Main.this.shapeFactory, Main.this.library).setVisible(true);
                }
            }
        }.setToolTip(Lang.get("menu_runAllTests_tt", new Object[0])).setAccelerator("F11");
        this.showMeasurementDialog = new ToolTipAction(Lang.get("menu_showDataTable", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Main.this.model != null) {
                    ModelEventType event = ModelEventType.STEP;
                    if (Main.this.stateManager.isActive(Main.this.runModelMicroState)) {
                        event = ModelEventType.MICROSTEP;
                    }
                    Main.this.showMeasurementDialog(event);
                }
            }
        }.setToolTip(Lang.get("menu_showDataTable_tt", new Object[0])).setEnabledChain(false).setAccelerator("F6");
        this.showMeasurementGraph = new ToolTipAction(Lang.get("menu_showDataGraph", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Main.this.model != null) {
                    ModelEventType event = ModelEventType.STEP;
                    if (Main.this.stateManager.isActive(Main.this.runModelMicroState)) {
                        event = ModelEventType.MICROSTEP;
                    }
                    Main.this.showMeasurementGraph(event);
                }
            }
        }.setToolTip(Lang.get("menu_showDataGraph_tt", new Object[0])).setEnabledChain(false);
        this.circuitComponent.getInputMap().put(KeyStroke.getKeyStroke(' '), KEY_START_STOP_ACTION);
        this.circuitComponent.getActionMap().put(KEY_START_STOP_ACTION, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Main.this.model == null) {
                    runModelAction.actionPerformed(actionEvent);
                } else {
                    stoppedStateAction.actionPerformed(actionEvent);
                }
            }
        });
        JMenu run = new JMenu(Lang.get("menu_sim", new Object[0]));
        menuBar.add(run);
        run.add(this.showMeasurementDialog.createJMenuItem());
        run.add(this.showMeasurementGraph.createJMenuItem());
        run.addSeparator();
        run.add(runModelAction.createJMenuItem());
        run.add(this.runToBreakAction.createJMenuItem());
        run.add(stoppedStateAction.createJMenuItem());
        run.addSeparator();
        run.add(runModelMicroAction.createJMenuItem());
        run.add(this.doMicroStep.createJMenuItem());
        run.add(this.runToBreakMicroAction.createJMenuItem());
        run.addSeparator();
        run.add(this.runTests.createJMenuItem());
        run.add(runAllTests.createJMenuItem());
        toolBar.add(this.runModelState.setIndicator(runModelAction.createJButtonNoText()));
        toolBar.add(this.runToBreakAction.createJButtonNoText());
        toolBar.add(stoppedStateAction.createJButtonNoText());
        toolBar.addSeparator();
        toolBar.add(this.runModelMicroState.setIndicator(runModelMicroAction.createJButtonNoText()));
        toolBar.add(this.doMicroStep.createJButtonNoText());
        toolBar.add(this.runToBreakMicroAction.createJButtonNoText());
        toolBar.addSeparator();
        toolBar.add(this.runTests.createJButtonNoText());
    }

    public void startTests() {
        try {
            List<Circuit.TestCase> tsl = this.circuitComponent.getCircuit().getTestCases();
            if (tsl.isEmpty()) {
                throw new TestingDataException(Lang.get("err_noTestData", new Object[0]));
            }
            for (Circuit.TestCase tc : tsl) {
                tc.getTestCaseDescription().setNewSeed();
            }
            this.windowPosManager.register("testResult", new ValueTableDialog((Window)this, Lang.get("msg_testResult", new Object[0])).addTestResult(tsl, this.circuitComponent.getCircuit(), this.library)).setVisible(true);
            this.ensureModelIsStopped();
        }
        catch (TestingDataException | RuntimeException e1) {
            this.showError(Lang.get("msg_runningTestError", new Object[0]), e1);
        }
    }

    private void createAnalyseMenu(JMenuBar menuBar) {
        JMenu analyse = new JMenu(Lang.get("menu_analyse", new Object[0]));
        menuBar.add(analyse);
        analyse.add(new ToolTipAction(Lang.get("menu_analyse", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                try (Model model = new ModelCreator(Main.this.circuitComponent.getCircuit(), new SubstituteLibrary(Main.this.library)).createModel(false);){
                    model.checkForInvalidSignals();
                    new TableDialog((Window)Main.this, new ModelAnalyser(model).analyse(), Main.this.library, Main.this.getBaseFileName()).setVisible(true);
                    Main.this.ensureModelIsStopped();
                }
                catch (AnalyseException | BacktrackException | NodeException | PinException | ElementNotFoundException | RuntimeException e1) {
                    Main.this.showError(Lang.get("msg_analyseErr", new Object[0]), e1);
                }
            }
        }.setToolTip(Lang.get("menu_analyse_tt", new Object[0])).setAccelerator("F9").createJMenuItem());
        analyse.add(new ToolTipAction(Lang.get("menu_synthesise", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                TruthTable tt = new TruthTable(3).addResult();
                new TableDialog((Window)Main.this, tt, Main.this.library, Main.this.getBaseFileName()).setVisible(true);
                Main.this.ensureModelIsStopped();
            }
        }.setToolTip(Lang.get("menu_synthesise_tt", new Object[0])).createJMenuItem());
        analyse.add(new ToolTipAction(Lang.get("menu_expression", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ExpressionDialog(Main.this, Main.this.library, Main.this.shapeFactory, Main.this.getBaseFileName()).setVisible(true);
            }
        }.setToolTip(Lang.get("menu_expression_tt", new Object[0])).createJMenuItem());
        analyse.addSeparator();
        analyse.add(new ToolTipAction(Lang.get("menu_fsm", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                String foundName = null;
                for (VisualElement ve : Main.this.circuitComponent.getCircuit().getElements()) {
                    String name;
                    if (!ve.equalsDescription(Probe.DESCRIPTION) || !(name = ve.getElementAttributes().getLabel()).endsWith(".fsm")) continue;
                    foundName = name;
                }
                new FSMFrame(Main.this, Main.this.library).setBaseFileName(Main.this.filename).setProbeLabelName(foundName).setVisible(true);
            }
        }.setToolTip(Lang.get("menu_fsm_tt", new Object[0])).createJMenuItem());
        analyse.addSeparator();
        analyse.add(new ToolTipAction(Lang.get("menu_speedTest", new Object[0])){
            private final NumberFormat format;
            {
                this.format = new DecimalFormat("0.0");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try (Model model = new ModelCreator(Main.this.circuitComponent.getCircuit(), Main.this.library).createModel(false);){
                    model.setWindowPosManager(Main.this.windowPosManager);
                    SpeedTest speedTest = new SpeedTest(model);
                    String frequency = this.format.format(speedTest.calculate() / 1000.0);
                    Main.this.circuitComponent.getCircuit().clearState();
                    SwingUtilities.invokeLater(() -> {
                        Main.this.windowPosManager.closeAll();
                        JOptionPane.showMessageDialog(Main.this, Lang.get("msg_frequency_N", frequency));
                    });
                }
                catch (Exception e1) {
                    Main.this.showError(Lang.get("msg_speedTestError", new Object[0]), e1);
                }
            }
        }.setToolTip(Lang.get("menu_speedTest_tt", new Object[0])).createJMenuItem());
        analyse.add(new ToolTipAction(Lang.get("menu_stats", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Main.this.model = new ModelCreator(Main.this.getCircuitComponent().getCircuit(), Main.this.library).createModel(false);
                    Statistics stats = new Statistics(Main.this.model);
                    new StatsDialog((Frame)Main.this, stats.getTableModel()).setVisible(true);
                }
                catch (NodeException | PinException | ElementNotFoundException e) {
                    new ErrorMessage(Lang.get("msg_couldNotCreateStats", new Object[0])).addCause(e).show(Main.this);
                }
            }
        }.setToolTip(Lang.get("menu_stats_tt", new Object[0])).createJMenuItem());
        analyse.add(new ToolTipAction(Lang.get("menu_calcMaxPathLen", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Model model = new ModelCreator(Main.this.getCircuitComponent().getCircuit(), Main.this.library).createModel(false);
                    ModelAnalyser ma = new ModelAnalyser(model);
                    int depth = ma.calcMaxPathLen();
                    JOptionPane.showMessageDialog(Main.this, Lang.get("msg_maxPathLen", depth));
                }
                catch (AnalyseException | BacktrackException | NodeException | PinException | ElementNotFoundException e) {
                    new ErrorMessage(Lang.get("msg_couldNotCalculateMaxPathLen", new Object[0])).addCause(e).show(Main.this);
                }
            }
        }.setToolTip(Lang.get("menu_calcMaxPathLen_tt", new Object[0])).createJMenuItem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void orderMeasurements() {
        try (Model m = new ModelCreator(this.circuitComponent.getCircuit(), this.library).createModel(false);){
            this.ensureModelIsStopped();
            ArrayList<String> names = new ArrayList<String>();
            for (Signal s : m.getSignals()) {
                names.add(s.getName());
            }
            new OrderMerger(this.circuitComponent.getCircuit().getMeasurementOrdering()).order(names);
            ElementOrderer.ListOrder o = new ElementOrderer.ListOrder(names);
            if (new ElementOrderer((Window)this, Lang.get("menu_orderMeasurements", new Object[0]), o).addOkButton().showDialog()) {
                this.circuitComponent.modify(new ModifyMeasurementOrdering(names));
            }
        }
        catch (NodeException | PinException | ElementNotFoundException | RuntimeException e) {
            this.showError(Lang.get("msg_errorCreatingModel", new Object[0]), e);
        }
    }

    private void setupStates() {
        this.stoppedState = this.stateManager.register(new State(){

            @Override
            public void enter() {
                super.enter();
                Main.this.clearModelDescription();
                Main.this.circuitComponent.setModeAndReset(false, SyncAccess.NOSYNC);
                Main.this.doMicroStep.setEnabled(false);
                Main.this.stoppedState.getAction().setEnabled(false);
                Main.this.showMeasurementDialog.setEnabled(false);
                Main.this.showMeasurementGraph.setEnabled(false);
                Main.this.runToBreakAction.setEnabled(false);
                Main.this.runToBreakMicroAction.setEnabled(false);
                Main.this.runTests.setEnabled(true);
                if (Main.this.circuitComponent.getHighLightStyle() != Style.ERROR) {
                    Main.this.circuitComponent.removeHighLighted();
                }
            }
        });
        this.runModelState = this.stateManager.register(new RunModelState());
        this.runModelMicroState = this.stateManager.register(new State(){

            @Override
            public void enter() {
                super.enter();
                Main.this.showMeasurementDialog.setEnabled(true);
                Main.this.showMeasurementGraph.setEnabled(true);
                Main.this.stoppedState.getAction().setEnabled(true);
                Main.this.runTests.setEnabled(false);
                Main.this.createAndStartModel(false, ModelEventType.MICROSTEP, null);
            }
        });
        this.stateManager.setActualState(this.stoppedState);
    }

    public boolean hasMouseFocus() {
        return Main.checkFocus(this.getContentPane());
    }

    private static boolean checkFocus(Container contentPane) {
        for (int i = 0; i < contentPane.getComponentCount(); ++i) {
            Component c = contentPane.getComponent(i);
            if (c.hasFocus()) {
                return true;
            }
            if (!(c instanceof Container) || !Main.checkFocus((Container)c)) continue;
            return true;
        }
        return false;
    }

    private void clearModelDescription() {
        if (this.model != null) {
            this.model.close();
        }
        this.modelCreator = null;
        this.model = null;
    }

    private void createAndStartModel(boolean globalRunClock, ModelEventType updateEvent, ModelModifier modelModifier) {
        try {
            ElementAttributes settings;
            AsyncSeq ai;
            this.circuitComponent.removeHighLighted();
            if (this.model != null) {
                ModelClosedObserver mco = this.model.getObserver(ModelClosedObserver.class);
                if (mco != null) {
                    mco.setClosedByRestart(true);
                }
                this.model.close();
                this.circuitComponent.getCircuit().clearState();
                this.model = null;
            }
            long time = System.currentTimeMillis();
            this.modelCreator = new ModelCreator(this.circuitComponent.getCircuit(), this.library);
            this.model = this.modelCreator.createModel(true);
            this.model.setRecoverFromOscillation(this.circuitComponent.getCircuit().getAttributes().get(Keys.RECOVER_FROM_OSCILLATION));
            time = System.currentTimeMillis() - time;
            LOGGER.debug("model creation: " + time + " ms, " + this.model.getNodes().size() + " nodes");
            this.model.setWindowPosManager(this.windowPosManager);
            this.statusLabel.setText(Lang.get("msg_N_nodes", this.model.size()));
            int maxFrequency = 0;
            this.realTimeClockRunning = false;
            if (globalRunClock) {
                int threadRunnerCount = 0;
                for (Clock c : this.model.getClocks()) {
                    int frequency = c.getFrequency();
                    if (frequency > 0) {
                        RealTimeClock realTimeClock = new RealTimeClock(this.model, c, this.timerExecutor, this);
                        if (realTimeClock.isThreadRunner()) {
                            ++threadRunnerCount;
                        }
                        this.realTimeClockRunning = true;
                    }
                    if (frequency <= maxFrequency) continue;
                    maxFrequency = frequency;
                }
                if (threadRunnerCount > 1) {
                    throw new RuntimeException(Lang.get("err_moreThanOneFastClock", new Object[0]));
                }
            }
            if (!this.realTimeClockRunning && updateEvent == ModelEventType.MICROSTEP && (ai = this.model.getAsyncInfos()) != null) {
                if (ai.getFrequency() > 0) {
                    if (!this.model.getClocks().isEmpty()) {
                        throw new RuntimeException(Lang.get("err_clocksNotAllowedInAsyncMode", new Object[0]));
                    }
                    this.model.addObserver(new AsyncSequentialClock(this.model, ai, this.timerExecutor));
                    this.realTimeClockRunning = true;
                }
                this.model.setAsyncMode();
            }
            this.circuitComponent.setModeAndReset(true, this.model.createSync(updateEvent == ModelEventType.MICROSTEP));
            if (this.circuitComponent.getCircuit().getAttributes().get(Keys.IS_GENERIC).booleanValue()) {
                this.circuitComponent.setCopy(this.modelCreator.getCircuit());
            }
            CircuitModifierPostClosed cmpc = new CircuitModifierPostClosed(modification -> SwingUtilities.invokeLater(() -> this.circuitComponent.modify(modification)));
            this.modelCreator.connectToGui(cmpc);
            this.model.addObserver(cmpc);
            this.handleKeyboardComponents();
            this.doMicroStep.setEnabled(false);
            if (!this.realTimeClockRunning && this.model.isRunToBreakAllowed()) {
                if (updateEvent == ModelEventType.MICROSTEP) {
                    this.runToBreakMicroAction.setEnabled(true);
                } else {
                    this.runToBreakAction.setEnabled(true);
                }
            }
            if ((settings = this.circuitComponent.getCircuit().getAttributes()).get(Keys.SHOW_DATA_TABLE).booleanValue() || this.windowPosManager.isVisible("probe")) {
                this.showMeasurementDialog(updateEvent);
            }
            if (settings.get(Keys.SHOW_DATA_GRAPH).booleanValue() || this.windowPosManager.isVisible("dataSet")) {
                this.showMeasurementGraph(updateEvent);
            }
            if (settings.get(Keys.SHOW_DATA_GRAPH_MICRO).booleanValue()) {
                this.showMeasurementGraph(ModelEventType.MICROSTEP);
            }
            if (modelModifier != null) {
                modelModifier.preInit(this.model);
            } else if (settings.get(Keys.PRELOAD_PROGRAM).booleanValue()) {
                File romHex = new FileLocator(settings.get(Keys.PROGRAM_TO_PRELOAD)).setupWithMain(this).locate();
                new ProgramMemoryLoader(romHex, settings.get(Keys.BIG_ENDIAN_SETTING)).preInit(this.model);
            }
            if (updateEvent == ModelEventType.MICROSTEP) {
                this.checkMicroStepActions(this.model);
                this.model.addObserver(new UpdateViewMicroStep(this.model, this.modelCreator));
            } else if (updateEvent == ModelEventType.STEP) {
                if (maxFrequency <= 50) {
                    this.model.addObserver(new UpdateViewAtEvent());
                } else {
                    this.model.addObserver(new UpdateViewPeriodic());
                }
            }
            this.model.addObserver(new ModelClosedObserver());
            this.model.init();
        }
        catch (NodeException | PinException | ElementNotFoundException | RuntimeException e) {
            if (this.model != null) {
                this.model.close();
            }
            this.showError(Lang.get("msg_errorCreatingModel", new Object[0]), e);
        }
    }

    private void checkMicroStepActions(Model model) {
        boolean needsUpdate = model.needsUpdate();
        this.doMicroStep.setEnabled(needsUpdate);
        if (!model.isRunToBreakAllowed()) {
            this.runToBreakMicroAction.setEnabled(needsUpdate);
        }
    }

    private void handleKeyboardComponents() {
        for (Keyboard k : this.model.findNode(Keyboard.class)) {
            this.windowPosManager.register("keyboard_" + k.getLabel(), new KeyboardDialog((Frame)this, k, this.model));
        }
    }

    private void showMeasurementGraph(ModelEventType updateEvent) {
        Circuit circuit = this.circuitComponent.getCircuit();
        List<String> ordering = circuit.getMeasurementOrdering();
        int sampleSize = circuit.getAttributes().get(Keys.SETTINGS_MAX_STEP_COUNT);
        this.windowPosManager.register("dataSet", GraphDialog.createLiveDialog(this, this.model, updateEvent == ModelEventType.MICROSTEP, ordering, sampleSize)).setVisible(true);
    }

    private void showMeasurementDialog(ModelEventType updateEvent) {
        List<String> ordering = this.circuitComponent.getCircuit().getMeasurementOrdering();
        this.windowPosManager.register("probe", new ProbeDialog((Frame)this, this.model, updateEvent, ordering)).setVisible(true);
    }

    public Model getModel() {
        return this.model;
    }

    private void showError(String message, Exception cause) {
        if (cause instanceof NodeException) {
            NodeException e = (NodeException)cause;
            this.circuitComponent.addHighLightedWires(e.getValues());
            this.circuitComponent.addHighLighted(e.getVisualElement());
            if (this.modelCreator != null) {
                this.modelCreator.addNodeElementsTo(e.getNodes(), this.circuitComponent.getHighLighted());
            }
        } else if (cause instanceof PinException) {
            PinException e = (PinException)cause;
            this.circuitComponent.addHighLighted(e.getVisualElement());
            if (e.getNet() != null) {
                this.circuitComponent.addHighLighted(e.getNet().getWires());
            }
        } else if (cause instanceof BurnException) {
            BurnException e = (BurnException)cause;
            this.circuitComponent.addHighLightedWires(e.getValues());
        }
        this.circuitComponent.setHighLightStyle(Style.ERROR);
        this.circuitComponent.graphicHasChanged();
        new ErrorMessage(message).addCause(cause).show(this);
        this.ensureModelIsStopped();
    }

    public void ensureModelIsStopped() {
        if (!this.stoppedState.isActive()) {
            this.stoppedState.enter();
        }
    }

    private static JFileChooser getJFileChooser(File filename) {
        File folder = null;
        if (filename != null) {
            folder = filename.getParentFile();
        }
        MyFileChooser fileChooser = new MyFileChooser(folder);
        fileChooser.setFileFilter(new FileNameExtensionFilter("Circuit", "dig"));
        return fileChooser;
    }

    @Override
    public boolean isStateChanged() {
        return this.circuitComponent.isModified();
    }

    @Override
    public void saveChanges() {
        this.save.actionPerformed(null);
    }

    @Override
    public void open(File file, boolean newWindow) {
        if (newWindow) {
            new MainBuilder().setParent(this).setFileToOpen(file).build().setVisible(true);
        } else if (ClosingWindowListener.checkForSave(this, this)) {
            this.loadFile(file, true, true);
        }
    }

    private void loadFile(File filename, boolean setLibraryRoot, boolean toPref) {
        LOGGER.debug("loadFile: " + filename);
        try {
            if (setLibraryRoot) {
                LOGGER.debug("set library root: " + filename);
                this.library.setRootFilePath(filename.getParentFile());
                if (this.library.getWarningMessage() != null) {
                    SwingUtilities.invokeLater(new ErrorMessage(this.library.getWarningMessage().toString()).setComponent(this));
                }
            }
            Circuit circuit = Circuit.loadCircuit(filename, this.shapeFactory);
            this.circuitComponent.setCircuit(circuit);
            this.setFilename(filename, toPref);
            this.ensureModelIsStopped();
            this.windowPosManager.closeAll();
            this.statusLabel.setText(" ");
        }
        catch (Exception e) {
            this.circuitComponent.setCircuit(new Circuit());
            this.setFilename(null, false);
            new ErrorMessage(Lang.get("msg_errorReadingFile", new Object[0])).addCause(e).show(this);
        }
    }

    private void saveFile(File filename, boolean toPrefs) {
        try {
            this.circuitComponent.save(filename);
            this.ensureModelIsStopped();
            this.setFilename(filename, toPrefs);
            this.library.invalidateElement(filename);
            if (this.library.getRootFilePath() == null) {
                this.library.setRootFilePath(filename.getParentFile());
                if (this.library.getWarningMessage() != null) {
                    SwingUtilities.invokeLater(new ErrorMessage(this.library.getWarningMessage().toString()).setComponent(this));
                }
            }
        }
        catch (IOException e) {
            new ErrorMessage(Lang.get("msg_errorWritingFile", new Object[0])).addCause(e).show(this);
        }
    }

    private void setFilename(File filename, boolean toPrefs) {
        this.modifiedPrefixVisible = this.circuitComponent.isModified();
        if (this.save != null) {
            this.save.setEnabled(this.modifiedPrefixVisible);
        }
        String prefix = "";
        if (this.modifiedPrefixVisible) {
            prefix = "*";
        }
        this.filename = filename;
        if (filename != null) {
            this.baseFilename = filename;
            if (toPrefs) {
                this.fileHistory.add(filename);
            }
            this.setTitle(prefix + filename + " - " + Lang.get("digital", new Object[0]));
        } else {
            this.setTitle(prefix + Lang.get("digital", new Object[0]));
        }
    }

    public void startSimulation(AdvanceSimulator advanceSimulator) {
        SwingUtilities.invokeLater(() -> {
            this.runModelState.enter(false, null);
            SwingUtilities.invokeLater(() -> {
                if (this.model != null && this.model.isRunning()) {
                    try {
                        advanceSimulator.advance(this.model);
                        this.circuitComponent.graphicHasChanged();
                    }
                    catch (Exception e) {
                        this.showError(Lang.get("msg_errorSettingModelToTestCase", new Object[0]), e);
                    }
                }
            });
        });
    }

    @Override
    public void hasChanged() {
        this.ensureModelIsStopped();
        if (this.modifiedPrefixVisible != this.circuitComponent.isModified()) {
            this.setFilename(this.filename, false);
        }
    }

    public WindowPosManager getWindowPosManager() {
        return this.windowPosManager;
    }

    @Override
    public void setStatus(String message) {
        SwingUtilities.invokeLater(() -> this.statusLabel.setText(message));
    }

    @Override
    public void start(File romHex, boolean bigEndian) {
        SwingUtilities.invokeLater(() -> {
            ProgramMemoryLoader modelModifier = null;
            if (romHex != null) {
                modelModifier = new ProgramMemoryLoader(romHex, bigEndian);
            }
            this.runModelState.enter(true, modelModifier);
            this.circuitComponent.graphicHasChanged();
        });
    }

    @Override
    public void debug(File romHex, boolean bigEndian) {
        SwingUtilities.invokeLater(() -> {
            this.runModelState.enter(false, new ProgramMemoryLoader(romHex, bigEndian));
            this.circuitComponent.graphicHasChanged();
            if (this.model != null) {
                this.showMeasurementDialog(ModelEventType.STEP);
            }
        });
    }

    @Override
    public String doSingleStep() throws RemoteException {
        if (this.model != null && !this.realTimeClockRunning) {
            try {
                AddressPicker addressPicker = new AddressPicker();
                SwingUtilities.invokeAndWait(() -> {
                    ArrayList<Clock> cl = this.model.getClocks();
                    if (cl.size() == 1) {
                        ObservableValue clkVal = cl.get(0).getClockOutput();
                        this.model.modify(() -> clkVal.setBool(!clkVal.getBool()));
                        if (this.model != null) {
                            if (clkVal.getBool() && this.model.isRunning()) {
                                this.model.modify(() -> clkVal.setBool(!clkVal.getBool()));
                            }
                            addressPicker.getProgramROMAddress(this.model);
                        }
                    }
                });
                return addressPicker.getAddressString();
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RemoteException("error performing a single step " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public String doClock() throws RemoteException {
        if (this.model != null && !this.realTimeClockRunning) {
            try {
                AddressPicker addressPicker = new AddressPicker();
                SwingUtilities.invokeAndWait(() -> {
                    ArrayList<Clock> cl = this.model.getClocks();
                    if (cl.size() == 1) {
                        ObservableValue clkVal = cl.get(0).getClockOutput();
                        this.model.modify(() -> clkVal.setBool(!clkVal.getBool()));
                    }
                });
                return addressPicker.getAddressString();
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RemoteException("error performing a clock change " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public String runToBreak() throws RemoteException {
        AddressPicker addressPicker = new AddressPicker();
        if (this.model != null && this.model.isRunToBreakAllowed() && !this.realTimeClockRunning) {
            WaitForBreak waitForBreak = new WaitForBreak();
            SwingUtilities.invokeLater(() -> {
                this.model.addObserver(waitForBreak);
                new RunToBreakRunnable(this.model, this.statusLabel, Model::runToBreak).run();
            });
            waitForBreak.waitForBreak();
            SwingUtilities.invokeLater(() -> this.model.removeObserver(waitForBreak));
            addressPicker.getProgramROMAddress(this.model);
        }
        return addressPicker.getAddressString();
    }

    @Override
    public void stop() {
        SwingUtilities.invokeLater(this::ensureModelIsStopped);
    }

    @Override
    public String measure() throws RemoteException {
        if (this.model == null) {
            throw new RemoteException("no model available");
        }
        StringBuilder sb = new StringBuilder("{");
        this.model.read(() -> {
            boolean first = true;
            for (Signal s : this.model.getSignals()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append('\"').append(s.getName()).append("\":").append(s.getValue().getValue());
            }
        });
        sb.append("}");
        return sb.toString();
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new DigitalUncaughtExceptionHandler());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(InfoDialog.getInstance().getRevision());
        }
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        URL.setURLStreamHandlerFactory(ElementHelpDialog.createURLStreamHandlerFactory());
        if (Screen.isMac()) {
            Main.setMacCopyPasteTo(UIManager.get("TextField.focusInputMap"));
            Main.setMacCopyPasteTo(UIManager.get("TextArea.focusInputMap"));
        }
        File file = null;
        for (String s : args) {
            File f;
            if (s.equals("experimental")) {
                experimental = true;
                continue;
            }
            if (s.trim().length() <= 0 || !(f = new File(s)).exists()) continue;
            file = f.getAbsoluteFile();
        }
        if (file != null && file.getName().endsWith(".fsm")) {
            FSMFrame.openFile(file);
        } else if (file != null && file.getName().endsWith(".tru")) {
            TableDialog.openFile(file);
        } else {
            MainBuilder builder = new MainBuilder().setMainFrame();
            if (file != null) {
                builder.setFileToOpen(file);
            }
            SwingUtilities.invokeLater(() -> {
                boolean tutorial;
                boolean bl = tutorial = builder.fileToOpen == null && Settings.getInstance().getAttributes().get(Keys.SETTINGS_SHOW_TUTORIAL) != false;
                if (tutorial) {
                    LOGGER.debug("set empty circuit to start tutorial");
                    builder.setCircuit(new Circuit());
                }
                Main main = builder.build();
                if (Settings.getInstance().get(Keys.SETTINGS_OPEN_REMOTE_PORT).booleanValue()) {
                    int port = Settings.getInstance().get(Keys.SETTINGS_REMOTE_PORT);
                    LOGGER.info("open remote port " + port);
                    try {
                        new RemoteSever(new DigitalHandler(main)).start(port);
                    }
                    catch (IOException e) {
                        SwingUtilities.invokeLater(() -> main.statusLabel.setText(Lang.get("err_portIsInUse", new Object[0])));
                    }
                }
                main.setVisible(true);
                if (tutorial) {
                    LOGGER.debug("open tutorial dialog");
                    new InitialTutorial(main).setVisible(true);
                }
                CheckForNewRelease.showReleaseDialog(main);
            });
        }
    }

    private static void setMacCopyPasteTo(Object obj) {
        if (obj instanceof InputMap) {
            InputMap im = (InputMap)obj;
            im.put(KeyStroke.getKeyStroke(67, 256), "copy-to-clipboard");
            im.put(KeyStroke.getKeyStroke(86, 256), "paste-from-clipboard");
            im.put(KeyStroke.getKeyStroke(88, 256), "cut-to-clipboard");
        }
    }

    static {
        MESSAGE = Lang.get("message", new Object[0]);
        ICON_RUN = IconCreator.create("media-playback-start.png");
        ICON_MICRO = IconCreator.create("media-playback-start-2.png");
        ICON_TEST = IconCreator.create("media-playback-start-T.png");
        ICON_STEP = IconCreator.create("media-seek-forward.png");
        ICON_STEP_FINISH = IconCreator.create("media-seek-forward-f.png");
        ICON_STOP = IconCreator.create("media-playback-stop.png");
        ICON_NEW = IconCreator.create("document-new.png");
        ICON_NEW_SUB = IconCreator.create("document-new-sub.png");
        ICON_OPEN = IconCreator.create("document-open.png");
        ICON_OPEN_WIN = IconCreator.create("document-open-new.png");
        ICON_SAVE = IconCreator.create("document-save.png");
        ICON_SAVE_AS = IconCreator.create("document-save-as.png");
        ICON_FAST = IconCreator.create("media-skip-forward.png");
        ICON_EXPAND = IconCreator.create("View-zoom-fit.png");
        ICON_ZOOM_IN = IconCreator.create("View-zoom-in.png");
        ICON_ZOOM_OUT = IconCreator.create("View-zoom-out.png");
        ICON_HELP = IconCreator.create("help.png");
    }

    private static interface RunModel {
        public Model.BreakInfo runModel(Model var1, int var2);
    }

    private static final class RunToBreakRunnable
    implements Runnable {
        private static final int DEFAULT_TARGET_TIME_MS = 100;
        private final RunModel runModel;
        private final int targetTimeMs;
        private final Model model;
        private final JLabel statusLabel;
        private int steps;

        private RunToBreakRunnable(Model model, JLabel statusLabel, RunModel runModel) {
            this(model, statusLabel, runModel, 100);
        }

        private RunToBreakRunnable(Model model, JLabel statusLabel, RunModel runModel, int targetTimeMs) {
            this.model = model;
            this.statusLabel = statusLabel;
            this.runModel = runModel;
            this.targetTimeMs = targetTimeMs;
            this.steps = 10000;
        }

        @Override
        public void run() {
            if (this.model.isRunning()) {
                long time = System.currentTimeMillis();
                Model.BreakInfo info = this.runModel.runModel(this.model, this.steps);
                time = System.currentTimeMillis() - time;
                if (info != null) {
                    if (info.isTimeout() && this.model.isRunning()) {
                        if (time > 0L) {
                            int newSteps = (int)((long)(this.steps * this.targetTimeMs) / time);
                            this.steps = (this.steps + newSteps) / 2;
                        }
                        SwingUtilities.invokeLater(this);
                    } else {
                        this.statusLabel.setText(Lang.get("stat_clocks", info.getSteps(), info.getLabel()));
                    }
                }
            }
        }
    }

    public static interface AdvanceSimulator {
        public void advance(Model var1) throws Exception;
    }

    private class ModelKeyListener
    extends KeyAdapter {
        private ModelKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.checkKey(keyEvent.getKeyCode(), true);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.checkKey(keyEvent.getKeyCode(), false);
        }

        private void checkKey(int keyCode, boolean pressed) {
            Button b;
            if (Main.this.model != null && keyCode != 0 && (b = Main.this.model.getButtonToMap(keyCode)) != null) {
                Main.this.model.modify(() -> b.setPressed(pressed));
            }
        }
    }

    public static class MainBuilder {
        private File fileToOpen;
        private Window parent;
        private ElementLibrary library;
        private Circuit circuit;
        private boolean allowAllFileActions = true;
        private File baseFileName;
        private boolean keepPrefMainFile;
        private boolean mainFrame = false;
        private boolean presentationMode;

        public MainBuilder setFileToOpen(File fileToOpen) {
            this.fileToOpen = fileToOpen;
            this.baseFileName = fileToOpen;
            return this;
        }

        public MainBuilder setBaseFileName(File baseFileName) {
            this.baseFileName = baseFileName;
            return this;
        }

        public MainBuilder setParent(Window parent) {
            this.parent = parent;
            return this;
        }

        public MainBuilder setPresentationMode(boolean presentationMode) {
            this.presentationMode = presentationMode;
            return this;
        }

        public MainBuilder setLibrary(ElementLibrary library) {
            this.library = library;
            return this;
        }

        public MainBuilder setCircuit(Circuit circuit) {
            this.circuit = circuit;
            return this;
        }

        public MainBuilder denyMostFileActions() {
            this.allowAllFileActions = false;
            return this;
        }

        public MainBuilder keepPrefMainFile() {
            this.keepPrefMainFile = true;
            return this;
        }

        public Main build() {
            return new Main(this);
        }

        public void openLater() {
            SwingUtilities.invokeLater(() -> this.build().setVisible(true));
        }

        private MainBuilder setMainFrame() {
            this.mainFrame = true;
            return this;
        }
    }

    private static final class WaitForBreak
    implements ModelStateObserverTyped {
        private boolean wasBreak = false;

        private WaitForBreak() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(ModelEvent event) {
            if (event.getType() == ModelEventType.BREAK || event.getType() == ModelEventType.CLOSED) {
                WaitForBreak waitForBreak = this;
                synchronized (waitForBreak) {
                    this.wasBreak = true;
                    this.notify();
                }
            }
        }

        @Override
        public ModelEventType[] getEvents() {
            return new ModelEventType[]{ModelEventType.BREAK, ModelEventType.CLOSED};
        }

        private synchronized void waitForBreak() {
            try {
                while (!this.wasBreak) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static class AddressPicker {
        private long address;

        private AddressPicker() {
        }

        private void getProgramROMAddress(Model model) {
            List<Node> programCounters = model.findNode(n -> n instanceof ProgramCounter && ((ProgramCounter)((Object)n)).isProgramCounter());
            this.address = programCounters.size() == 1 ? ((ProgramCounter)((Object)programCounters.get(0))).getProgramCounter() : -1L;
        }

        String getAddressString() {
            if (this.address < 0L) {
                return null;
            }
            return Long.toHexString(this.address);
        }
    }

    private class CreateTestCaseAction
    extends ToolTipAction {
        CreateTestCaseAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BehavioralFixtureCreator bfc = new BehavioralFixtureCreator(Main.this, Main.this.shapeFactory);
            Main.this.windowPosManager.closeAll();
            Main.this.runModelState.enter(false, bfc);
            Main.this.circuitComponent.graphicHasChanged();
        }
    }

    private class ExportGifAction
    extends ToolTipAction {
        private final String name;

        ExportGifAction(String name) {
            super(name);
            this.name = name;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ElementAttributes settings;
            File exportDir;
            MyFileChooser fc = new MyFileChooser();
            if (Main.this.filename != null) {
                fc.setSelectedFile(SaveAsHelper.checkSuffix(Main.this.filename, "gif"));
            }
            if ((exportDir = (settings = Settings.getInstance().getAttributes()).getFile("exportDirectory")) != null) {
                fc.setCurrentDirectory(exportDir);
            }
            fc.addChoosableFileFilter(new FileNameExtensionFilter(this.name, "gif"));
            new SaveAsHelper(Main.this, fc, "gif").checkOverwrite(file -> {
                settings.setFile("exportDirectory", file.getParentFile());
                GifExporter gifExporter = new GifExporter(Main.this, Main.this.circuitComponent.getCircuit(), 500, file);
                Main.this.windowPosManager.closeAll();
                Main.this.runModelState.enter(false, gifExporter);
                Main.this.circuitComponent.graphicHasChanged();
            });
        }
    }

    private class ExportAction
    extends ToolTipAction {
        private final String name;
        private final String suffix;
        private final ExportFactory exportFactory;

        ExportAction(String name, String suffix, ExportFactory exportFactory) {
            super(name);
            this.name = name;
            this.suffix = suffix;
            this.exportFactory = exportFactory;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ElementAttributes settings;
            File exportDir;
            MyFileChooser fc = new MyFileChooser();
            if (Main.this.filename != null) {
                fc.setSelectedFile(SaveAsHelper.checkSuffix(Main.this.filename, this.suffix));
            }
            if ((exportDir = (settings = Settings.getInstance().getAttributes()).getFile("exportDirectory")) != null) {
                fc.setCurrentDirectory(exportDir);
            }
            fc.addChoosableFileFilter(new FileNameExtensionFilter(this.name, this.suffix));
            new SaveAsHelper(Main.this, fc, this.suffix).checkOverwrite(file -> {
                settings.setFile("exportDirectory", file.getParentFile());
                new Export(Main.this.circuitComponent.getCircuitOrShallowCopy(), this.exportFactory, Main.this.circuitComponent.getPresentationMode()).export(file);
            });
        }
    }

    private final class UpdateViewMicroStep
    implements ModelStateObserverTyped {
        private final Model model;
        private final ModelCreator modelCreator;

        private UpdateViewMicroStep(Model model, ModelCreator modelCreator) {
            this.model = model;
            this.modelCreator = modelCreator;
        }

        @Override
        public void handleEvent(ModelEvent event) {
            switch (event.getType()) {
                case CHECKBURN: 
                case BREAK: 
                case MICROSTEP: {
                    if (!Main.this.realTimeClockRunning) {
                        Main.this.circuitComponent.removeHighLighted();
                        this.modelCreator.addNodeElementsTo(this.model.nodesToUpdate(), Main.this.circuitComponent.getHighLighted());
                    }
                    Main.this.circuitComponent.graphicHasChanged();
                    if (Main.this.realTimeClockRunning) break;
                    Main.this.checkMicroStepActions(this.model);
                }
            }
        }

        @Override
        public ModelEventType[] getEvents() {
            return new ModelEventType[]{ModelEventType.CHECKBURN, ModelEventType.MICROSTEP, ModelEventType.BREAK};
        }
    }

    private final class UpdateViewPeriodic
    implements ModelStateObserverTyped {
        private final Timer timer = new Timer(100, actionEvent -> Main.this.circuitComponent.graphicHasChanged());

        private UpdateViewPeriodic() {
        }

        @Override
        public void handleEvent(ModelEvent event) {
            switch (event.getType()) {
                case STARTED: {
                    this.timer.start();
                    break;
                }
                case CLOSED: 
                case BREAK: {
                    this.timer.stop();
                    SwingUtilities.invokeLater(Main.this.circuitComponent::graphicHasChanged);
                }
            }
        }

        @Override
        public ModelEventType[] getEvents() {
            return new ModelEventType[]{ModelEventType.CLOSED, ModelEventType.BREAK};
        }
    }

    private class UpdateViewAtEvent
    implements ModelStateObserverTyped {
        private boolean stepUpdateEnabled = true;

        UpdateViewAtEvent() {
        }

        @Override
        public void handleEvent(ModelEvent event) {
            switch (event.getType()) {
                case RUN_TO_BREAK: {
                    this.stepUpdateEnabled = false;
                    break;
                }
                case CHECKBURN: 
                case BREAK: {
                    this.stepUpdateEnabled = true;
                }
                case STEP: {
                    if (!this.stepUpdateEnabled) break;
                    Main.this.circuitComponent.graphicHasChanged();
                    break;
                }
                case RUN_TO_BREAK_TIMEOUT: {
                    Main.this.circuitComponent.graphicHasChanged();
                }
            }
        }

        @Override
        public ModelEventType[] getEvents() {
            return new ModelEventType[]{ModelEventType.CHECKBURN, ModelEventType.STEP, ModelEventType.BREAK};
        }
    }

    private class ModelClosedObserver
    implements ModelStateObserverTyped {
        private boolean closedByRestart = false;
        private boolean errorDialogIsOpened = true;

        private ModelClosedObserver() {
        }

        @Override
        public void handleEvent(ModelEvent event) {
            switch (event.getType()) {
                case ERROR_OCCURRED: {
                    SwingUtilities.invokeLater(() -> Main.this.showError(Lang.get("msg_errorCalculatingStep", new Object[0]), event.getCause()));
                    this.errorDialogIsOpened = true;
                    break;
                }
                case CLOSED: {
                    if (this.errorDialogIsOpened || this.closedByRestart) break;
                    SwingUtilities.invokeLater(Main.this::ensureModelIsStopped);
                }
            }
        }

        @Override
        public ModelEventType[] getEvents() {
            return new ModelEventType[]{ModelEventType.CLOSED, ModelEventType.ERROR_OCCURRED};
        }

        public void setClosedByRestart(boolean closedByRestart) {
            this.closedByRestart = closedByRestart;
        }
    }

    private class RunModelState
    extends State {
        private RunModelState() {
        }

        @Override
        public void enter() {
            this.enter(true, null);
        }

        void enter(boolean runRealTime, ModelModifier modelModifier) {
            super.enter();
            Main.this.stoppedState.getAction().setEnabled(true);
            Main.this.showMeasurementDialog.setEnabled(true);
            Main.this.showMeasurementGraph.setEnabled(true);
            Main.this.runTests.setEnabled(false);
            Main.this.createAndStartModel(runRealTime, ModelEventType.STEP, modelModifier);
        }
    }
}

