/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui;

import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.library.LibraryNode;
import de.neemann.digital.draw.shapes.MissingShape;
import de.neemann.digital.draw.shapes.ShapeFactory;
import de.neemann.digital.gui.InsertHistory;
import de.neemann.digital.gui.components.CircuitComponent;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.ErrorMessage;
import de.neemann.gui.ToolTipAction;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public final class InsertAction
extends ToolTipAction {
    private final InsertHistory insertHistory;
    private final CircuitComponent circuitComponent;
    private final ShapeFactory shapeFactory;
    private LibraryNode node;

    public InsertAction(LibraryNode node, InsertHistory insertHistory, CircuitComponent circuitComponent, ShapeFactory shapeFactory) {
        super(node.getTranslatedName(), node.getIconOrNull(shapeFactory));
        this.shapeFactory = shapeFactory;
        this.node = node;
        this.insertHistory = insertHistory;
        this.circuitComponent = circuitComponent;
        this.setEnabled(node.isUnique());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.node.isUnique()) {
            VisualElement visualElement = this.node.setWideShapeFlagTo(new VisualElement(this.node.getName()).setPos(new Vector(10, 10)).setShapeFactory(this.shapeFactory));
            if (this.getIcon() == null) {
                try {
                    this.node.getDescription();
                    this.setIcon(this.node.getIcon(this.shapeFactory));
                }
                catch (IOException ex) {
                    SwingUtilities.invokeLater(new ErrorMessage(Lang.get("msg_errorImportingModel_N0", this.node.getName())).addCause(ex));
                }
            }
            if (visualElement.getShape() instanceof MissingShape) {
                return;
            }
            this.circuitComponent.setPartToInsert(visualElement);
            this.insertHistory.add(this);
        }
    }

    public boolean isCustom() {
        return this.node.isCustom();
    }

    public String getName() {
        return this.node.getName();
    }

    public void update(LibraryNode node) {
        this.node = node;
        try {
            Icon icon = node.getIcon(this.shapeFactory);
            this.setIcon(icon);
        }
        catch (IOException ex) {
            SwingUtilities.invokeLater(new ErrorMessage(Lang.get("msg_errorImportingModel_N0", node.getName())).addCause(ex));
        }
    }

    public LibraryNode getNode() {
        return this.node;
    }

    @Override
    public JMenuItem createJMenuItem() {
        JMenuItem i = new JMenuItem(this.node.getTranslatedName(), this.getIcon()){

            @Override
            public String getToolTipText() {
                return InsertAction.this.node.getToolTipText();
            }
        };
        i.addActionListener(this);
        i.setEnabled(this.node.isUnique());
        ToolTipManager.sharedInstance().registerComponent(i);
        return i;
    }
}

