/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui;

import de.neemann.gui.ToolTipAction;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JMenu;

public final class FileHistory {
    private static boolean isGuiTest = false;
    private static final String FILE_NUM = "fileNum";
    private static final String FILE_NAME = "name";
    private static final int MAX_SIZE = 15;
    private final ArrayList<File> files;
    private final OpenInterface opener;
    private final Preferences prefs;
    private JMenu menu;
    private JMenu menuNewWindow;

    public static void setGuiTest() {
        isGuiTest = true;
    }

    public FileHistory(OpenInterface opener) {
        this(opener, Preferences.userRoot().node("dig").node("hist"));
    }

    public FileHistory(OpenInterface opener, Preferences prefs) {
        this.opener = opener;
        this.prefs = prefs;
        int n = prefs.getInt(FILE_NUM, 0);
        this.files = new ArrayList();
        for (int i = 0; i < n; ++i) {
            File file;
            String pathname = prefs.get(FILE_NAME + i, null);
            if (pathname == null || pathname.length() <= 0 || !(file = new File(pathname)).exists()) continue;
            this.files.add(file);
        }
        if (n != this.files.size()) {
            this.saveEntries();
        }
    }

    private void saveEntries() {
        if (!isGuiTest) {
            this.prefs.putInt(FILE_NUM, this.files.size());
            for (int i = 0; i < this.files.size(); ++i) {
                this.prefs.put(FILE_NAME + i, this.files.get(i).getPath());
            }
        }
    }

    public void add(File file) {
        int i = this.files.indexOf(file);
        if (i != 0) {
            if (i > 0) {
                this.files.remove(i);
            }
            this.files.add(0, file);
            while (this.files.size() > 15) {
                this.files.remove(this.files.size() - 1);
            }
            this.saveEntries();
            this.updateMenu();
        }
    }

    public File getMostRecent() {
        if (this.files.isEmpty()) {
            return null;
        }
        return this.files.get(0);
    }

    public Iterable<File> getFiles() {
        return this.files;
    }

    private void updateMenu() {
        if (this.menu != null) {
            this.menu.removeAll();
            if (this.menuNewWindow != null) {
                this.menuNewWindow.removeAll();
            }
            for (File f : this.files) {
                this.menu.add(new FileOpenEntry(f, this.opener, false).createJMenuItem());
                if (this.menuNewWindow == null) continue;
                this.menuNewWindow.add(new FileOpenEntry(f, this.opener, true).createJMenuItem());
            }
        }
    }

    public void setMenu(JMenu menu, JMenu menuNewWindow) {
        this.menu = menu;
        this.menuNewWindow = menuNewWindow;
        this.updateMenu();
    }

    public static interface OpenInterface {
        public void open(File var1, boolean var2);
    }

    private static class FileOpenEntry
    extends ToolTipAction {
        private final File file;
        private final OpenInterface opener;
        private boolean newWindow;

        FileOpenEntry(File file, OpenInterface opener, boolean newWindow) {
            super(file.getName());
            this.file = file;
            this.opener = opener;
            this.newWindow = newWindow;
            this.setToolTip(file.getPath());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.opener.open(this.file, this.newWindow);
        }
    }
}

