/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui;

import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.ErrorMessage;
import de.neemann.gui.ToolTipAction;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.swing.JMenu;

public class DocumentationLocator {
    private final File folder;

    public DocumentationLocator() {
        File folder = null;
        try {
            String path = ElementLibrary.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath().replace('\\', '/');
            if (path.endsWith("/target/classes/")) {
                folder = new File(path.substring(0, path.length() - 9) + "/docu");
            } else if (path.endsWith("Digital.jar")) {
                folder = new File(path.substring(0, path.length() - 12) + "/docu");
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.folder = folder != null && folder.exists() ? folder : null;
    }

    public void addMenuTo(JMenu help) {
        File[] files;
        if (this.folder != null && (files = this.folder.listFiles((file, name) -> name.endsWith(".pdf"))) != null && files.length > 0) {
            String language = "_" + Lang.currentLanguage().getName() + ".pdf";
            File found = null;
            for (File f : files) {
                if (!f.getName().endsWith(language)) continue;
                found = f;
            }
            if (found == null) {
                JMenu docu = new JMenu(Lang.get("menu_pdfDocumentation", new Object[0]));
                help.add(docu);
                for (File f : files) {
                    docu.add(new OpenPDFAction(f).createJMenuItem());
                }
            } else {
                help.add(new OpenPDFAction(found, Lang.get("menu_pdfDocumentation", new Object[0])));
            }
        }
    }

    private static final class OpenPDFAction
    extends ToolTipAction {
        private final File f;

        private OpenPDFAction(File f) {
            this(f, Lang.get("menu_openPdfDocumentation", f.getName()));
        }

        private OpenPDFAction(File f, String name) {
            super(name);
            this.f = f;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Desktop desktop;
                Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                if (desktop == null || !desktop.isSupported(Desktop.Action.OPEN)) {
                    throw new IOException("could not open pdf document");
                }
                desktop.open(this.f);
            }
            catch (IOException e) {
                new ErrorMessage(Lang.get("msg_errorOpeningDocumentation", new Object[0])).addCause(e).show();
            }
        }
    }
}

