/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.fsm.gui;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.draw.graphics.ColorKey;
import de.neemann.digital.draw.graphics.ColorScheme;
import de.neemann.digital.draw.graphics.GraphicMinMax;
import de.neemann.digital.draw.graphics.GraphicSwing;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.graphics.VectorFloat;
import de.neemann.digital.fsm.FSM;
import de.neemann.digital.fsm.MouseMovable;
import de.neemann.digital.fsm.State;
import de.neemann.digital.fsm.Transition;
import de.neemann.digital.gui.components.AttributeDialog;
import de.neemann.digital.gui.components.CircuitComponent;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.Mouse;
import de.neemann.gui.ToolTipAction;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class FSMComponent
extends JComponent {
    private static final Key<Integer> KEY_NUMBER = new Key.KeyInteger("stateNum", 0);
    private static final Key<Boolean> KEY_INITIAL = new Key<Boolean>("isInitialState", false);
    private static final Key<Boolean> KEY_DEFAULT_DC = new Key<Boolean>("defaultsDC", false);
    private static final Key<String> KEY_VALUES = new Key<String>("stateValues", "");
    private static final Key<String> KEY_CONDITION = new Key<String>("transCond", "");
    private static final Key<Integer> KEY_RADIUS = new Key.KeyInteger("transRad", 70).setComboBoxValues(50, 70, 90);
    private static final String DEL_ACTION = "myDelAction";
    private static final int MIN_NEW_TRANS_DIST = 10;
    private final Mouse mouse = Mouse.getMouse();
    private boolean isManualScale;
    private AffineTransform transform = new AffineTransform();
    private MouseMovable elementMoved;
    private FSM fsm;
    private Vector lastMousePos;
    private State newTransitionFromState;
    private Vector newTransitionStartPos;
    private String lastCondition = "";
    private static final Key<?>[] STATE_EDIT_KEYS = new Key[]{Keys.LABEL, KEY_NUMBER, KEY_INITIAL, KEY_VALUES, KEY_RADIUS, KEY_DEFAULT_DC};

    FSMComponent() {
        this.addMouseWheelListener(e -> {
            Vector pos = this.getPosVector(e);
            double f = Math.pow(0.9, e.getWheelRotation());
            this.transform.translate(pos.x, pos.y);
            this.transform.scale(f, f);
            this.transform.translate(-pos.x, -pos.y);
            this.isManualScale = true;
            this.repaint();
        });
        MouseAdapter mouseListener = new MouseAdapter(){
            private boolean screenDrag;
            private Vector delta;
            private Vector pos;

            @Override
            public void mousePressed(MouseEvent e) {
                this.pos = new Vector(e.getX(), e.getY());
                Vector posVector = FSMComponent.this.getPosVector(e);
                this.screenDrag = false;
                if (FSMComponent.this.mouse.isPrimaryClick(e)) {
                    FSMComponent.this.elementMoved = FSMComponent.this.fsm.getMovable(posVector);
                    if (FSMComponent.this.elementMoved != null) {
                        this.delta = posVector.sub(FSMComponent.this.elementMoved.getPos());
                    }
                } else if (FSMComponent.this.mouse.isSecondaryClick(e)) {
                    MouseMovable st = FSMComponent.this.fsm.getMovable(posVector);
                    if (st instanceof State) {
                        FSMComponent.this.newTransitionStartPos = posVector;
                        FSMComponent.this.newTransitionFromState = (State)st;
                        FSMComponent.this.repaint();
                    }
                    this.screenDrag = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (FSMComponent.this.elementMoved != null) {
                    FSMComponent.this.elementMoved.setPos(FSMComponent.this.getPosVector(mouseEvent).sub(this.delta).toFloat());
                    FSMComponent.this.repaint();
                }
                FSMComponent.this.elementMoved = null;
                if (FSMComponent.this.newTransitionFromState != null) {
                    MouseMovable target;
                    Vector posVector = FSMComponent.this.getPosVector(mouseEvent);
                    if (FSMComponent.this.newTransitionStartPos.sub(posVector).len() > 10.0f && (target = FSMComponent.this.fsm.getMovable(posVector)) instanceof State) {
                        FSMComponent.this.fsm.add(new Transition(FSMComponent.this.newTransitionFromState, (State)target, FSMComponent.this.lastCondition));
                    }
                    FSMComponent.this.newTransitionFromState = null;
                    FSMComponent.this.repaint();
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Vector posVector = FSMComponent.this.getPosVector(mouseEvent);
                MouseMovable elementClicked = FSMComponent.this.fsm.getMovable(posVector);
                if (FSMComponent.this.mouse.isSecondaryClick(mouseEvent)) {
                    if (elementClicked == null) {
                        FSMComponent.this.createNewState(posVector, new Point(mouseEvent.getX(), mouseEvent.getY()));
                    } else if (elementClicked instanceof State) {
                        FSMComponent.this.editState((State)elementClicked, new Point(mouseEvent.getX(), mouseEvent.getY()));
                    } else if (elementClicked instanceof Transition) {
                        FSMComponent.this.editTransition((Transition)elementClicked, new Point(mouseEvent.getX(), mouseEvent.getY()));
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                FSMComponent.this.lastMousePos = FSMComponent.this.getPosVector(mouseEvent);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                FSMComponent.this.lastMousePos = FSMComponent.this.getPosVector(e);
                if (FSMComponent.this.elementMoved == null && FSMComponent.this.newTransitionFromState == null && this.screenDrag) {
                    Vector newPos = new Vector(e.getX(), e.getY());
                    Vector delta = newPos.sub(this.pos);
                    double s = FSMComponent.this.transform.getScaleX();
                    FSMComponent.this.transform.translate((double)delta.x / s, (double)delta.y / s);
                    this.pos = newPos;
                    FSMComponent.this.isManualScale = true;
                    FSMComponent.this.repaint();
                }
                if (FSMComponent.this.elementMoved != null) {
                    FSMComponent.this.elementMoved.setPosDragging(FSMComponent.this.getPosVector(e).sub(this.delta).toFloat());
                    FSMComponent.this.repaint();
                }
                if (FSMComponent.this.newTransitionFromState != null) {
                    FSMComponent.this.repaint();
                }
            }
        };
        this.addMouseMotionListener(mouseListener);
        this.addMouseListener(mouseListener);
        ToolTipAction deleteAction = new ToolTipAction(Lang.get("menu_delete", new Object[0]), CircuitComponent.ICON_DELETE){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MouseMovable element = FSMComponent.this.fsm.getMovable(FSMComponent.this.lastMousePos);
                if (element instanceof State) {
                    FSMComponent.this.fsm.remove((State)element);
                    FSMComponent.this.repaint();
                } else if (element instanceof Transition) {
                    FSMComponent.this.fsm.remove((Transition)element);
                    FSMComponent.this.repaint();
                }
            }
        }.setToolTip(Lang.get("menu_delete_tt", new Object[0]));
        this.getInputMap(2).put(KeyStroke.getKeyStroke(127, 0), DEL_ACTION);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(8, 0), DEL_ACTION);
        this.getActionMap().put(DEL_ACTION, deleteAction);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (!FSMComponent.this.isManualScale) {
                    FSMComponent.this.fitFSM();
                }
            }
        });
        this.setFocusable(true);
        this.setPreferredSize(new Dimension(600, 600));
    }

    private void createNewState(Vector posVector, Point point) {
        ElementAttributes attr = new ElementAttributes();
        attr.set(KEY_NUMBER, this.fsm.getStates().size());
        SwingUtilities.convertPointToScreen(point, this);
        AttributeDialog ad = new AttributeDialog(SwingUtilities.getWindowAncestor(this), point, attr, STATE_EDIT_KEYS).setDialogTitle(Lang.get("msg_fsmNewState", new Object[0]));
        ElementAttributes newAttr = ad.showDialog();
        if (newAttr == null && ad.isOkPressed()) {
            newAttr = attr;
        }
        if (newAttr != null) {
            this.fsm.add(((State)new State(newAttr.get(Keys.LABEL)).setNumber(newAttr.get(KEY_NUMBER)).setValues(newAttr.get(KEY_VALUES))).setPosition(posVector.toFloat()).toRaster());
            this.repaint();
        }
    }

    private void editState(State state, Point point) {
        ElementAttributes attr = new ElementAttributes().set(KEY_NUMBER, state.getNumber()).set(KEY_INITIAL, state.isInitial()).set(KEY_DEFAULT_DC, state.isDefaultDC()).set(KEY_VALUES, state.getValues()).set(KEY_RADIUS, state.getVisualRadius()).set(Keys.LABEL, state.getName());
        SwingUtilities.convertPointToScreen(point, this);
        ElementAttributes newAttr = new AttributeDialog(SwingUtilities.getWindowAncestor(this), point, attr, STATE_EDIT_KEYS).setDialogTitle(Lang.get("msg_fsmState", new Object[0])).showDialog();
        if (newAttr != null) {
            state.setNumber(newAttr.get(KEY_NUMBER));
            state.setInitial(newAttr.get(KEY_INITIAL));
            state.setDefaultDC(newAttr.get(KEY_DEFAULT_DC));
            state.setValues(newAttr.get(KEY_VALUES));
            state.setRadius(newAttr.get(KEY_RADIUS));
            state.setName(newAttr.get(Keys.LABEL));
            this.repaint();
        }
    }

    private void editTransition(Transition transition, Point point) {
        ElementAttributes attr = new ElementAttributes().set(KEY_CONDITION, transition.getCondition()).set(KEY_VALUES, transition.getValues());
        SwingUtilities.convertPointToScreen(point, this);
        ElementAttributes newAttr = new AttributeDialog(SwingUtilities.getWindowAncestor(this), point, attr, KEY_CONDITION, KEY_VALUES).setDialogTitle(Lang.get("msg_fsmTransition", new Object[0])).showDialog();
        if (newAttr != null) {
            this.lastCondition = newAttr.get(KEY_CONDITION);
            transition.setCondition(this.lastCondition);
            transition.setValues(newAttr.get(KEY_VALUES));
            this.repaint();
        }
    }

    private Vector getPosVector(MouseEvent e) {
        return this.getPosVector(e.getX(), e.getY());
    }

    private Vector getPosVector(int x, int y) {
        try {
            Point2D.Double p = new Point2D.Double();
            this.transform.inverseTransform(new Point(x, y), p);
            return new Vector((int)Math.round(p.getX()), (int)Math.round(p.getY()));
        }
        catch (NoninvertibleTransformException e1) {
            throw new RuntimeException(e1);
        }
    }

    void fitFSM() {
        if (this.fsm != null) {
            GraphicMinMax gr = new GraphicMinMax();
            this.fsm.drawTo(gr);
            AffineTransform newTrans = new AffineTransform();
            if (gr.getMin() != null && this.getWidth() != 0 && this.getHeight() != 0) {
                Vector delta = gr.getMax().sub(gr.getMin());
                double sx = (double)this.getWidth() / (double)(delta.x + Style.NORMAL.getThickness() * 2);
                double sy = (double)this.getHeight() / (double)(delta.y + Style.NORMAL.getThickness() * 2);
                double s = Math.min(sx, sy);
                newTrans.setToScale(s, s);
                Vector center = gr.getMin().add(gr.getMax()).div(2);
                newTrans.translate(-center.x, -center.y);
                Vector dif = new Vector(this.getWidth(), this.getHeight()).div(2);
                newTrans.translate((double)dif.x / s, (double)dif.y / s);
                this.isManualScale = false;
            } else {
                this.isManualScale = true;
            }
            if (!newTrans.equals(this.transform)) {
                this.transform = newTrans;
                this.repaint();
            }
        }
    }

    void scaleCircuit(double f) {
        Vector dif = this.getPosVector(this.getWidth() / 2, this.getHeight() / 2);
        this.transform.translate(dif.x, dif.y);
        this.transform.scale(f, f);
        this.transform.translate(-dif.x, -dif.y);
        this.isManualScale = true;
        this.repaint();
    }

    MouseMovable getElementMoved() {
        return this.elementMoved;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(ColorScheme.getSelected().getColor(ColorKey.BACKGROUND));
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D gr2 = (Graphics2D)graphics;
        gr2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gr2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        gr2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        gr2.transform(this.transform);
        GraphicSwing gr = new GraphicSwing(gr2, 1);
        this.fsm.drawTo(gr);
        if (this.newTransitionFromState != null) {
            Vector dif = this.lastMousePos.sub(this.newTransitionStartPos);
            int max = Math.max(Math.abs(dif.x), Math.abs(dif.y));
            if (max > 10) {
                VectorFloat d = this.lastMousePos.sub(this.newTransitionFromState.getPos()).norm().mul(16.0f);
                VectorFloat a = d.getOrthogonal().norm().mul(8.0f);
                gr.drawPolygon(new Polygon(false).add(this.lastMousePos.sub(d).add(a)).add(this.lastMousePos).add(this.lastMousePos.sub(d).sub(a)), Style.SHAPE_PIN);
                gr.drawLine(this.newTransitionFromState.getPos(), this.lastMousePos.sub(d.mul(0.2f)), Style.SHAPE_PIN);
            }
        }
    }

    public void setFSM(FSM fsm) {
        this.fsm = fsm;
        this.fitFSM();
        this.repaint();
    }
}

