/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.fsm;

public class WaitGroup {
    private final Runnable finish;
    private int counter;

    public WaitGroup() {
        this(null);
    }

    public WaitGroup(Runnable finish) {
        this.finish = finish;
    }

    synchronized void add() {
        ++this.counter;
    }

    public synchronized void add(int n) {
        this.counter += n;
    }

    public synchronized void done() {
        --this.counter;
        this.notify();
        if (this.counter < 0) {
            throw new RuntimeException("illegal waitgroup state");
        }
        if (this.counter == 0 && this.finish != null) {
            this.finish.run();
        }
    }

    public synchronized void waitFor() throws InterruptedException {
        while (this.counter > 0) {
            this.wait();
        }
    }
}

