/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.fsm;

import de.neemann.digital.analyse.ModelAnalyserInfo;
import de.neemann.digital.fsm.FiniteStateMachineException;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class ValueParser {
    private final String values;
    private TreeMap<String, Integer> valueMap;
    private ModelAnalyserInfo modelAnalyzerInfo;

    public ValueParser(String values) {
        this.values = values;
        this.valueMap = new TreeMap();
    }

    public ValueParser setModelAnalyzerInfo(ModelAnalyserInfo modelAnalyzerInfo) {
        this.modelAnalyzerInfo = modelAnalyzerInfo;
        return this;
    }

    public TreeMap<String, Integer> parse() throws FiniteStateMachineException {
        if (this.values != null) {
            StringTokenizer st = new StringTokenizer(this.values, ";,");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                int p = tok.indexOf(61);
                if (p < 0) {
                    throw new FiniteStateMachineException(Lang.get("err_fsmInvalidOutputAssignment_N", this.values));
                }
                String key = tok.substring(0, p).trim();
                String valStr = tok.substring(p + 1).trim().toLowerCase();
                int len = valStr.length();
                if (len == 1) {
                    this.setVarByChar(key, valStr.charAt(0));
                    continue;
                }
                ArrayList<String> names = new ArrayList<String>();
                for (int i = 0; i < len; ++i) {
                    String name = key + i;
                    names.add(name);
                    this.setVarByChar(name, valStr.charAt(len - i - 1));
                }
                if (this.modelAnalyzerInfo == null) continue;
                this.modelAnalyzerInfo.addOutputBus(key, names);
            }
        }
        return this.valueMap;
    }

    private void setVarByChar(String key, char valStr) throws FiniteStateMachineException {
        switch (valStr) {
            case '0': {
                this.valueMap.put(key, 0);
                break;
            }
            case '1': {
                this.valueMap.put(key, 1);
                break;
            }
            case 'x': {
                this.valueMap.put(key, 2);
                break;
            }
            default: {
                throw new FiniteStateMachineException(Lang.get("err_fsmInvalidOutputAssignment_N", Character.valueOf(valStr)));
            }
        }
    }
}

