/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.fsm;

import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.graphics.VectorFloat;
import de.neemann.digital.draw.graphics.VectorInterface;
import de.neemann.digital.fsm.MouseMovable;
import de.neemann.digital.fsm.Movable;
import de.neemann.digital.fsm.Transition;
import java.util.List;

public class State
extends Movable<State> {
    static final int DEFAULT_RAD = 70;
    private static final int INIT_RAD = 10;
    private static final int RASTER = 60;
    private static final float REACH = 2000.0f;
    private int number = -1;
    private String name;
    private int radius;
    private boolean isInitial;
    private int initialAngle = 12;
    private boolean defaultDC;

    public State(String name) {
        this.name = name;
        this.radius = 70;
    }

    State(State other) {
        this.name = other.name;
        this.radius = other.radius;
        this.number = other.number;
        this.isInitial = other.isInitial;
        this.initialAngle = other.initialAngle;
        this.defaultDC = other.defaultDC;
        this.setValues(other.getValues());
        this.setPos(other.getPos());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!this.name.equals(name)) {
            this.name = name;
            this.wasModified(Movable.Property.NAME);
        }
    }

    public State setPosition(VectorFloat position) {
        this.setPos(position);
        return this;
    }

    void calcExpansionForce(List<State> states) {
        this.resetForce();
        for (State s : states) {
            if (s == this) continue;
            this.addRepulsive(s.getPos(), 2000.0f);
        }
    }

    public void drawTo(Graphic gr) {
        VectorInterface pos;
        Style style = Style.NORMAL;
        if (this.getFsm() != null && this.getFsm().getActiveState() == this) {
            style = Style.HIGHLIGHT;
        }
        Vector rad = new Vector(this.radius, this.radius);
        gr.drawCircle(this.getPos().sub(rad), this.getPos().add(rad), style);
        if (this.isInitial) {
            Vector initRad = new Vector(10, 10);
            pos = this.getInitialMarkerPos();
            gr.drawCircle(pos.sub(initRad), pos.add(initRad), Style.FILLED);
            VectorFloat delta = this.getPos().sub(pos).norm();
            VectorInterface a0 = pos.add(delta.mul(10 + Style.FILLED.getThickness()));
            VectorFloat a1 = this.getPos().sub(delta.mul(this.radius + Style.FILLED.getThickness()));
            Transition.drawArrow(gr, a0, null, null, a1, Style.SHAPE_PIN);
        }
        Vector delta = new Vector(0, Style.NORMAL.getFontSize());
        pos = this.getPos().add(delta.mul(-1));
        String text = Integer.toString(this.number);
        if (this.defaultDC) {
            text = text + " DC";
        }
        gr.drawText(pos, text, Orientation.CENTERCENTER, Style.NORMAL);
        pos = ((VectorFloat)pos).add(delta);
        gr.drawText(pos, this.name, Orientation.CENTERCENTER, Style.NORMAL);
        if (this.getValues() != null && this.getValues().length() > 0) {
            pos = ((VectorFloat)pos).add(delta);
            gr.drawText(pos, this.getValues(), Orientation.CENTERCENTER, Style.INOUT);
        }
    }

    VectorInterface getInitialMarkerPos() {
        int r = this.radius + 60;
        double angle = 0.19634954084936207 * (double)this.initialAngle;
        return this.getPos().add(new VectorFloat((float)(Math.cos(angle) * (double)r), -((float)(Math.sin(angle) * (double)r))));
    }

    public int getVisualRadius() {
        return this.radius;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public State setNumber(int number) {
        if (this.number != number) {
            this.number = number;
            this.wasModified(Movable.Property.NUMBER);
        }
        return this;
    }

    public int getNumber() {
        return this.number;
    }

    public boolean matches(Vector pos) {
        return pos.sub(this.getPos()).len() <= (float)this.radius;
    }

    public boolean matchesInitial(Vector pos) {
        if (!this.isInitial) {
            return false;
        }
        return pos.sub(this.getInitialMarkerPos()).len() <= 10.0f;
    }

    public String toString() {
        if (this.name != null && this.name.length() > 0) {
            return this.name + "/" + this.number;
        }
        return Integer.toString(this.number);
    }

    public State toRaster() {
        this.setPosition(new VectorFloat(Math.round(this.getPos().getXFloat() / 60.0f) * 60, Math.round(this.getPos().getYFloat() / 60.0f) * 60));
        return this;
    }

    public boolean isInitial() {
        return this.isInitial;
    }

    public void setInitial(boolean isInitial) {
        if (isInitial && this.getFsm() != null) {
            this.getFsm().clearInitial();
        }
        if (this.isInitial != isInitial) {
            this.isInitial = isInitial;
            this.wasModified(Movable.Property.INITIAL);
        }
    }

    public MouseMovable getInitialMarkerMovable() {
        return new MouseMovable(){

            @Override
            public VectorInterface getPos() {
                return State.this.getInitialMarkerPos();
            }

            @Override
            public void setPosDragging(VectorFloat pos) {
                VectorFloat delta = pos.sub(State.this.getPos());
                double angle = Math.atan2(-delta.getYFloat(), delta.getXFloat()) / Math.PI * 16.0;
                if (angle < 0.0) {
                    angle += 32.0;
                }
                int ia = (int)Math.round(angle);
                if (State.this.initialAngle != ia) {
                    State.this.initialAngle = ia;
                    State.this.wasModified(Movable.Property.INITIAL_ANGLE);
                }
            }

            @Override
            public void setPos(VectorFloat pos) {
            }
        };
    }

    public boolean isDefaultDC() {
        return this.defaultDC;
    }

    public void setDefaultDC(boolean defaultDC) {
        this.defaultDC = defaultDC;
    }
}

