/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.fsm;

import de.neemann.digital.draw.graphics.VectorFloat;
import de.neemann.digital.fsm.FSM;
import de.neemann.digital.fsm.MouseMovable;

public class Movable<A extends Movable<?>>
implements MouseMovable {
    private static final float MASS = 50.0f;
    private static final float FRICTION = 0.8f;
    private static final float MAX_FORCE = 100000.0f;
    private static final float MAX_FORCE_CHECK = (float)(100000.0 / Math.sqrt(2.0));
    private String values = "";
    private VectorFloat position;
    private transient VectorFloat speed;
    private transient VectorFloat force = new VectorFloat(0.0f, 0.0f);
    private transient FSM fsm;
    private transient Property lastPosProp;

    public Movable() {
        this.speed = new VectorFloat(0.0f, 0.0f);
        this.position = new VectorFloat(0.0f, 0.0f);
    }

    @Override
    public void setPosDragging(VectorFloat position) {
        this.setPos(position, Property.MOUSEPOS);
    }

    @Override
    public void setPos(VectorFloat position) {
        this.setPos(position, Property.POS);
    }

    private void setPos(VectorFloat position, Property prop) {
        if (!this.position.equals(position) || this.lastPosProp != prop) {
            this.position = position;
            this.lastPosProp = prop;
            this.wasModified(prop);
        }
    }

    void wasModified(Property prop) {
        if (this.fsm != null) {
            this.fsm.wasModified(this, prop);
        }
    }

    void addToForce(VectorFloat df) {
        this.force = this.force == null ? df : this.force.add(df);
    }

    void addRepulsive(VectorFloat pos, float reach) {
        VectorFloat dif = this.position.sub(pos);
        float dist = dif.len();
        if (dist == 0.0f) {
            this.addToForce(new VectorFloat((float)Math.random() - 0.5f, (float)Math.random() - 0.5f).mul(2.0f));
        } else {
            float f = reach * reach / (dist * dist) / 2.0f;
            this.addToForce(dif.norm().mul(f));
        }
    }

    public void addRepulsiveInv(VectorFloat pos, float reach) {
        VectorFloat dif = this.position.sub(pos);
        float dist = dif.len();
        if (dist == 0.0f) {
            this.addToForce(new VectorFloat((float)Math.random() - 0.5f, (float)Math.random() - 0.5f).mul(2.0f));
        } else {
            float f = reach / dist / 2.0f;
            if (f > 100.0f) {
                f = 100.0f;
            }
            this.addToForce(dif.norm().mul(f));
        }
    }

    void addAttractiveTo(VectorFloat target, float scale) {
        this.addToForce(target.sub(this.position).mul(scale));
    }

    VectorFloat getForce() {
        if (this.force == null) {
            this.resetForce();
        }
        return this.force;
    }

    void resetForce() {
        this.force = new VectorFloat(0.0f, 0.0f);
    }

    @Override
    public VectorFloat getPos() {
        return this.position;
    }

    public void move(int dt) {
        double len;
        if ((Math.abs(this.force.getXFloat()) > MAX_FORCE_CHECK || Math.abs(this.force.getYFloat()) > MAX_FORCE_CHECK) && (len = (double)this.force.len()) > 100000.0) {
            this.force = this.force.norm().mul(100000.0f);
        }
        this.speed = this.speed == null ? this.force.mul((float)dt / 50.0f) : this.speed.add(this.force.mul((float)dt / 50.0f));
        this.setPos(this.position.add(this.speed.mul((float)dt / 1000.0f)));
        this.speed = this.speed.mul(0.8f);
    }

    void setFSM(FSM fsm) {
        this.fsm = fsm;
    }

    FSM getFsm() {
        return this.fsm;
    }

    public A setValues(String values) {
        if (!this.values.equals(values)) {
            this.values = values;
            this.wasModified(Property.VALUES);
        }
        return (A)this;
    }

    public String getValues() {
        return this.values;
    }

    static enum Property {
        POS,
        REMOVED,
        CONDITION,
        NAME,
        NUMBER,
        MOUSEPOS,
        VALUES,
        INITIAL,
        ADDED,
        INITIAL_ANGLE;

    }
}

