/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes.ieee;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.ieee.IEEEGenericShape;

public class IEEEXOrShape
extends IEEEGenericShape {
    private static final Polygon POLYGON = IEEEXOrShape.createPoly();
    private static final Polygon POLYGON2 = IEEEXOrShape.createPoly2();
    private static final Polygon POLYGON_WIDE = IEEEXOrShape.createPolyWide();
    private final boolean center;

    private static Polygon createPoly() {
        return new Polygon(true).add(11, 50).add(new Vector(20, 40), new Vector(20, 0), new Vector(11, -10)).add(new Vector(20, -10), new Vector(40, 0), new Vector(60, 20)).add(new Vector(40, 40), new Vector(20, 50), new Vector(11, 50));
    }

    private static Polygon createPolyWide() {
        return new Polygon(true).add(30, 50).add(10, 50).add(new Vector(20, 34), new Vector(20, 6), new Vector(10, -10)).add(30, -10).add(new Vector(50, -10), new Vector(70, 0), new Vector(80, 20)).add(new Vector(70, 40), new Vector(50, 50), new Vector(30, 50));
    }

    private static Polygon createPoly2() {
        return new Polygon(false).add(0, 50).add(new Vector(10, 40), new Vector(10, 0), new Vector(0, -10));
    }

    public IEEEXOrShape(PinDescriptions inputs, PinDescriptions outputs, boolean invert, ElementAttributes attr) {
        super(inputs, outputs, invert, attr);
        this.center = (inputs.size() & 1) != 0;
    }

    @Override
    protected void drawIEEE(Graphic graphic) {
        graphic.drawLine(new Vector(0, 0), new Vector(14, 0), Style.WIRE);
        graphic.drawLine(new Vector(0, 40), new Vector(14, 40), Style.WIRE);
        if (this.center) {
            graphic.drawLine(new Vector(0, 20), new Vector(17, 20), Style.WIRE);
        }
        if (this.isWideShape()) {
            graphic.drawPolygon(POLYGON_WIDE, Style.NORMAL);
        } else {
            graphic.drawPolygon(POLYGON, Style.NORMAL);
        }
        graphic.drawPolygon(POLYGON2, Style.NORMAL);
    }
}

