/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes.ieee;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.GraphicTransform;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.TransformTranslate;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.model.InverterConfig;
import de.neemann.digital.draw.shapes.GenericShape;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;

public abstract class IEEEGenericShape
implements Shape {
    private final PinDescriptions inputs;
    private final PinDescriptions outputs;
    private final boolean invert;
    private final InverterConfig inverterConfig;
    private final boolean wideShape;
    private Pins pins;

    public IEEEGenericShape(PinDescriptions inputs, PinDescriptions outputs, boolean invert, ElementAttributes attr) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.invert = invert;
        this.wideShape = attr.get(Keys.WIDE_SHAPE);
        this.inverterConfig = attr.get(Keys.INVERTER_CONFIG);
    }

    @Override
    public Pins getPins() {
        if (this.pins == null) {
            this.pins = GenericShape.createPins(this.inputs, this.outputs, this.invert, this.inverterConfig, this.wideShape);
        }
        return this.pins;
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        int offs = (this.inputs.size() / 2 - 1) * 20;
        this.drawIEEE(new GraphicTransform(graphic, new TransformTranslate(new Vector(0, offs))));
        if (offs > 0) {
            graphic.drawLine(new Vector(1, 0), new Vector(1, offs - 10 - 1), Style.NORMAL);
            int h = this.inputs.size() / 2 * 20 * 2;
            graphic.drawLine(new Vector(1, h), new Vector(1, h - offs + 10 + 1), Style.NORMAL);
        }
        GenericShape.drawInputInvert(graphic, this.inverterConfig, this.getPins());
        if (this.invert) {
            int o = this.inputs.size() / 2 * 20;
            int pos = 3;
            if (this.wideShape) {
                ++pos;
            }
            for (int i = 0; i < this.outputs.size(); ++i) {
                graphic.drawCircle(new Vector(20 * pos + 1, i * 20 - 10 + 1 + o), new Vector(20 * (pos + 1) - 1, i * 20 + 10 - 1 + o), Style.NORMAL);
            }
        }
    }

    protected abstract void drawIEEE(Graphic var1);

    public boolean isWideShape() {
        return this.wideShape;
    }
}

