/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes.custom.svg;

import de.neemann.digital.draw.graphics.SVGTokenizer;
import de.neemann.digital.draw.graphics.Transform;
import de.neemann.digital.draw.graphics.TransformMatrix;
import de.neemann.digital.draw.graphics.TransformTranslate;
import de.neemann.digital.draw.graphics.VectorFloat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransformParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformParser.class);
    private SVGTokenizer tok;

    TransformParser(String transform) {
        this.tok = new SVGTokenizer(transform);
    }

    public Transform parse() {
        Transform combined = Transform.IDENTITY;
        try {
            while (!this.tok.isEOF()) {
                Transform t;
                String command;
                switch (command = this.tok.readCommand()) {
                    case "translate": {
                        this.tok.expect('(');
                        float x = this.tok.readFloat();
                        float y = 0.0f;
                        if (this.tok.nextIsNumber()) {
                            y = this.tok.readFloat();
                        }
                        this.tok.expect(')');
                        t = new TransformTranslate(new VectorFloat(x, y));
                        break;
                    }
                    case "scale": {
                        float xs;
                        this.tok.expect('(');
                        float ys = xs = this.tok.readFloat();
                        if (this.tok.nextIsNumber()) {
                            ys = this.tok.readFloat();
                        }
                        this.tok.expect(')');
                        t = new TransformMatrix(xs, 0.0f, 0.0f, ys, 0.0f, 0.0f);
                        break;
                    }
                    case "matrix": {
                        this.tok.expect('(');
                        float ma = this.tok.readFloat();
                        float mb = this.tok.readFloat();
                        float mc = this.tok.readFloat();
                        float md = this.tok.readFloat();
                        float mx = this.tok.readFloat();
                        float my = this.tok.readFloat();
                        this.tok.expect(')');
                        t = new TransformMatrix(ma, mc, mb, md, mx, my);
                        break;
                    }
                    case "rotate": {
                        this.tok.expect('(');
                        float w = this.tok.readFloat();
                        if (this.tok.nextIsNumber()) {
                            t = TransformMatrix.rotate(w);
                            float xc = this.tok.readFloat();
                            float yc = this.tok.readFloat();
                            t = Transform.mul(new TransformTranslate(-xc, -yc), t);
                            t = Transform.mul(t, new TransformTranslate(xc, yc));
                        } else {
                            t = TransformMatrix.rotate(w);
                        }
                        this.tok.expect(')');
                        break;
                    }
                    default: {
                        throw new RuntimeException("unknown transform: " + command, null);
                    }
                }
                combined = Transform.mul(t, combined);
            }
        }
        catch (Exception e) {
            LOGGER.warn(this.tok + ": " + e.getMessage());
        }
        return combined;
    }
}

