/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes.custom.svg;

import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.PolygonParser;
import de.neemann.digital.draw.graphics.TransformMatrix;
import de.neemann.digital.draw.graphics.TransformTranslate;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.graphics.VectorFloat;
import de.neemann.digital.draw.graphics.VectorInterface;
import de.neemann.digital.draw.shapes.custom.CustomShapeDescription;
import de.neemann.digital.draw.shapes.custom.svg.Context;
import de.neemann.digital.draw.shapes.custom.svg.SvgException;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SvgImporter {
    private final Document svg;

    public SvgImporter(InputStream in) throws IOException {
        try {
            this.svg = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        }
        catch (Exception e) {
            throw new IOException(Lang.get("err_parsingSVG", new Object[0]), e);
        }
    }

    public SvgImporter(File svgFile) throws IOException {
        if (!svgFile.exists()) {
            throw new FileNotFoundException(svgFile.getPath());
        }
        try {
            this.svg = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(svgFile);
        }
        catch (Exception e) {
            throw new IOException(Lang.get("err_parsingSVG", new Object[0]), e);
        }
    }

    public CustomShapeDescription create() throws SvgException {
        NodeList gList = this.svg.getElementsByTagName("svg").item(0).getChildNodes();
        Context c = new Context();
        try {
            CustomShapeDescription.Builder builder = new CustomShapeDescription.Builder();
            this.create(builder, gList, c);
            CustomShapeDescription csd = builder.build();
            if (csd.getPinCount() > 0) {
                float xMin = Float.MAX_VALUE;
                float yMin = Float.MAX_VALUE;
                for (CustomShapeDescription.Pin p : csd.getPins()) {
                    if ((float)p.getPos().x < xMin) {
                        xMin = p.getPos().x;
                    }
                    if (!((float)p.getPos().y < yMin)) continue;
                    yMin = p.getPos().y;
                }
                csd.transform(new TransformTranslate(-xMin, -yMin));
            }
            return csd;
        }
        catch (RuntimeException e) {
            throw new SvgException(Lang.get("err_parsingSVG", new Object[0]), e);
        }
    }

    private void create(CustomShapeDescription.Builder csd, NodeList gList, Context c) throws SvgException {
        for (int i = 0; i < gList.getLength(); ++i) {
            Node node = gList.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (element.getNodeName().equals("style")) {
                c.addClasses(element.getTextContent());
                continue;
            }
            this.create(csd, element, c);
        }
    }

    private void create(CustomShapeDescription.Builder csd, Element element, Context parent) throws SvgException {
        Context c = new Context(parent, element);
        switch (element.getNodeName()) {
            case "a": 
            case "g": {
                this.create(csd, element.getChildNodes(), c);
                break;
            }
            case "line": {
                csd.addLine(c.v(c.getLength(element.getAttribute("x1")), c.getLength(element.getAttribute("y1"))).round(), c.v(c.getLength(element.getAttribute("x2")), c.getLength(element.getAttribute("y2"))).round(), c.getThickness(), c.getStroke());
                break;
            }
            case "rect": {
                this.drawRect(csd, element, c);
                break;
            }
            case "path": {
                try {
                    Polygon d = new PolygonParser(element.getAttribute("d")).create();
                    if (d == null) break;
                    d.setEvenOdd(c.isFillRuleEvenOdd());
                    this.drawTransformedPolygon(csd, c, d);
                    break;
                }
                catch (PolygonParser.ParserException e) {
                    throw new SvgException("invalid path", e);
                }
            }
            case "polygon": {
                try {
                    this.drawTransformedPolygon(csd, c, new PolygonParser(element.getAttribute("points")).parsePolygon());
                    break;
                }
                catch (PolygonParser.ParserException e) {
                    throw new SvgException("invalid points", e);
                }
            }
            case "polyline": {
                try {
                    this.drawTransformedPolygon(csd, c, new PolygonParser(element.getAttribute("points")).parsePolyline());
                    break;
                }
                catch (PolygonParser.ParserException e) {
                    throw new SvgException("invalid points", e);
                }
            }
            case "circle": 
            case "ellipse": {
                this.drawCircle(csd, element, c);
                break;
            }
            case "text": {
                this.drawText(csd, c, element);
            }
        }
    }

    private void drawTransformedPolygon(CustomShapeDescription.Builder csd, Context c, Polygon polygon) {
        if (polygon != null) {
            this.drawPolygon(csd, c, polygon.transform(c.getTransform()));
        }
    }

    private void drawPolygon(CustomShapeDescription.Builder csd, Context c, Polygon polygon) {
        if (c.getFilled() != null && polygon.isClosed()) {
            csd.addPolygon(polygon, c.getThickness(), c.getFilled(), true);
        }
        if (c.getStroke() != null) {
            csd.addPolygon(polygon, c.getThickness(), c.getStroke(), false);
        }
    }

    private void drawRect(CustomShapeDescription.Builder csd, Element element, Context c) {
        Polygon polygon;
        VectorFloat size = new VectorFloat(c.getLength(element.getAttribute("width")), c.getLength(element.getAttribute("height")));
        VectorFloat pos = new VectorFloat(c.getLength(element.getAttribute("x")), c.getLength(element.getAttribute("y")));
        String rxStr = element.getAttribute("rx");
        String ryStr = element.getAttribute("ry");
        VectorInterface rad = rxStr.isEmpty() && ryStr.isEmpty() ? new Vector(0, 0) : (rxStr.isEmpty() ? new VectorFloat(c.getLength(ryStr), c.getLength(ryStr)) : (ryStr.isEmpty() ? new VectorFloat(c.getLength(rxStr), c.getLength(rxStr)) : new VectorFloat(c.getLength(rxStr), c.getLength(ryStr))));
        float x = pos.getXFloat();
        float y = pos.getYFloat();
        float width = size.getXFloat();
        float height = size.getYFloat();
        if (rad.getXFloat() * rad.getYFloat() != 0.0f) {
            float rx = rad.getXFloat();
            float ry = rad.getYFloat();
            float w = size.getXFloat() - 2.0f * rx;
            float h = size.getYFloat() - 2.0f * ry;
            double f = 4.0 * (Math.sqrt(2.0) - 1.0) / 3.0;
            float cx = (float)(f * (double)rx);
            float cy = (float)(f * (double)ry);
            polygon = new Polygon(true).add(c.v(x + rx + w, y)).add(c.v(x + rx + w + cx, y), c.v(x + width, y + ry - cy), c.v(x + width, y + ry)).add(c.v(x + width, y + ry + h)).add(c.v(x + width, y + ry + h + cy), c.v(x + rx + w + cx, y + height), c.v(x + rx + w, y + height)).add(c.v(x + rx, y + height)).add(c.v(x + rx - cx, y + height), c.v(x, y + ry + h + cy), c.v(x, y + ry + h)).add(c.v(x, y + ry)).add(c.v(x, y + ry - cy), c.v(x + rx - cx, y), c.v(x + rx, y));
        } else {
            polygon = new Polygon(true).add(c.v(x, y)).add(c.v(x + width, y)).add(c.v(x + width, y + height)).add(c.v(x, y + height));
        }
        this.drawPolygon(csd, c, polygon);
    }

    private void drawCircle(CustomShapeDescription.Builder csd, Element element, Context c) {
        if (element.hasAttribute("id")) {
            VectorInterface pos = c.v(c.getLength(element.getAttribute("cx")), c.getLength(element.getAttribute("cy")));
            String id = element.getAttribute("id");
            if (id.startsWith("pin:")) {
                csd.addPin(id.substring(4).trim(), this.toGrid(pos), false);
                return;
            }
            if (id.startsWith("pin+:")) {
                csd.addPin(id.substring(5).trim(), this.toGrid(pos), true);
                return;
            }
        }
        VectorFloat r = null;
        if (element.hasAttribute("r")) {
            String rad = element.getAttribute("r");
            r = new VectorFloat(c.getLength(rad), c.getLength(rad));
        }
        if (element.hasAttribute("rx")) {
            r = new VectorFloat(c.getLength(element.getAttribute("rx")), c.getLength(element.getAttribute("ry")));
        }
        if (r != null) {
            VectorFloat pos = new VectorFloat(c.getLength(element.getAttribute("cx")), c.getLength(element.getAttribute("cy")));
            float rx = r.getXFloat();
            float ry = r.getYFloat();
            TransformMatrix matrix = c.getTransform().getMatrix();
            if (matrix.noRotation() || rx == ry && matrix.isUniform()) {
                rx = matrix.transformDirection(new VectorFloat(rx, 0.0f)).len();
                ry = matrix.transformDirection(new VectorFloat(0.0f, ry)).len();
                VectorInterface center = pos.transform(c.getTransform());
                VectorFloat rad = new VectorFloat(rx, ry);
                Vector p1 = center.sub(rad).round();
                Vector p2 = center.add(rad).round();
                if (c.getStroke() != null) {
                    csd.addCircle(p1, p2, c.getThickness(), c.getStroke(), false);
                }
                if (c.getFilled() != null) {
                    csd.addCircle(p1, p2, c.getThickness(), c.getFilled(), true);
                }
            } else {
                double f = 4.0 * (Math.sqrt(2.0) - 1.0) / 3.0;
                float cx = (float)(f * (double)rx);
                float cy = (float)(f * (double)ry);
                float x = pos.getXFloat();
                float y = pos.getYFloat();
                Polygon poly = new Polygon(true).add(c.v(x - rx, y)).add(c.v(x - rx, y + cy), c.v(x - cx, y + ry), c.v(x, y + ry)).add(c.v(x + cx, y + ry), c.v(x + rx, y + cy), c.v(x + rx, y)).add(c.v(x + rx, y - cy), c.v(x + cx, y - ry), c.v(x, y - ry)).add(c.v(x - cx, y - ry), c.v(x - rx, y - cy), c.v(x - rx, y));
                this.drawPolygon(csd, c, poly);
            }
        }
    }

    private Vector toGrid(VectorInterface pos) {
        return new Vector(Math.round(pos.getXFloat() / 20.0f) * 20, Math.round(pos.getYFloat() / 20.0f) * 20);
    }

    private void drawText(CustomShapeDescription.Builder csd, Context c, Element element) throws SvgException {
        VectorFloat p = new VectorFloat(c.getLength(element.getAttribute("x")), c.getLength(element.getAttribute("y")));
        VectorInterface pos0 = p.transform(c.getTransform());
        VectorInterface pos1 = p.add(new VectorFloat(1.0f, 0.0f)).transform(c.getTransform());
        if (element.getAttribute("id").equals("label")) {
            csd.setLabel(pos0.round(), pos1.round(), c.getTextOrientation(), Math.round(c.getFontSize()), c.getFilled());
        } else {
            this.drawTextElement(csd, c, element, pos0, pos1);
        }
    }

    private void drawTextElement(CustomShapeDescription.Builder csd, Context c, Element element, VectorInterface pos0, VectorInterface pos1) throws SvgException {
        NodeList nodes = element.getElementsByTagName("*");
        if (nodes.getLength() == 0) {
            String text = element.getTextContent();
            csd.addText(pos0.round(), pos1.round(), text, c.getTextOrientation(), Math.round(c.getFontSize()), c.getFilled());
        } else {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                if (!(n instanceof Element)) continue;
                Element el = (Element)n;
                this.drawTextElement(csd, new Context(c, el), el, pos0, pos1);
            }
        }
    }
}

