/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes.custom.svg;

import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.SVGTokenizer;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Transform;
import de.neemann.digital.draw.graphics.VectorFloat;
import de.neemann.digital.draw.graphics.VectorInterface;
import de.neemann.digital.draw.shapes.custom.svg.SvgException;
import de.neemann.digital.draw.shapes.custom.svg.TransformParser;
import java.awt.Color;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class Context {
    private static final float PIXELPERMM = 3.7795277f;
    private static final HashMap<String, AttrParser> PARSER = new HashMap();
    private final Context parent;
    private Transform tr;
    private Color fill;
    private float fillOpacity;
    private Color stroke;
    private float strokeOpacity;
    private float thickness;
    private float fontSize;
    private String textAnchor;
    private boolean fillRuleEvenOdd;
    private HashMap<String, String> classesMap;

    Context() {
        this.parent = null;
        this.tr = Transform.IDENTITY;
        this.thickness = 1.0f;
        this.stroke = Color.BLACK;
        this.fontSize = Style.NORMAL.getFontSize();
        this.fill = Color.BLACK;
        this.fillOpacity = 1.0f;
        this.strokeOpacity = 1.0f;
    }

    private Context(Context parent) {
        this.parent = parent;
        this.tr = parent.tr;
        this.fill = parent.fill;
        this.fillOpacity = parent.fillOpacity;
        this.stroke = parent.stroke;
        this.strokeOpacity = parent.strokeOpacity;
        this.thickness = parent.thickness;
        this.fontSize = parent.fontSize;
        this.textAnchor = parent.textAnchor;
        this.fillRuleEvenOdd = parent.fillRuleEvenOdd;
    }

    Context(Context parent, Element element) throws SvgException {
        this(parent);
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node item = attributes.item(i);
            AttrParser p = PARSER.get(item.getNodeName());
            if (p == null) continue;
            p.parse(this, item.getNodeValue().trim());
        }
    }

    static Context readStyle(Context context, String style) throws SvgException {
        String command;
        SVGTokenizer t = new SVGTokenizer(style);
        while ((command = t.readTo(':')).length() != 0) {
            String value = t.readTo(';');
            AttrParser p = PARSER.get(command);
            if (p == null) continue;
            p.parse(context, value);
        }
        return context;
    }

    Transform getTransform() {
        return this.tr;
    }

    public Color getStroke() {
        return Context.createColor(this.stroke, this.strokeOpacity);
    }

    public Color getFilled() {
        return Context.createColor(this.fill, this.fillOpacity);
    }

    private static Color createColor(Color color, float opacity) {
        if (color == null) {
            return null;
        }
        if (opacity == 1.0f) {
            return color;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0f * opacity));
    }

    public int getThickness() {
        return (int)this.thickness;
    }

    boolean isFillRuleEvenOdd() {
        return this.fillRuleEvenOdd;
    }

    Orientation getTextOrientation() {
        if (this.textAnchor == null) {
            return Orientation.LEFTBOTTOM;
        }
        switch (this.textAnchor) {
            case "end": {
                return Orientation.RIGHTBOTTOM;
            }
            case "middle": {
                return Orientation.CENTERBOTTOM;
            }
        }
        return Orientation.LEFTBOTTOM;
    }

    public VectorInterface tr(VectorInterface vector) {
        return vector.transform(this.tr);
    }

    public VectorInterface v(float x, float y) {
        return new VectorFloat(x, y).transform(this.tr);
    }

    public float getFontSize() {
        return this.fontSize;
    }

    void addClasses(String classes) {
        SVGTokenizer t = new SVGTokenizer(classes);
        try {
            while (t.nextIsChar('.')) {
                String key = t.readTo('{');
                String val = t.readTo('}');
                if (this.classesMap == null) {
                    this.classesMap = new HashMap();
                }
                this.classesMap.put(key, val);
            }
        }
        catch (SVGTokenizer.TokenizerException tokenizerException) {
            // empty catch block
        }
    }

    String getCssClass(String key) {
        String v = null;
        if (this.classesMap != null) {
            v = this.classesMap.get(key);
        }
        if (v == null && this.parent != null) {
            return this.parent.getCssClass(key);
        }
        return v;
    }

    public float getLength(String value) {
        return Context.getLengthFromString(this, value, 1.0f, 0.0f);
    }

    private static void evalClass(Context c, String value) throws SvgException {
        StringTokenizer st = new StringTokenizer(value, ", ");
        while (st.hasMoreTokens()) {
            String cl = st.nextToken();
            String style = c.getCssClass(cl);
            if (style == null) continue;
            Context.readStyle(c, style);
        }
    }

    private static Color getColorFromString(String v) {
        try {
            String command;
            SVGTokenizer t = new SVGTokenizer(v);
            if (t.nextIsChar('#')) {
                String c = t.remaining();
                if (c.length() == 3) {
                    return new Color(Context.sRGB(c.charAt(0)), Context.sRGB(c.charAt(1)), Context.sRGB(c.charAt(2)));
                }
                return Color.decode(v);
            }
            switch (command = t.readCommand()) {
                case "none": {
                    return null;
                }
                case "rgb": {
                    t.expect('(');
                    Color col = new Color(Context.rgb(t), Context.rgb(t), Context.rgb(t));
                    t.expect(')');
                    return col;
                }
            }
            return (Color)Color.class.getField(command.toLowerCase()).get(null);
        }
        catch (Exception e) {
            return Color.BLACK;
        }
    }

    private static int rgb(SVGTokenizer t) throws SVGTokenizer.TokenizerException {
        float v = t.readFloat();
        if (t.nextIsChar('%')) {
            return (int)(v * 2.55f);
        }
        return (int)v;
    }

    private static int sRGB(char c) {
        int v = Character.digit(c, 16);
        return v * 16 + v;
    }

    private static float getFloatFromString(String inp) {
        try {
            return Float.parseFloat(inp);
        }
        catch (NumberFormatException e) {
            return 1.0f;
        }
    }

    private static float getLengthFromString(Context c, String value, float percent100, float defaultValue) {
        if (value.isEmpty()) {
            return defaultValue;
        }
        SVGTokenizer t = new SVGTokenizer(value);
        try {
            float s = t.readFloat();
            if (t.isEOF()) {
                return s;
            }
            if (t.nextIsChar('%')) {
                return s * percent100 / 100.0f;
            }
            switch (t.readCommand()) {
                case "em": {
                    return s * c.getFontSize();
                }
                case "pt": {
                    return 4.0f * s / 3.0f;
                }
                case "pc": {
                    return 16.0f * s;
                }
                case "px": {
                    return s;
                }
                case "mm": {
                    return s * 3.7795277f;
                }
                case "cm": {
                    return 10.0f * s * 3.7795277f;
                }
                case "in": {
                    return 25.4f * s * 3.7795277f;
                }
            }
            return defaultValue;
        }
        catch (SVGTokenizer.TokenizerException e) {
            return defaultValue;
        }
    }

    static {
        PARSER.put("transform", (c, value) -> {
            c.tr = Transform.mul(new TransformParser(value).parse(), c.tr);
        });
        PARSER.put("fill", (c, value) -> {
            c.fill = Context.getColorFromString(value);
        });
        PARSER.put("fill-opacity", (c, value) -> {
            c.fillOpacity = Context.getFloatFromString(value);
        });
        PARSER.put("stroke", (c, value) -> {
            c.stroke = Context.getColorFromString(value);
        });
        PARSER.put("stroke-opacity", (c, value) -> {
            c.strokeOpacity = Context.getFloatFromString(value);
        });
        PARSER.put("stroke-width", (c, value) -> {
            c.thickness = Context.getLengthFromString(c, value, 1.0f, 1.0f);
        });
        PARSER.put("font-size", (c, value) -> {
            c.fontSize = Context.getLengthFromString(c, value, c.fontSize, c.getFontSize());
        });
        PARSER.put("style", Context::readStyle);
        PARSER.put("text-anchor", (c, value) -> {
            c.textAnchor = value;
        });
        PARSER.put("fill-rule", (c, value) -> {
            c.fillRuleEvenOdd = value.equalsIgnoreCase("evenodd");
        });
        PARSER.put("class", Context::evalClass);
    }

    private static interface AttrParser {
        public void parse(Context var1, String var2) throws SvgException;
    }
}

