/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.Value;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;

public class TunnelShape
implements Shape {
    private static final int HEIGHT = 8;
    private static final int WIDTH = (int)Math.round(8.0 * Math.sqrt(3.0));
    private static final Polygon POLYGON = new Polygon(true).add(0, 0).add(WIDTH, 8).add(WIDTH, -8);
    private final PinDescription input;
    private final String label;
    private ObservableValue inputValueObserver;
    private Value inputValue;

    public TunnelShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this.input = (PinDescription)inputs.get(0);
        this.label = attr.get(Keys.NETNAME);
    }

    @Override
    public Pins getPins() {
        return new Pins().add(new Pin(new Vector(0, 0), this.input));
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        this.inputValueObserver = ioState.getInput(0);
        if (this.inputValueObserver.getBits() > 1) {
            this.inputValueObserver = null;
        }
        return null;
    }

    @Override
    public void readObservableValues() {
        if (this.inputValueObserver != null) {
            this.inputValue = this.inputValueObserver.getCopy();
        }
    }

    @Override
    public void drawTo(Graphic gr, Style highLight) {
        if (this.inputValue != null) {
            gr.drawPolygon(POLYGON, Style.getWireStyle(this.inputValue));
        }
        gr.drawPolygon(POLYGON, Style.NORMAL);
        Vector pos = new Vector(WIDTH + 5, 0);
        gr.drawText(pos, this.label, Orientation.LEFTCENTER, Style.SHAPE_PIN);
    }
}

