/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.io.StepperMotorUnipolar;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.ColorKey;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.graphics.VectorFloat;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;

public class StepperMotorShape
implements Shape {
    private final PinDescriptions inputs;
    private final PinDescriptions outputs;
    private final String label;
    private StepperMotorUnipolar motor;
    private int pos;
    private boolean error;
    private static final Style ERROR_STYLE = Style.NORMAL.deriveColor(ColorKey.ERROR);

    public StepperMotorShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.label = attr.getLabel();
    }

    @Override
    public Pins getPins() {
        if (this.inputs.size() == 4) {
            return new Pins().add(new Pin(new Vector(-40, -20), (PinDescription)this.inputs.get(0))).add(new Pin(new Vector(-40, 0), (PinDescription)this.inputs.get(1))).add(new Pin(new Vector(-40, 20), (PinDescription)this.inputs.get(2))).add(new Pin(new Vector(-40, 40), (PinDescription)this.inputs.get(3))).add(new Pin(new Vector(60, -20), (PinDescription)this.outputs.get(0))).add(new Pin(new Vector(60, 60), (PinDescription)this.outputs.get(1)));
        }
        return new Pins().add(new Pin(new Vector(-40, -20), (PinDescription)this.inputs.get(0))).add(new Pin(new Vector(-40, 0), (PinDescription)this.inputs.get(1))).add(new Pin(new Vector(-40, 20), (PinDescription)this.inputs.get(2))).add(new Pin(new Vector(-40, 40), (PinDescription)this.inputs.get(3))).add(new Pin(new Vector(-40, 60), (PinDescription)this.inputs.get(4))).add(new Pin(new Vector(60, -20), (PinDescription)this.outputs.get(0))).add(new Pin(new Vector(60, 60), (PinDescription)this.outputs.get(1)));
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        this.motor = (StepperMotorUnipolar)ioState.getElement();
        return null;
    }

    @Override
    public void readObservableValues() {
        if (this.motor != null) {
            this.pos = this.motor.getPos();
            this.error = this.motor.isError();
        }
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        Polygon polygon = new Polygon().add(-40, -30).add(60, -30).add(60, 70).add(-40, 70);
        graphic.drawPolygon(polygon, Style.NORMAL);
        Vector center = new Vector(10, 20);
        int radius = 40;
        Vector rad = new Vector(radius, radius);
        graphic.drawCircle(center.sub(rad), center.add(rad), Style.THIN);
        double alpha = Math.PI * 2 * (double)this.pos / 72.0;
        VectorFloat pointer = new VectorFloat((float)(Math.sin(alpha) * (double)radius), (float)(-Math.cos(alpha) * (double)radius));
        if (this.error) {
            graphic.drawLine(center, center.add(pointer), ERROR_STYLE);
        } else {
            graphic.drawLine(center, center.add(pointer), Style.NORMAL);
        }
        if (this.label != null && !this.label.isEmpty()) {
            graphic.drawText(new Vector(10, -40), this.label, Orientation.CENTERBOTTOM, Style.NORMAL);
        }
    }
}

