/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.BitsException;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.Shape;

public class SplitterShape
implements Shape {
    private final PinDescriptions inputs;
    private final PinDescriptions outputs;
    private final int length;
    private final int spreading;
    private Pins pins;

    public SplitterShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) throws BitsException {
        this.inputs = inputs;
        this.outputs = outputs;
        this.spreading = attr.get(Keys.SPLITTER_SPREADING);
        this.length = (Math.max(inputs.size(), outputs.size()) - 1) * this.spreading * 20 + 2;
    }

    @Override
    public Pins getPins() {
        if (this.pins == null) {
            int i;
            this.pins = new Pins();
            for (i = 0; i < this.inputs.size(); ++i) {
                this.pins.add(new Pin(new Vector(0, i * this.spreading * 20), (PinDescription)this.inputs.get(i)));
            }
            for (i = 0; i < this.outputs.size(); ++i) {
                this.pins.add(new Pin(new Vector(20, i * this.spreading * 20), (PinDescription)this.outputs.get(i)));
            }
        }
        return this.pins;
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style heighLight) {
        Vector pos;
        int i;
        for (i = 0; i < this.inputs.size(); ++i) {
            pos = new Vector(-2, i * this.spreading * 20 - 3);
            graphic.drawText(pos, ((PinDescription)this.inputs.get(i)).getName(), Orientation.RIGHTBOTTOM, Style.SHAPE_SPLITTER);
            graphic.drawLine(new Vector(0, i * this.spreading * 20), new Vector(10, i * this.spreading * 20), Style.NORMAL);
        }
        for (i = 0; i < this.outputs.size(); ++i) {
            pos = new Vector(22, i * this.spreading * 20 - 3);
            graphic.drawText(pos, ((PinDescription)this.outputs.get(i)).getName(), Orientation.LEFTBOTTOM, Style.SHAPE_SPLITTER);
            graphic.drawLine(new Vector(20, i * this.spreading * 20), new Vector(10, i * this.spreading * 20), Style.NORMAL);
        }
        graphic.drawPolygon(new Polygon(true).add(8, -2).add(12, -2).add(12, this.length).add(8, this.length), Style.FILLED);
    }
}

