/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.switching.Relay;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;

public class RelayShape
implements Shape {
    private final PinDescriptions inputs;
    private final PinDescriptions outputs;
    private final String label;
    private final int poles;
    private Relay relay;
    private boolean relayIsClosed;
    private Pins pins;

    public RelayShape(ElementAttributes attributes, PinDescriptions inputs, PinDescriptions outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.relayIsClosed = attributes.get(Keys.RELAY_NORMALLY_CLOSED);
        this.label = attributes.getLabel();
        this.poles = attributes.get(Keys.POLES);
    }

    @Override
    public Pins getPins() {
        if (this.pins == null) {
            this.pins = new Pins().add(new Pin(new Vector(0, -40), (PinDescription)this.inputs.get(0))).add(new Pin(new Vector(40, -40), (PinDescription)this.inputs.get(1)));
            int relayStepY = 40;
            int relayBaseY = 0;
            for (int p = 0; p < this.poles; ++p) {
                this.pins.add(new Pin(new Vector(0, relayBaseY), (PinDescription)this.outputs.get(p * 2))).add(new Pin(new Vector(40, relayBaseY), (PinDescription)this.outputs.get(p * 2 + 1)));
                relayBaseY += 40;
            }
        }
        return this.pins;
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        this.relay = (Relay)ioState.getElement();
        return null;
    }

    @Override
    public void readObservableValues() {
        if (this.relay != null) {
            this.relayIsClosed = this.relay.isClosed();
        }
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        int relayTipY;
        int relayTipX;
        if (this.relayIsClosed) {
            relayTipX = 40;
            relayTipY = 0;
        } else {
            relayTipX = 36;
            relayTipY = 10;
        }
        int relayStepY = 40;
        int relayBaseY = 0;
        for (int p = 0; p < this.poles; ++p) {
            graphic.drawLine(new Vector(0, relayBaseY), new Vector(relayTipX, relayBaseY - relayTipY), Style.NORMAL);
            relayBaseY += 40;
        }
        int yOffs = 5 + relayTipY / 2;
        graphic.drawLine(new Vector(20, (this.poles - 1) * 20 * 2 - yOffs), new Vector(20, -19), Style.DASH);
        graphic.drawPolygon(new Polygon(true).add(10, -20).add(10, -60).add(30, -60).add(30, -20), Style.NORMAL);
        graphic.drawLine(new Vector(10, -30), new Vector(30, -50), Style.THIN);
        graphic.drawLine(new Vector(10, -40), new Vector(0, -40), Style.NORMAL);
        graphic.drawLine(new Vector(30, -40), new Vector(40, -40), Style.NORMAL);
        if (this.label != null && this.label.length() > 0) {
            graphic.drawText(new Vector(20, -64), this.label, Orientation.CENTERBOTTOM, Style.SHAPE_PIN);
        }
    }
}

