/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.Shape;
import java.awt.Color;

public class RGBLEDShape
implements Shape {
    private final String label;
    private final PinDescriptions inputs;
    private final long max;
    private final int size;
    private IOState ioState;
    private Color color;

    public RGBLEDShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this.inputs = inputs;
        this.label = attr.getLabel();
        this.max = Bits.mask(attr.getBits());
        int s = attr.get(Keys.LED_SIZE);
        this.size = s > 0 ? s * 15 : 10;
    }

    @Override
    public Pins getPins() {
        return new Pins().add(new Pin(new Vector(0, -20), (PinDescription)this.inputs.get(0))).add(new Pin(new Vector(0, 0), (PinDescription)this.inputs.get(1))).add(new Pin(new Vector(0, 20), (PinDescription)this.inputs.get(2)));
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        this.ioState = ioState;
        return null;
    }

    @Override
    public void readObservableValues() {
        if (this.ioState != null) {
            long r = this.getCol(this.ioState.getInput(0));
            long g = this.getCol(this.ioState.getInput(1));
            long b = this.getCol(this.ioState.getInput(2));
            this.color = new Color((int)r, (int)g, (int)b);
        }
    }

    long getCol(ObservableValue c) {
        if (c.isHighZ()) {
            return 0L;
        }
        return c.getValue() * 255L / this.max;
    }

    @Override
    public void drawTo(Graphic graphic, Style heighLight) {
        if (this.color == null) {
            this.color = Color.RED;
        }
        Vector rad = new Vector(this.size - 2, this.size - 2);
        Vector radL = new Vector(this.size, this.size);
        Vector center = new Vector(1 + this.size, 0);
        graphic.drawLine(new Vector(0, -20), center, Style.NORMAL);
        graphic.drawLine(new Vector(0, 20), center, Style.NORMAL);
        graphic.drawCircle(center.sub(radL), center.add(radL), Style.FILLED);
        graphic.drawCircle(center.sub(rad), center.add(rad), Style.FILLED.deriveColor(this.color));
        Vector textPos = new Vector(2 * this.size + 15, 0);
        graphic.drawText(textPos, this.label, Orientation.LEFTCENTER, Style.NORMAL);
    }
}

