/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;

public class PinControlShape
implements Shape {
    private final PinDescriptions in;
    private final PinDescriptions out;
    private Pins pins;

    public PinControlShape(ElementAttributes attr, PinDescriptions in, PinDescriptions out) {
        this.in = in;
        this.out = out;
    }

    @Override
    public Pins getPins() {
        if (this.pins == null) {
            this.pins = new Pins().add(new Pin(new Vector(0, 0), (PinDescription)this.in.get(0))).add(new Pin(new Vector(20, -20), (PinDescription)this.in.get(1))).add(new Pin(new Vector(40, 20), (PinDescription)this.out.get(0))).add(new Pin(new Vector(60, 0), (PinDescription)this.out.get(1)));
        }
        return this.pins;
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        graphic.drawLine(new Vector(0, 0), new Vector(10, 0), Style.NORMAL);
        graphic.drawLine(new Vector(30, 0), new Vector(60, 0), Style.NORMAL);
        graphic.drawLine(new Vector(40, 0), new Vector(40, 20), Style.NORMAL);
        graphic.drawPolygon(new Polygon().add(10, 10).add(10, -10).add(30, 0), Style.NORMAL);
        graphic.drawLine(new Vector(20, -20), new Vector(20, -6), Style.NORMAL);
    }
}

