/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.Value;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.Shape;

public class MuxerShape
implements Shape {
    private final boolean flip;
    private final int inputCount;
    private final PinDescriptions inputs;
    private final PinDescriptions outputs;
    private Pins pins;
    private ObservableValue selector;
    private Value selectorValue;

    public MuxerShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.inputCount = inputs.size() - 1;
        this.flip = attr.get(Keys.FLIP_SEL_POSITON);
    }

    @Override
    public Pins getPins() {
        if (this.pins == null) {
            this.pins = new Pins();
            this.pins.add(new Pin(new Vector(20, this.flip ? 0 : this.inputCount * 20), (PinDescription)this.inputs.get(0)));
            if (this.inputs.size() == 3) {
                this.pins.add(new Pin(new Vector(0, 0), (PinDescription)this.inputs.get(1)));
                this.pins.add(new Pin(new Vector(0, 40), (PinDescription)this.inputs.get(2)));
            } else {
                for (int i = 0; i < this.inputCount; ++i) {
                    this.pins.add(new Pin(new Vector(0, i * 20), (PinDescription)this.inputs.get(i + 1)));
                }
            }
            this.pins.add(new Pin(new Vector(40, this.inputCount / 2 * 20), (PinDescription)this.outputs.get(0)));
        }
        return this.pins;
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        this.selector = ioState.getInput(0);
        return null;
    }

    @Override
    public void readObservableValues() {
        if (this.selector != null) {
            this.selectorValue = this.selector.getCopy();
        }
    }

    @Override
    public void drawTo(Graphic graphic, Style heighLight) {
        Pins p;
        int in;
        graphic.drawPolygon(new Polygon(true).add(1, -4).add(39, 5).add(39, this.inputCount * 20 - 5).add(1, this.inputCount * 20 + 4), Style.NORMAL);
        graphic.drawText(new Vector(3, 2), "0", Orientation.LEFTTOP, Style.SHAPE_PIN);
        if (this.selectorValue != null && (in = (int)this.selectorValue.getValue() + 1) < (p = this.getPins()).size()) {
            Vector pos = p.get(in).getPos();
            int s = 5;
            graphic.drawCircle(pos.add(-s, -s), pos.add(s, s), Style.THIN);
        }
    }
}

