/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.core.Value;
import de.neemann.digital.core.ValueFormatter;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.io.In;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Transform;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.OutputShape;
import de.neemann.digital.draw.shapes.Shape;
import de.neemann.digital.gui.components.CircuitComponent;
import de.neemann.digital.gui.components.SingleValueDialog;
import de.neemann.gui.Screen;
import java.awt.Point;

public class InputShape
implements Shape {
    private static final int SLIDER_HEIGHT = (int)(300.0f * Screen.getInstance().getScaling());
    private final String label;
    private final PinDescriptions outputs;
    private final ValueFormatter formatter;
    private final boolean isHighZ;
    private final boolean avoidLow;
    private final int bits;
    private final boolean small;
    private IOState ioState;
    private SingleValueDialog dialog;
    private Value value;
    private Value inValue;

    public InputShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this.outputs = outputs;
        String pinNumber = attr.get(Keys.PINNUMBER);
        this.label = pinNumber.length() == 0 ? attr.getLabel() : attr.getLabel() + " (" + pinNumber + ")";
        this.formatter = attr.getValueFormatter();
        this.isHighZ = attr.get(Keys.INPUT_DEFAULT).isHighZ() || attr.get(Keys.IS_HIGH_Z) != false;
        this.avoidLow = this.isHighZ && attr.get(Keys.AVOID_ACTIVE_LOW) != false;
        this.bits = attr.getBits();
        this.small = attr.get(Keys.IN_OUT_SMALL);
    }

    @Override
    public Pins getPins() {
        return new Pins().add(new Pin(new Vector(0, 0), (PinDescription)this.outputs.get(0)));
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        this.ioState = ioState;
        return new InputInteractor();
    }

    public ObservableValue getObservableValue() {
        if (this.ioState == null) {
            return null;
        }
        return this.ioState.getOutput(0);
    }

    @Override
    public void readObservableValues() {
        if (this.ioState != null) {
            this.value = this.ioState.getOutput(0).getCopy();
            if (this.ioState.inputCount() == 1) {
                this.inValue = this.ioState.getInput(0).getCopy();
            }
        }
    }

    @Override
    public void drawTo(Graphic graphic, Style heighLight) {
        if (graphic.isFlagSet(Graphic.Flag.smallIO)) {
            Vector center = new Vector(-OutputShape.LATEX_RAD.x, 0);
            graphic.drawCircle(center.sub(OutputShape.LATEX_RAD), center.add(OutputShape.LATEX_RAD), Style.NORMAL);
            Vector textPos = new Vector(-10 - OutputShape.LATEX_RAD.x, 0);
            graphic.drawText(textPos, this.label, Orientation.RIGHTCENTER, Style.INOUT);
        } else {
            int outSize = OutputShape.getOutSize(this.small);
            Style style = OutputShape.getOutStyle(this.small);
            Polygon box = new Polygon(true).add(-outSize * 2 - 1, -outSize).add(-1, -outSize).add(-1, outSize).add(-outSize * 2 - 1, outSize);
            if (this.value != null) {
                style = Style.getWireStyle(this.value);
                if (this.value.getBits() > 1) {
                    Value v = this.value;
                    if (this.inValue != null) {
                        v = this.inValue;
                    }
                    Vector textPos = new Vector(-1 - outSize, -4 - outSize);
                    graphic.drawText(textPos, this.formatter.formatToView(v), Orientation.CENTERBOTTOM, Style.NORMAL);
                } else if (this.inValue != null && !this.inValue.isEqual(this.value)) {
                    graphic.drawPolygon(box, Style.getWireStyle(this.inValue));
                }
            }
            graphic.drawPolygon(box, Style.NORMAL);
            Vector center = new Vector(-1 - outSize, 0);
            Vector rad = OutputShape.getOutRad(this.small);
            graphic.drawCircle(center.sub(rad), center.add(rad), style);
            Vector textPos = new Vector(-outSize * 3, 0);
            graphic.drawText(textPos, this.label, Orientation.RIGHTCENTER, Style.INOUT);
        }
    }

    private class InputInteractor
    extends Interactor {
        private boolean isDrag;
        private Point startPos;
        private long startValue;
        private long lastValueSet;

        private InputInteractor() {
        }

        @Override
        public void clicked(CircuitComponent cc, Point pos, IOState ioState, Element element, SyncAccess modelSync) {
            ObservableValue value = ioState.getOutput(0);
            if (InputShape.this.bits == 1) {
                modelSync.modify(() -> {
                    if (InputShape.this.isHighZ) {
                        if (value.isHighZ()) {
                            if (InputShape.this.avoidLow) {
                                value.setValue(1L);
                            } else {
                                value.setValue(0L);
                            }
                        } else if (value.getValue() == 0L) {
                            value.setValue(1L);
                        } else {
                            value.setToHighZ();
                        }
                    } else {
                        value.setValue(1L - value.getValue());
                    }
                });
            } else if (InputShape.this.dialog == null || !InputShape.this.dialog.isVisible()) {
                Model model = ((In)element).getModel();
                InputShape.this.dialog = new SingleValueDialog(model.getWindowPosManager().getMainFrame(), pos, InputShape.this.label, value, InputShape.this.isHighZ, model, modelSync).setSelectedFormat(InputShape.this.formatter);
                InputShape.this.dialog.setVisible(true);
            } else {
                InputShape.this.dialog.requestFocus();
            }
        }

        @Override
        public void pressed(CircuitComponent cc, Point pos, IOState ioState, Element element, SyncAccess modelSync) {
            this.isDrag = false;
        }

        @Override
        public void dragged(CircuitComponent cc, Point posOnScreen, Vector pos, Transform transform, IOState ioState, Element element, SyncAccess modelSync) {
            ObservableValue value = ioState.getOutput(0);
            if (InputShape.this.bits > 1 && !value.isHighZ()) {
                if (!this.isDrag) {
                    this.isDrag = true;
                    this.startPos = posOnScreen;
                    this.lastValueSet = this.startValue = value.getValue();
                } else {
                    int dy = this.startPos.y - posOnScreen.y;
                    if (dy != 0) {
                        double inc = (double)dy / (double)SLIDER_HEIGHT;
                        long val = InputShape.this.formatter.dragValue(this.startValue, value.getBits(), inc);
                        if (val != this.lastValueSet) {
                            modelSync.modify(() -> value.setValue(val));
                            this.lastValueSet = val;
                        }
                    }
                }
            }
        }
    }
}

