/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.model.InverterConfig;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.Shape;
import java.awt.Color;

public class GenericShape
implements Shape {
    public static final int SIZE2 = 10;
    public static final int SIZE = 20;
    private final String name;
    private final PinDescriptions inputs;
    private final PinDescriptions outputs;
    private int width;
    private final boolean symmetric;
    private final String label;
    private final boolean showPinLabels;
    private boolean invert = false;
    private Color color = Color.WHITE;
    private Pins pins;
    private InverterConfig inverterConfig;
    private int topBottomBorder = 10;

    public GenericShape(String name, PinDescriptions inputs, PinDescriptions outputs) {
        this(name, inputs, outputs, null, false);
    }

    public GenericShape(String name, PinDescriptions inputs, PinDescriptions outputs, String label, boolean showPinLabels) {
        this(name, inputs, outputs, label, showPinLabels, inputs.size() == 1 && outputs.size() == 1 && !showPinLabels ? 1 : 3);
    }

    public GenericShape(String name, PinDescriptions inputs, PinDescriptions outputs, String label, boolean showPinLabels, int width) {
        this.name = name;
        this.inputs = inputs;
        this.outputs = outputs;
        if (label != null && label.length() == 0) {
            label = null;
        }
        this.label = label == null ? null : this.format(label);
        this.showPinLabels = showPinLabels;
        this.width = width;
        this.symmetric = outputs.size() == 1;
    }

    public GenericShape invert(boolean invert) {
        this.invert = invert;
        return this;
    }

    public GenericShape setTopBottomBorder(int topBottomBorder) {
        this.topBottomBorder = topBottomBorder;
        return this;
    }

    public GenericShape setColor(Color color) {
        if (color != null) {
            this.color = color;
        }
        return this;
    }

    @Override
    public Pins getPins() {
        if (this.pins == null) {
            this.pins = GenericShape.createPins(this.inputs, this.outputs, this.invert, this.width, this.symmetric, this.inverterConfig);
        }
        return this.pins;
    }

    public static Pins createPins(PinDescriptions inputs, PinDescriptions outputs, boolean invert, InverterConfig ic, boolean wideShape) {
        return GenericShape.createPins(inputs, outputs, invert, wideShape ? 4 : 3, true, ic);
    }

    private static Pins createPins(PinDescriptions inputs, PinDescriptions outputs, boolean invert, int width, boolean symmetric, InverterConfig ic) {
        int i;
        Pins pins = new Pins();
        int offs = symmetric ? inputs.size() / 2 * 20 : 0;
        for (i = 0; i < inputs.size(); ++i) {
            int correct = 0;
            if (symmetric && (inputs.size() & 1) == 0 && i >= inputs.size() / 2) {
                correct = 20;
            }
            int dx = 0;
            if (GenericShape.isInverted(((PinDescription)inputs.get(i)).getName(), ic)) {
                dx = -20;
            }
            pins.add(new Pin(new Vector(dx, i * 20 + correct), (PinDescription)inputs.get(i)));
        }
        if (invert) {
            for (i = 0; i < outputs.size(); ++i) {
                pins.add(new Pin(new Vector(20 * (width + 1), i * 20 + offs), (PinDescription)outputs.get(i)));
            }
        } else {
            for (i = 0; i < outputs.size(); ++i) {
                pins.add(new Pin(new Vector(20 * width, i * 20 + offs), (PinDescription)outputs.get(i)));
            }
        }
        return pins;
    }

    private static boolean isInverted(String name, InverterConfig ic) {
        return ic != null && ic.contains(name);
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        int max = Math.max(this.inputs.size(), this.outputs.size());
        int yBottom = (max - 1) * 20 + this.topBottomBorder;
        if (this.symmetric && this.inputs.size() > 0 && (this.inputs.size() & 1) == 0) {
            yBottom += 20;
        }
        Polygon polygon = new Polygon(true).add(1, -this.topBottomBorder).add(20 * this.width - 1, -this.topBottomBorder).add(20 * this.width - 1, yBottom).add(1, yBottom);
        if (this.color != Color.WHITE) {
            graphic.drawPolygon(polygon, Style.NORMAL.deriveFillStyle(this.color));
        }
        graphic.drawPolygon(polygon, Style.NORMAL);
        if (this.invert) {
            int offs = this.symmetric ? this.inputs.size() / 2 * 20 : 0;
            for (int i = 0; i < this.outputs.size(); ++i) {
                graphic.drawCircle(new Vector(20 * this.width + 1, i * 20 - 10 + 1 + offs), new Vector(20 * (this.width + 1) - 1, i * 20 + 10 - 1 + offs), Style.NORMAL);
            }
        }
        if (this.label != null) {
            Vector pos = new Vector(10 * this.width, -this.topBottomBorder - 8);
            graphic.drawText(pos, this.label, Orientation.CENTERBOTTOM, Style.NORMAL);
        }
        if (this.showPinLabels) {
            for (Pin p : this.getPins()) {
                int dx = 4;
                if (GenericShape.isInverted(p.getName(), this.inverterConfig)) {
                    dx += 20;
                }
                if (p.getDirection() == PinDescription.Direction.input) {
                    if (p.isClock()) {
                        int triangle = 7;
                        graphic.drawPolygon(new Polygon(false).add(p.getPos().add(dx - 3, 7)).add(p.getPos().add(dx + 7 - 3, 0)).add(p.getPos().add(dx - 3, -7)), Style.THIN);
                        dx += 7;
                    }
                    graphic.drawText(p.getPos().add(dx, 0), this.format(p.getName()), Orientation.LEFTCENTER, Style.SHAPE_PIN);
                    continue;
                }
                graphic.drawText(p.getPos().add(-4, 0), this.format(p.getName()), Orientation.RIGHTCENTER, Style.SHAPE_PIN);
            }
        }
        if (this.name.length() > 0) {
            if (this.name.length() <= 3 && !this.showPinLabels) {
                Vector pos = new Vector(10 * this.width, -this.topBottomBorder + 4);
                graphic.drawText(pos, this.name, Orientation.CENTERTOP, Style.NORMAL);
            } else {
                Vector pos = new Vector(10 * this.width, yBottom + 4);
                graphic.drawText(pos, this.name, Orientation.CENTERTOP, Style.SHAPE_PIN);
            }
        }
        GenericShape.drawInputInvert(graphic, this.inverterConfig, this.getPins());
    }

    public static void drawInputInvert(Graphic graphic, InverterConfig inverterConfig, Pins pins) {
        if (inverterConfig != null && !inverterConfig.isEmpty()) {
            for (Pin p : pins) {
                if (p.getDirection() != PinDescription.Direction.input || !inverterConfig.contains(p.getName())) continue;
                graphic.drawCircle(p.getPos().add(2, -8), p.getPos().add(18, 8), Style.NORMAL);
            }
        }
    }

    public GenericShape setInverterConfig(InverterConfig inverterConfig) {
        this.inverterConfig = inverterConfig.isEmpty() ? null : inverterConfig;
        return this;
    }

    public GenericShape setWide(boolean wideShape) {
        if (wideShape) {
            ++this.width;
        }
        return this;
    }

    public String format(String s) {
        return s;
    }
}

