/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;

public class DiodeBackwardShape
implements Shape {
    private final PinDescriptions inputs;
    private final PinDescriptions outputs;
    private final boolean blown;

    public DiodeBackwardShape(ElementAttributes attributes, PinDescriptions inputs, PinDescriptions outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.blown = attributes.get(Keys.BLOWN);
    }

    @Override
    public Pins getPins() {
        return new Pins().add(new Pin(new Vector(0, 0), (PinDescription)this.inputs.get(0))).add(new Pin(new Vector(0, -20), (PinDescription)this.outputs.get(0)));
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        Style style = this.blown ? Style.DASH : Style.NORMAL;
        graphic.drawPolygon(new Polygon(true).add(-10, -19).add(10, -19).add(0, -1), style);
        graphic.drawLine(new Vector(-10, -1), new Vector(10, -1), style);
    }
}

