/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Interactor;
import de.neemann.digital.draw.shapes.Shape;

public class DemuxerShape
implements Shape {
    private final int outputCount;
    private final boolean hasInput;
    private final boolean flip;
    private final int height;
    private final PinDescriptions inputs;
    private final PinDescriptions outputs;
    private Pins pins;

    public DemuxerShape(ElementAttributes attr, PinDescriptions inputs, PinDescriptions outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.flip = attr.get(Keys.FLIP_SEL_POSITON);
        this.outputCount = 1 << attr.get(Keys.SELECTOR_BITS);
        this.hasInput = inputs.size() > 1;
        this.height = this.hasInput || this.outputCount <= 2 ? this.outputCount * 20 : (this.outputCount - 1) * 20;
    }

    @Override
    public Pins getPins() {
        if (this.pins == null) {
            this.pins = new Pins();
            this.pins.add(new Pin(new Vector(20, this.flip ? 0 : this.height), (PinDescription)this.inputs.get(0)));
            if (this.outputCount == 2) {
                this.pins.add(new Pin(new Vector(40, 0), (PinDescription)this.outputs.get(0)));
                this.pins.add(new Pin(new Vector(40, 40), (PinDescription)this.outputs.get(1)));
            } else {
                for (int i = 0; i < this.outputCount; ++i) {
                    this.pins.add(new Pin(new Vector(40, i * 20), (PinDescription)this.outputs.get(i)));
                }
            }
            if (this.hasInput) {
                this.pins.add(new Pin(new Vector(0, this.outputCount / 2 * 20), (PinDescription)this.inputs.get(1)));
            }
        }
        return this.pins;
    }

    @Override
    public Interactor applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        graphic.drawPolygon(new Polygon(true).add(1, 5).add(39, -4).add(39, this.height + 4).add(1, this.height - 5), Style.NORMAL);
        graphic.drawText(new Vector(37, 2), "0", Orientation.RIGHTTOP, Style.SHAPE_PIN);
    }
}

