/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.shapes;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.graphics.ColorKey;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.InteractorInterface;
import de.neemann.digital.draw.shapes.Shape;

public class AsyncClockShape
implements Shape {
    private static final Style ASYNCSTYLE = Style.NORMAL.deriveFillStyle(ColorKey.ASYNC);
    private final String label;

    public AsyncClockShape(ElementAttributes attributes, PinDescriptions inputs, PinDescriptions outputs) {
        this.label = attributes.getLabel();
    }

    @Override
    public Pins getPins() {
        return new Pins();
    }

    @Override
    public InteractorInterface applyStateMonitor(IOState ioState) {
        return null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        if (!graphic.isFlagSet(Graphic.Flag.hideTest)) {
            Polygon pol = new Polygon(true).add(10, 10).add(90, 10).add(90, 50).add(10, 50);
            graphic.drawPolygon(pol, ASYNCSTYLE);
            graphic.drawPolygon(pol, Style.THIN);
            graphic.drawText(new Vector(50, 30), "Async", Orientation.CENTERCENTER, Style.NORMAL);
            graphic.drawText(new Vector(50, 0), this.label, Orientation.CENTERBOTTOM, Style.NORMAL);
        }
    }
}

