/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.model;

import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.IOState;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.model.InverterConfig;
import de.neemann.digital.gui.components.CircuitModifier;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class ModelEntry {
    private final Element element;
    private final Pins pins;
    private final PinDescriptions inputNames;
    private final boolean isNestedElement;
    private final File origin;
    private final VisualElement containingVisualElement;
    private final VisualElement visualElement;
    private IOState ioState;

    public ModelEntry(Element element, Pins pins, VisualElement visualElement, PinDescriptions inputNames, boolean isNestedElement, File origin, VisualElement containingVisualElement) {
        this.element = element;
        this.pins = pins;
        this.visualElement = visualElement;
        this.inputNames = inputNames;
        this.isNestedElement = isNestedElement;
        this.origin = origin;
        this.containingVisualElement = containingVisualElement;
    }

    public void applyInputs() throws PinException, NodeException {
        try {
            HashMap<String, Pin> ins = this.pins.getInputs();
            InverterConfig ic = this.visualElement.getElementAttributes().get(Keys.INVERTER_CONFIG);
            ObservableValues values = ObservableValues.EMPTY_LIST;
            ArrayList<ObservableValue> inputs = new ArrayList<ObservableValue>();
            for (PinDescription inputName : this.inputNames) {
                Pin pin = ins.get(inputName.getName());
                if (pin == null) {
                    throw new PinException(Lang.get("err_pin_N0_atElement_N1_notFound", inputName, this.visualElement), this.containingVisualElement);
                }
                ObservableValue value = pin.getValue();
                if (value == null) {
                    throw new PinException(Lang.get("err_noValueSetFor_N0_atElement_N1", inputName, this.visualElement), this.containingVisualElement);
                }
                inputs.add(ic.invert(inputName.getName(), value));
            }
            ArrayList<ObservableValue> bidirect = null;
            for (Pin p : this.pins) {
                ObservableValue readerValue;
                if (p.getDirection() != PinDescription.Direction.both) continue;
                if (bidirect == null) {
                    bidirect = new ArrayList<ObservableValue>();
                }
                if ((readerValue = p.getReaderValue()) == null && !p.isSwitchPin()) {
                    throw new PinException(Lang.get("err_noValueSetFor_N0_atElement_N1", p.getName(), this.visualElement), this.containingVisualElement);
                }
                bidirect.add(readerValue);
            }
            if (bidirect != null) {
                inputs.addAll(bidirect);
            }
            if (inputs.size() > 0) {
                values = new ObservableValues((Collection<ObservableValue>)inputs);
                this.element.setInputs(values);
            }
            this.ioState = new IOState(values, this.element.getOutputs(), this.element);
        }
        catch (NodeException | PinException e) {
            e.setOrigin(this.origin);
            e.setVisualElement(this.containingVisualElement);
            throw e;
        }
    }

    public void connectToGui(CircuitModifier circuitModifier) {
        if (!this.isNestedElement) {
            if (this.ioState == null) {
                throw new RuntimeException("call applyInputs before connectToGui");
            }
            this.visualElement.setState(this.ioState);
            this.element.enableCircuitModification(this.visualElement, circuitModifier);
        }
    }

    public Pins getPins() {
        return this.pins;
    }

    public Element getElement() {
        return this.element;
    }

    public VisualElement getVisualElement() {
        return this.visualElement;
    }

    public IOState getIoState() {
        return this.ioState;
    }

    public VisualElement getContainingVisualElement() {
        return this.containingVisualElement;
    }
}

