/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.library;

import de.neemann.digital.analyse.SubstituteLibrary;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.elements.Wire;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.draw.library.ElementTypeDescriptionCustom;
import de.neemann.digital.draw.library.GenericCode;
import de.neemann.digital.draw.library.GenericInitCode;
import de.neemann.digital.draw.library.LibraryInterface;
import de.neemann.digital.hdl.hgs.Context;
import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.hgs.HGSMap;
import de.neemann.digital.hdl.hgs.Parser;
import de.neemann.digital.hdl.hgs.ParserException;
import de.neemann.digital.hdl.hgs.Statement;
import de.neemann.digital.hdl.hgs.Value;
import de.neemann.digital.hdl.hgs.function.Function;
import de.neemann.digital.hdl.hgs.function.InnerFunction;
import de.neemann.digital.lang.Lang;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveGenerics {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolveGenerics.class);
    public static final String GEN_ARGS_KEY = "genArgs";
    private static final String SETTINGS_KEY = "settings";
    private static final String GLOBALS_KEY = "global";
    private static final String THIS_KEY = "this";
    private final HashMap<String, Statement> map;
    private final HashMap<Args, CircuitHolder> circuitMap;
    private final Circuit circuit;
    private final LibraryInterface library;

    public ResolveGenerics(Circuit circuit, LibraryInterface library) {
        this.circuit = circuit;
        this.library = library;
        this.map = new HashMap();
        this.circuitMap = new HashMap();
    }

    public CircuitHolder resolveCircuit(ElementAttributes attributes) throws NodeException, ElementNotFoundException {
        try {
            Args args = attributes == null ? this.createArgsFromGenericInitBlock() : this.createArgsFromParentCircuitEmbedding(attributes);
            CircuitHolder ch = this.circuitMap.get(args);
            if (ch == null) {
                ch = this.createResolvedCircuit(args);
                this.circuitMap.put(args, ch);
            }
            return ch;
        }
        catch (NodeException e) {
            e.setOrigin(this.circuit.getOrigin());
            throw e;
        }
    }

    private Args createArgsFromParentCircuitEmbedding(ElementAttributes attributes) throws NodeException {
        Context context = (Context)attributes.getFromCache(GEN_ARGS_KEY);
        if (context == null) {
            String argsCode = attributes.get(Keys.GENERIC);
            try {
                Statement s = this.getStatement(argsCode);
                context = new Context(this.circuit.getOrigin());
                s.execute(context);
            }
            catch (HGSEvalException | ParserException | IOException e) {
                throw new NodeException(Lang.get("err_evaluatingGenericsCode_N_N", null, argsCode), e);
            }
        }
        return new Args(context);
    }

    private Args createArgsFromGenericInitBlock() throws NodeException {
        Context context = new Context(this.circuit.getOrigin());
        List<VisualElement> g = this.circuit.getElements(v -> v.equalsDescription(GenericInitCode.DESCRIPTION) && v.getElementAttributes().get(Keys.ENABLED) != false);
        if (g.size() == 0) {
            throw new NodeException(Lang.get("err_noGenericInitCode", new Object[0]), new ObservableValue[0]);
        }
        if (g.size() > 1) {
            throw new NodeException(Lang.get("err_multipleGenericInitCodes", new Object[0]), new ObservableValue[0]);
        }
        String argsCode = g.get(0).getElementAttributes().get(Keys.GENERIC);
        try {
            this.getStatement(argsCode).execute(context);
        }
        catch (HGSEvalException | ParserException | IOException e) {
            throw new NodeException(Lang.get("err_inGenericInitCode", new Object[0]), e);
        }
        if (this.circuit.getOrigin() != null) {
            try {
                context.declareVar("baseFile", this.circuit.getOrigin());
            }
            catch (HGSEvalException hGSEvalException) {
                // empty catch block
            }
        }
        return new Args(context);
    }

    private CircuitHolder createResolvedCircuit(Args args) throws NodeException, ElementNotFoundException {
        LOGGER.debug("create concrete circuit based on " + this.circuit.getOrigin() + " width: " + args);
        Circuit c = this.circuit.createDeepCopy();
        ArrayList<VisualElement> newComponents = new ArrayList<VisualElement>();
        ArrayList<Wire> newWires = new ArrayList<Wire>();
        Globals globals = new Globals();
        for (VisualElement ve : c.getElements()) {
            if (!ve.equalsDescription(GenericCode.DESCRIPTION)) continue;
            this.handleVisualElement(c, ve, args, newComponents, newWires, globals);
            globals.lock();
        }
        globals.lock();
        for (VisualElement ve : c.getElements()) {
            if (ve.equalsDescription(GenericCode.DESCRIPTION)) continue;
            this.handleVisualElement(c, ve, args, newComponents, newWires, globals);
        }
        c.add(newWires);
        for (VisualElement ve : newComponents) {
            c.add(ve);
        }
        return new CircuitHolder(c, args);
    }

    private void handleVisualElement(Circuit c, VisualElement ve, Args args, ArrayList<VisualElement> newComponents, ArrayList<Wire> newWires, Globals globals) throws ElementNotFoundException, NodeException {
        ElementAttributes elementAttributes = ve.getElementAttributes();
        String gen = elementAttributes.get(Keys.GENERIC).trim();
        try {
            if (!gen.isEmpty()) {
                ElementTypeDescription elementTypeDescription = this.library.getElementType(ve.getElementName(), elementAttributes);
                boolean isCustom = elementTypeDescription instanceof ElementTypeDescriptionCustom;
                Statement genS = this.getStatement(gen);
                Context mod = this.createContext(c, newComponents, newWires, args).declareVar(GLOBALS_KEY, globals).declareVar("args", args);
                if (isCustom) {
                    mod.declareFunc("setCircuit", new SetCircuitFunc(ve));
                } else {
                    mod.declareVar(THIS_KEY, new SubstituteLibrary.AllowSetAttributes(elementAttributes));
                }
                genS.execute(mod);
                elementAttributes.putToCache(GEN_ARGS_KEY, mod);
            }
        }
        catch (HGSEvalException | ParserException | IOException e) {
            throw new NodeException(Lang.get("err_evaluatingGenericsCode_N_N", ve, gen), e);
        }
    }

    private Context createContext(Circuit circuit, ArrayList<VisualElement> newComponents, ArrayList<Wire> newWires, Args args) throws NodeException {
        try {
            Context context = new Context(circuit.getOrigin());
            if (circuit.getOrigin() != null) {
                context.declareVar("baseFile", circuit.getOrigin());
            }
            context.declareVar(SETTINGS_KEY, new SubstituteLibrary.AllowSetAttributes(circuit.getAttributes()));
            context.declareFunc("addWire", new AddWire(newWires));
            context.declareFunc("addComponent", new AddComponent(newComponents, args));
            return context;
        }
        catch (HGSEvalException e) {
            throw new NodeException("error setting the base filename", e);
        }
    }

    private Statement getStatement(String code) throws IOException, ParserException {
        Statement genS = this.map.get(code);
        if (genS == null) {
            genS = new Parser(code).parse(false);
            this.map.put(code, genS);
        }
        return genS;
    }

    private static String createGenericCode(Context args) {
        StringBuilder sb = new StringBuilder();
        HashSet<String> contentSet = new HashSet<String>();
        ResolveGenerics.addVal(sb, "", args, contentSet);
        return sb.toString();
    }

    private static void addVal(StringBuilder sb, String key, Object val, HashSet<String> contentSet) {
        if (contentSet.contains(key)) {
            return;
        }
        if (val instanceof InnerFunction) {
            return;
        }
        if (val instanceof Context) {
            Object v;
            Context c = (Context)val;
            for (String k : c.getKeySet()) {
                v = c.hgsMapGet(k);
                if (v instanceof Args) continue;
                ResolveGenerics.addVal(sb, k, v, contentSet);
            }
            for (String k : c.getKeySet()) {
                v = c.hgsMapGet(k);
                if (!(v instanceof Args)) continue;
                ResolveGenerics.addVal(sb, k, ((Args)v).args, contentSet);
            }
            return;
        }
        if (!(key.equals("baseFile") || key.equals(SETTINGS_KEY) || key.equals(GLOBALS_KEY) || key.equals(THIS_KEY))) {
            contentSet.add(key);
            sb.append(key).append(":=");
            ResolveGenerics.addToStringBuilder(sb, val);
            sb.append(";\n");
        }
    }

    private static void addToStringBuilder(StringBuilder sb, Object val) {
        if (val instanceof String) {
            sb.append("\"");
            ResolveGenerics.escapeString(sb, (String)val);
            sb.append("\"");
        } else if (val instanceof Integer) {
            sb.append("int(").append(val).append(")");
        } else if (val instanceof List) {
            sb.append("[");
            boolean first = true;
            for (Object o : (List)val) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                ResolveGenerics.addToStringBuilder(sb, o);
            }
            sb.append("]");
        } else if (val instanceof Map) {
            sb.append("{");
            boolean first = true;
            for (Map.Entry e : ((Map)val).entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(e.getKey().toString());
                sb.append(":");
                ResolveGenerics.addToStringBuilder(sb, e.getValue());
            }
            sb.append("}");
        } else {
            sb.append(val);
        }
    }

    static void escapeString(StringBuilder sb, String str) {
        block7: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block7;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block7;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block7;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block7;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    private static final class Globals
    implements HGSMap {
        private final HashMap<String, Object> map = new HashMap();
        private boolean writeEnable = true;

        private Globals() {
        }

        @Override
        public void hgsMapPut(String key, Object val) throws HGSEvalException {
            if (!this.writeEnable) {
                throw new HGSEvalException(Lang.get("err_writeInCodeComponentsOnly", new Object[0]));
            }
            this.map.put(key, val);
        }

        @Override
        public Object hgsMapGet(String key) throws HGSEvalException {
            return this.map.get(key);
        }

        public void lock() {
            this.writeEnable = false;
        }
    }

    private final class AddComponent
    extends Function {
        private final ArrayList<VisualElement> newComponents;
        private final Args args;

        private AddComponent(ArrayList<VisualElement> newComponents, Args args) {
            super(3);
            this.newComponents = newComponents;
            this.args = args;
        }

        @Override
        protected Object f(Object ... args) throws HGSEvalException {
            String name = args[0].toString();
            Vector pos = new Vector(Value.toInt(args[1]) * 20, Value.toInt(args[2]) * 20);
            VisualElement ve = new VisualElement(name).setPos(pos).setShapeFactory(ResolveGenerics.this.library.getShapeFactory());
            this.newComponents.add(ve);
            ElementAttributes elementAttributes = ve.getElementAttributes();
            try {
                ElementTypeDescriptionCustom etdc;
                ElementTypeDescription etd = ResolveGenerics.this.library.getElementType(ve.getElementName(), ve.getElementAttributes());
                if (etd instanceof ElementTypeDescriptionCustom && (etdc = (ElementTypeDescriptionCustom)etd).isGeneric()) {
                    Context c = new Context(ResolveGenerics.this.circuit.getOrigin()){

                        @Override
                        public void hgsMapPut(String key, Object val) throws HGSEvalException {
                            this.declareVar(key, val);
                        }
                    }.declareVar("args", this.args).declareVar(ResolveGenerics.THIS_KEY, new SubstituteLibrary.AllowSetAttributes(elementAttributes));
                    elementAttributes.putToCache(ResolveGenerics.GEN_ARGS_KEY, c);
                    return c;
                }
            }
            catch (ElementNotFoundException e) {
                e.printStackTrace();
            }
            return new SubstituteLibrary.AllowSetAttributes(elementAttributes);
        }
    }

    private static final class AddWire
    extends Function {
        private final ArrayList<Wire> wires;

        private AddWire(ArrayList<Wire> wires) {
            super(4);
            this.wires = wires;
        }

        @Override
        protected Object f(Object ... args) throws HGSEvalException {
            Vector p1 = new Vector(Value.toInt(args[0]) * 20, Value.toInt(args[1]) * 20);
            Vector p2 = new Vector(Value.toInt(args[2]) * 20, Value.toInt(args[3]) * 20);
            this.wires.add(new Wire(p1, p2));
            return null;
        }
    }

    private static final class SetCircuitFunc
    extends Function {
        private final VisualElement ve;

        private SetCircuitFunc(VisualElement ve) {
            super(1);
            this.ve = ve;
        }

        @Override
        protected Object f(Object ... args) {
            this.ve.setElementName(args[0].toString());
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 0;
        }
    }

    public final class CircuitHolder {
        private final Circuit circuit;
        private final Args args;

        private CircuitHolder(Circuit circuit, Args args) {
            this.circuit = circuit;
            this.args = args;
        }

        public Circuit getCircuit() {
            return this.circuit;
        }

        public Args getArgs() {
            return this.args;
        }

        public CircuitHolder cleanupConcreteCircuit() {
            for (VisualElement gic : this.circuit.getElements(v -> v.equalsDescription(GenericInitCode.DESCRIPTION) || v.equalsDescription(GenericCode.DESCRIPTION))) {
                this.circuit.delete(gic);
            }
            for (VisualElement v2 : this.circuit.getElements()) {
                try {
                    boolean isCustom = ResolveGenerics.this.library.getElementType(v2.getElementName(), v2.getElementAttributes()) instanceof ElementTypeDescriptionCustom;
                    if (isCustom) {
                        v2.getElementAttributes().set(Keys.GENERIC, ResolveGenerics.createGenericCode((Context)v2.getElementAttributes().getFromCache(ResolveGenerics.GEN_ARGS_KEY)));
                    } else {
                        v2.getElementAttributes().set(Keys.GENERIC, "");
                    }
                }
                catch (ElementNotFoundException e) {
                    e.printStackTrace();
                }
                v2.getElementAttributes().removeFromCache(ResolveGenerics.GEN_ARGS_KEY);
            }
            this.circuit.getAttributes().set(Keys.IS_GENERIC, false);
            return this;
        }
    }

    public static final class Args
    implements HGSMap {
        private final Context args;

        private Args(Context args) {
            this.args = args;
        }

        @Override
        public Object hgsMapGet(String key) throws HGSEvalException {
            Object a;
            Object v = this.args.hgsMapGet(key);
            if (v == null && (a = this.args.hgsMapGet("args")) instanceof HGSMap) {
                return ((HGSMap)a).hgsMapGet(key);
            }
            return v;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Args that = (Args)o;
            return this.args.equals(that.args);
        }

        public int hashCode() {
            return Objects.hash(this.args);
        }

        public String toString() {
            return "[" + this.args.toStringKeys() + "]";
        }
    }
}

