/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.library;

import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.draw.library.ComponentManager;
import de.neemann.digital.draw.library.ComponentSource;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.InvalidNodeException;
import de.neemann.digital.draw.shapes.ShapeFactory;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarComponentManager
implements ComponentManager,
Iterable<AdditionalShape> {
    private final ElementLibrary library;
    private final ArrayList<AdditionalShape> additionalShapes;

    JarComponentManager(ElementLibrary library) {
        this.library = library;
        this.additionalShapes = new ArrayList();
    }

    @Override
    public void addComponent(String nodePath, ElementTypeDescription description) throws InvalidNodeException {
        this.library.findNode(nodePath).add(description);
    }

    @Override
    public void addComponent(String nodePath, ElementTypeDescription description, ShapeFactory.Creator shape) throws InvalidNodeException {
        this.library.findNode(nodePath).add(description);
        this.additionalShapes.add(new AdditionalShape(description, shape));
    }

    @Override
    public Iterator<AdditionalShape> iterator() {
        return this.additionalShapes.iterator();
    }

    public void loadJar(File file) throws IOException, InvalidNodeException {
        Manifest manifest;
        try (JarFile jarFile = new JarFile(file);){
            manifest = jarFile.getManifest();
        }
        if (manifest == null) {
            throw new IOException(Lang.get("err_noManifestFound", new Object[0]));
        }
        Attributes attr = manifest.getMainAttributes();
        String main = attr.getValue("Main-Class");
        if (main == null) {
            throw new IOException(Lang.get("err_noMainFoundInManifest", new Object[0]));
        }
        URLClassLoader cl = new URLClassLoader(new URL[]{file.toURI().toURL()});
        try {
            Class<?> c = cl.loadClass(main);
            ComponentSource cs = (ComponentSource)c.newInstance();
            cs.registerComponents(this);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(Lang.get("err_mainClass_N_NotFound", main));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IOException(Lang.get("err_couldNotInitializeMainClass_N", main));
        }
    }

    public static class AdditionalShape {
        private final ElementTypeDescription description;
        private final ShapeFactory.Creator shape;

        AdditionalShape(ElementTypeDescription description, ShapeFactory.Creator shape) {
            this.description = description;
            this.shape = shape;
        }

        public ElementTypeDescription getDescription() {
            return this.description;
        }

        public ShapeFactory.Creator getShape() {
            return this.shape;
        }
    }
}

