/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.library;

import de.neemann.digital.draw.library.LibraryNode;
import de.neemann.digital.draw.library.NumStringComparator;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementLibraryFolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementLibraryFolder.class);
    private static final int MAX_FILES_TO_SCAN = 5000;
    private static final int MAX_MENU_SIZE = 12;
    private final LibraryNode root;
    private final String menuTitle;
    private LibraryNode node;

    public ElementLibraryFolder(LibraryNode root, String menuTitle) {
        this.root = root;
        this.menuTitle = menuTitle;
    }

    public LibraryNode getNode() {
        return this.node;
    }

    public LibraryNode scanFolder(File path, boolean isLibrary) {
        LibraryNode changedNode = null;
        if (path != null) {
            if (this.node == null) {
                this.node = new LibraryNode(this.menuTitle);
                this.root.add(this.node);
                changedNode = this.root;
            } else {
                this.node.removeAll();
                changedNode = this.node;
            }
            ScanCounter scanCounter = new ScanCounter();
            ElementLibraryFolder.scanFolder(path, this.node, scanCounter, isLibrary);
            LOGGER.debug("found " + scanCounter.getCircuitCounter() + " files in " + path);
        } else if (this.node != null) {
            this.root.remove(this.node);
            this.node = null;
            changedNode = this.root;
        }
        return changedNode;
    }

    /*
     * WARNING - void declaration
     */
    private static void scanFolder(File path, LibraryNode node, ScanCounter scanCounter, boolean isLibrary) {
        block9: {
            File[] list = path.listFiles();
            if (list == null || scanCounter.getFileCounter() >= 5000) break block9;
            ArrayList<File> orderedList = new ArrayList<File>(Arrays.asList(list));
            orderedList.sort((f1, f2) -> NumStringComparator.compareStr(f1.getName(), f2.getName()));
            for (File file : orderedList) {
                if (!file.isDirectory() || file.isHidden()) continue;
                LibraryNode n = new LibraryNode(file.getName());
                ElementLibraryFolder.scanFolder(file, n, scanCounter, isLibrary);
                if (n.isEmpty()) continue;
                node.add(n);
            }
            ArrayList<File> fileList = new ArrayList<File>();
            for (File f : orderedList) {
                scanCounter.incFile();
                String name = f.getName();
                if (!f.isFile() || !name.endsWith(".dig")) continue;
                fileList.add(f);
                scanCounter.incCircuit();
            }
            if (fileList.size() <= 13) {
                for (File f : fileList) {
                    node.add(new LibraryNode(f, isLibrary));
                }
            } else {
                void var7_11;
                boolean bl = false;
                while (var7_11 < 12) {
                    node.add(new LibraryNode((File)fileList.get((int)var7_11), isLibrary));
                    ++var7_11;
                }
                int n = fileList.size() - 12;
                int subMenus = (n - 1) / 12 + 1;
                int delta = (n - 1) / subMenus + 1;
                int pos = 12;
                while (pos < fileList.size()) {
                    int pos2 = pos + delta;
                    if (pos2 > fileList.size()) {
                        pos2 = fileList.size();
                    }
                    String name = subMenus > 1 ? ElementLibraryFolder.clean((File)fileList.get(pos)) + " - " + ElementLibraryFolder.clean((File)fileList.get(pos2 - 1)) : Lang.get("lib_more", new Object[0]);
                    LibraryNode n2 = new LibraryNode(name);
                    node.add(n2);
                    for (int p = pos; p < pos2; ++p) {
                        n2.add(new LibraryNode((File)fileList.get(p), isLibrary));
                    }
                    pos = pos2;
                }
            }
        }
    }

    private static String clean(File file) {
        String s = file.getName();
        if (s.endsWith(".dig")) {
            s = s.substring(0, s.length() - 4);
        }
        return s;
    }

    private static final class ScanCounter {
        private int fileCounter;
        private int circuitCounter;

        private ScanCounter() {
        }

        private void incFile() {
            ++this.fileCounter;
        }

        private int getFileCounter() {
            return this.fileCounter;
        }

        private void incCircuit() {
            ++this.circuitCounter;
        }

        private int getCircuitCounter() {
            return this.circuitCounter;
        }
    }
}

