/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.library;

import de.neemann.digital.core.arithmetic.Add;
import de.neemann.digital.core.arithmetic.BarrelShifter;
import de.neemann.digital.core.arithmetic.BitCount;
import de.neemann.digital.core.arithmetic.BitExtender;
import de.neemann.digital.core.arithmetic.Comparator;
import de.neemann.digital.core.arithmetic.Div;
import de.neemann.digital.core.arithmetic.Mul;
import de.neemann.digital.core.arithmetic.Neg;
import de.neemann.digital.core.arithmetic.PRNG;
import de.neemann.digital.core.arithmetic.Sub;
import de.neemann.digital.core.basic.And;
import de.neemann.digital.core.basic.NAnd;
import de.neemann.digital.core.basic.NOr;
import de.neemann.digital.core.basic.Not;
import de.neemann.digital.core.basic.Or;
import de.neemann.digital.core.basic.XNOr;
import de.neemann.digital.core.basic.XOr;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.extern.External;
import de.neemann.digital.core.extern.ExternalFile;
import de.neemann.digital.core.flipflops.FlipflopD;
import de.neemann.digital.core.flipflops.FlipflopDAsync;
import de.neemann.digital.core.flipflops.FlipflopJK;
import de.neemann.digital.core.flipflops.FlipflopJKAsync;
import de.neemann.digital.core.flipflops.FlipflopRS;
import de.neemann.digital.core.flipflops.FlipflopRSAsync;
import de.neemann.digital.core.flipflops.FlipflopT;
import de.neemann.digital.core.flipflops.Monoflop;
import de.neemann.digital.core.io.Button;
import de.neemann.digital.core.io.ButtonLED;
import de.neemann.digital.core.io.Const;
import de.neemann.digital.core.io.DipSwitch;
import de.neemann.digital.core.io.Ground;
import de.neemann.digital.core.io.In;
import de.neemann.digital.core.io.LightBulb;
import de.neemann.digital.core.io.MIDI;
import de.neemann.digital.core.io.NotConnected;
import de.neemann.digital.core.io.Out;
import de.neemann.digital.core.io.PinControl;
import de.neemann.digital.core.io.PowerSupply;
import de.neemann.digital.core.io.Probe;
import de.neemann.digital.core.io.RGBLED;
import de.neemann.digital.core.io.RotEncoder;
import de.neemann.digital.core.io.StepperMotorBipolar;
import de.neemann.digital.core.io.StepperMotorUnipolar;
import de.neemann.digital.core.io.VDD;
import de.neemann.digital.core.io.telnet.Telnet;
import de.neemann.digital.core.memory.BlockRAMDualPort;
import de.neemann.digital.core.memory.Counter;
import de.neemann.digital.core.memory.CounterPreset;
import de.neemann.digital.core.memory.EEPROM;
import de.neemann.digital.core.memory.EEPROMDualPort;
import de.neemann.digital.core.memory.LookUpTable;
import de.neemann.digital.core.memory.RAMAsync;
import de.neemann.digital.core.memory.RAMDualAccess;
import de.neemann.digital.core.memory.RAMDualPort;
import de.neemann.digital.core.memory.RAMSinglePort;
import de.neemann.digital.core.memory.RAMSinglePortSel;
import de.neemann.digital.core.memory.ROM;
import de.neemann.digital.core.memory.ROMDualPort;
import de.neemann.digital.core.memory.Register;
import de.neemann.digital.core.memory.RegisterFile;
import de.neemann.digital.core.pld.DiodeBackward;
import de.neemann.digital.core.pld.DiodeForward;
import de.neemann.digital.core.pld.PullDown;
import de.neemann.digital.core.pld.PullUp;
import de.neemann.digital.core.switching.FGNFET;
import de.neemann.digital.core.switching.FGPFET;
import de.neemann.digital.core.switching.Fuse;
import de.neemann.digital.core.switching.NFET;
import de.neemann.digital.core.switching.PFET;
import de.neemann.digital.core.switching.Relay;
import de.neemann.digital.core.switching.RelayDT;
import de.neemann.digital.core.switching.Switch;
import de.neemann.digital.core.switching.SwitchDT;
import de.neemann.digital.core.switching.TransGate;
import de.neemann.digital.core.wiring.AsyncSeq;
import de.neemann.digital.core.wiring.BitSelector;
import de.neemann.digital.core.wiring.Break;
import de.neemann.digital.core.wiring.BusSplitter;
import de.neemann.digital.core.wiring.Clock;
import de.neemann.digital.core.wiring.Decoder;
import de.neemann.digital.core.wiring.Delay;
import de.neemann.digital.core.wiring.Demultiplexer;
import de.neemann.digital.core.wiring.Driver;
import de.neemann.digital.core.wiring.DriverInvSel;
import de.neemann.digital.core.wiring.Multiplexer;
import de.neemann.digital.core.wiring.PriorityEncoder;
import de.neemann.digital.core.wiring.Reset;
import de.neemann.digital.core.wiring.Splitter;
import de.neemann.digital.core.wiring.Stop;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.Tunnel;
import de.neemann.digital.draw.library.ComponentSource;
import de.neemann.digital.draw.library.CustomElement;
import de.neemann.digital.draw.library.ElementLibraryFolder;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.draw.library.ElementTypeDescriptionCustom;
import de.neemann.digital.draw.library.GenericCode;
import de.neemann.digital.draw.library.GenericInitCode;
import de.neemann.digital.draw.library.InvalidNodeException;
import de.neemann.digital.draw.library.JarComponentManager;
import de.neemann.digital.draw.library.LibraryInterface;
import de.neemann.digital.draw.library.LibraryListener;
import de.neemann.digital.draw.library.LibraryNode;
import de.neemann.digital.draw.library.Visitor;
import de.neemann.digital.draw.shapes.ShapeFactory;
import de.neemann.digital.gui.Settings;
import de.neemann.digital.gui.components.data.DummyElement;
import de.neemann.digital.gui.components.data.ScopeTrigger;
import de.neemann.digital.gui.components.graphics.GraphicCard;
import de.neemann.digital.gui.components.graphics.LedMatrix;
import de.neemann.digital.gui.components.graphics.VGA;
import de.neemann.digital.gui.components.terminal.Keyboard;
import de.neemann.digital.gui.components.terminal.Terminal;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.TestCaseElement;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementLibrary
implements Iterable<ElementContainer>,
LibraryInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementLibrary.class);
    private static final long MIN_RESCAN_INTERVAL = 5000L;
    private final HashMap<String, LibraryNode> map = new HashMap();
    private final HashSet<String> isProgrammable = new HashSet();
    private final ArrayList<LibraryListener> listeners = new ArrayList();
    private final LibraryNode root = new LibraryNode(Lang.get("menu_elements", new Object[0])).setLibrary(this).add(new LibraryNode(Lang.get("lib_Logic", new Object[0])).add(And.DESCRIPTION).add(NAnd.DESCRIPTION).add(Or.DESCRIPTION).add(NOr.DESCRIPTION).add(XOr.DESCRIPTION).add(XNOr.DESCRIPTION).add(Not.DESCRIPTION).add(LookUpTable.DESCRIPTION)).add(new LibraryNode(Lang.get("lib_io", new Object[0])).add(Out.DESCRIPTION).add(Out.LEDDESCRIPTION).add(In.DESCRIPTION).add(Clock.DESCRIPTION).add(Button.DESCRIPTION).add(DipSwitch.DESCRIPTION).add(Probe.DESCRIPTION).add(DummyElement.DATADESCRIPTION).add(ScopeTrigger.DESCRIPTION).add(new LibraryNode(Lang.get("lib_displays", new Object[0])).add(RGBLED.DESCRIPTION).add(Out.POLARITYAWARELEDDESCRIPTION).add(ButtonLED.DESCRIPTION).add(Out.SEVENDESCRIPTION).add(Out.SEVENHEXDESCRIPTION).add(Out.SIXTEENDESCRIPTION).add(LightBulb.DESCRIPTION).add(LedMatrix.DESCRIPTION)).add(new LibraryNode(Lang.get("lib_mechanic", new Object[0])).add(RotEncoder.DESCRIPTION).add(StepperMotorUnipolar.DESCRIPTION).add(StepperMotorBipolar.DESCRIPTION)).add(new LibraryNode(Lang.get("lib_peripherals", new Object[0])).add(Keyboard.DESCRIPTION).add(Terminal.DESCRIPTION).add(Telnet.DESCRIPTION).add(VGA.DESCRIPTION).add(MIDI.DESCRIPTION))).add(new LibraryNode(Lang.get("lib_wires", new Object[0])).add(Ground.DESCRIPTION).add(VDD.DESCRIPTION).add(Const.DESCRIPTION).add(Tunnel.DESCRIPTION).add(Splitter.DESCRIPTION).add(Driver.DESCRIPTION).add(DriverInvSel.DESCRIPTION).add(Delay.DESCRIPTION).add(PullUp.DESCRIPTION).add(PullDown.DESCRIPTION).add(NotConnected.DESCRIPTION)).add(new LibraryNode(Lang.get("lib_mux", new Object[0])).add(Multiplexer.DESCRIPTION).add(Demultiplexer.DESCRIPTION).add(Decoder.DESCRIPTION).add(BitSelector.DESCRIPTION).add(PriorityEncoder.DESCRIPTION)).add(new LibraryNode(Lang.get("lib_flipFlops", new Object[0])).add(FlipflopRSAsync.DESCRIPTION).add(FlipflopRS.DESCRIPTION).add(FlipflopJK.DESCRIPTION).add(FlipflopD.DESCRIPTION).add(FlipflopT.DESCRIPTION).add(FlipflopJKAsync.DESCRIPTION).add(FlipflopDAsync.DESCRIPTION).add(Monoflop.DESCRIPTION)).add(new LibraryNode(Lang.get("lib_memory", new Object[0])).add(new LibraryNode(Lang.get("lib_ram", new Object[0])).add(RAMDualPort.DESCRIPTION).add(BlockRAMDualPort.DESCRIPTION).add(RAMSinglePort.DESCRIPTION).add(RAMSinglePortSel.DESCRIPTION).add(RegisterFile.DESCRIPTION).add(RAMDualAccess.DESCRIPTION).add(RAMAsync.DESCRIPTION).add(GraphicCard.DESCRIPTION)).add(new LibraryNode(Lang.get("lib_eeprom", new Object[0])).add(EEPROM.DESCRIPTION).add(EEPROMDualPort.DESCRIPTION)).add(Register.DESCRIPTION).add(ROM.DESCRIPTION).add(ROMDualPort.DESCRIPTION).add(Counter.DESCRIPTION).add(CounterPreset.DESCRIPTION).add(PRNG.DESCRIPTION)).add(new LibraryNode(Lang.get("lib_arithmetic", new Object[0])).add(Add.DESCRIPTION).add(Sub.DESCRIPTION).add(Mul.DESCRIPTION).add(Div.DESCRIPTION).add(BarrelShifter.DESCRIPTION).add(Comparator.DESCRIPTION).add(Neg.DESCRIPTION).add(BitExtender.DESCRIPTION).add(BitCount.DESCRIPTION)).add(new LibraryNode(Lang.get("lib_switching", new Object[0])).add(Switch.DESCRIPTION).add(SwitchDT.DESCRIPTION).add(Relay.DESCRIPTION).add(RelayDT.DESCRIPTION).add(PFET.DESCRIPTION).add(NFET.DESCRIPTION).add(Fuse.DESCRIPTION).add(DiodeForward.DESCRIPTION).add(DiodeBackward.DESCRIPTION).add(FGPFET.DESCRIPTION).add(FGNFET.DESCRIPTION).add(TransGate.DESCRIPTION)).add(new LibraryNode(Lang.get("lib_misc", new Object[0])).add(TestCaseElement.DESCRIPTION).add(new LibraryNode(Lang.get("lib_decoration", new Object[0])).add(DummyElement.TEXTDESCRIPTION).add(DummyElement.RECTDESCRIPTION)).add(new LibraryNode(Lang.get("lib_generic", new Object[0])).add(GenericInitCode.DESCRIPTION).add(GenericCode.DESCRIPTION)).add(new LibraryNode(Lang.get("lib_hdl", new Object[0])).add(External.DESCRIPTION).add(ExternalFile.DESCRIPTION).add(PinControl.DESCRIPTION)).add(PowerSupply.DESCRIPTION).add(BusSplitter.DESCRIPTION).add(Reset.DESCRIPTION).add(Break.DESCRIPTION).add(Stop.DESCRIPTION).add(AsyncSeq.DESCRIPTION));
    private final ElementLibraryFolder custom;
    private JarComponentManager jarComponentManager;
    private ShapeFactory shapeFactory;
    private File rootLibraryPath;
    private Exception exception;
    private long lastRescanTime;
    private StringBuilder warningMessage;

    public static File getLibPath() {
        String path;
        try {
            path = ElementLibrary.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath().replace('\\', '/');
        }
        catch (URISyntaxException e) {
            return new File("noLibFound");
        }
        if (path.endsWith("/target/classes/")) {
            return ElementLibrary.toCanonical(new File(path.substring(0, path.length() - 16) + "/src/main/dig/lib"));
        }
        if (path.endsWith("/target/Digital.jar")) {
            return new File(path.substring(0, path.length() - 19) + "/src/main/dig/lib");
        }
        if (path.endsWith("Digital.jar")) {
            return new File(path.substring(0, path.length() - 12) + "/lib");
        }
        return new File("noLibFound");
    }

    private static File toCanonical(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }

    public ElementLibrary() {
        this(null);
    }

    public ElementLibrary(File jarFile) {
        this.addExternalJarComponents(jarFile);
        this.custom = new ElementLibraryFolder(this.root, Lang.get("menu_custom", new Object[0]));
        File libPath = Settings.getInstance().get(Keys.SETTINGS_LIBRARY_PATH);
        if (libPath != null && libPath.exists()) {
            new ElementLibraryFolder(this.root, Lang.get("menu_library", new Object[0])).scanFolder(libPath, true);
        }
        this.populateNodeMap();
        this.isProgrammable.clear();
        this.root.traverse(libraryNode -> {
            ElementTypeDescription d = libraryNode.getDescriptionOrNull();
            if (d != null && d.hasAttribute(Keys.BLOWN)) {
                this.isProgrammable.add(d.getName());
            }
        });
    }

    void addExternalJarComponents(File file) {
        if (file != null && file.getPath().length() > 0 && file.exists()) {
            if (this.jarComponentManager == null) {
                this.jarComponentManager = new JarComponentManager(this);
            }
            try {
                this.jarComponentManager.loadJar(file);
            }
            catch (InvalidNodeException | IOException e) {
                this.exception = e;
            }
        }
    }

    public ElementLibrary registerComponentSource(ComponentSource source) {
        try {
            if (this.jarComponentManager == null) {
                this.jarComponentManager = new JarComponentManager(this);
            }
            source.registerComponents(this.jarComponentManager);
        }
        catch (InvalidNodeException e) {
            this.exception = e;
        }
        return this;
    }

    public Exception checkForException() {
        Exception e = this.exception;
        this.exception = null;
        return e;
    }

    LibraryNode findNode(String path) throws InvalidNodeException {
        StringTokenizer st = new StringTokenizer(path, "\\/;");
        LibraryNode node = this.root;
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            LibraryNode found = null;
            for (LibraryNode n : node) {
                if (!n.getName().equals(name)) continue;
                if (n.isLeaf()) {
                    throw new InvalidNodeException(Lang.get("err_Node_N_isAComponent", n));
                }
                found = n;
            }
            if (found == null) {
                found = new LibraryNode(name);
                node.add(found);
            }
            node = found;
        }
        return node;
    }

    public JarComponentManager getJarComponentManager() {
        return this.jarComponentManager;
    }

    public boolean isProgrammable(String name) {
        return this.isProgrammable.contains(name);
    }

    public void setShapeFactory(ShapeFactory shapeFactory) {
        this.shapeFactory = shapeFactory;
    }

    @Override
    public ShapeFactory getShapeFactory() {
        return this.shapeFactory;
    }

    public LibraryNode getCustomNode() {
        return this.custom.getNode();
    }

    private void populateNodeMap() {
        this.map.clear();
        PopulateMapVisitor populateMapVisitor = new PopulateMapVisitor(this.map);
        this.root.traverse(populateMapVisitor);
        this.warningMessage = populateMapVisitor.getWarningMessage();
    }

    public StringBuilder getWarningMessage() {
        return this.warningMessage;
    }

    public void setRootFilePath(File rootLibraryPath) throws IOException {
        if (rootLibraryPath == null) {
            if (this.rootLibraryPath != null) {
                this.rootLibraryPath = null;
                this.rescanFolder();
            }
        } else if (!rootLibraryPath.equals(this.rootLibraryPath)) {
            this.rootLibraryPath = rootLibraryPath;
            this.rescanFolder();
        }
    }

    public File getRootFilePath() {
        return this.rootLibraryPath;
    }

    public boolean isFileAccessible(File file) {
        if (this.rootLibraryPath == null) {
            return true;
        }
        try {
            String root = this.rootLibraryPath.getCanonicalPath();
            return file.getParentFile().getCanonicalFile().toPath().startsWith(root);
        }
        catch (IOException e) {
            return false;
        }
    }

    public LibraryNode getElementNodeOrNull(String elementName) {
        return this.map.get(elementName);
    }

    @Override
    public ElementTypeDescription getElementType(String elementName, ElementAttributes attr) throws ElementNotFoundException {
        return this.getElementType(elementName);
    }

    public ElementTypeDescription getElementType(String elementName) throws ElementNotFoundException {
        try {
            LibraryNode node = this.map.get(elementName);
            if (node != null) {
                return node.getDescription();
            }
            if ((elementName = elementName.replace("\\", "/")).contains("/")) {
                elementName = new File(elementName).getName();
            }
            if ((node = this.map.get(elementName)) != null) {
                return node.getDescription();
            }
            if (this.rootLibraryPath == null) {
                throw new ElementNotFoundException(Lang.get("err_fileNeedsToBeSaved", new Object[0]));
            }
            LOGGER.debug("could not find " + elementName);
            if (System.currentTimeMillis() - this.lastRescanTime > 5000L) {
                this.rescanFolder();
                node = this.map.get(elementName);
                if (node != null) {
                    return node.getDescription();
                }
            }
        }
        catch (IOException e) {
            throw new ElementNotFoundException(Lang.get("msg_errorImportingModel_N0", elementName), e);
        }
        throw new ElementNotFoundException(Lang.get("err_element_N_notFound", elementName));
    }

    private void rescanFolder() {
        LOGGER.debug("rescan folder");
        LibraryNode cn = this.custom.scanFolder(this.rootLibraryPath, false);
        this.populateNodeMap();
        if (cn != null) {
            this.fireLibraryChanged(cn);
        }
        this.lastRescanTime = System.currentTimeMillis();
    }

    void fireLibraryChanged(LibraryNode node) {
        for (LibraryListener l : this.listeners) {
            l.libraryChanged(node);
        }
    }

    public void addListener(LibraryListener listener) {
        this.listeners.add(listener);
        LOGGER.debug("added library listener " + listener.getClass().getSimpleName() + ", listeners: " + this.listeners.size());
    }

    public void removeListener(LibraryListener listener) {
        this.listeners.remove(listener);
        LOGGER.debug("removed library listener " + listener.getClass().getSimpleName() + ", listeners: " + this.listeners.size());
    }

    @Override
    public Iterator<ElementContainer> iterator() {
        ArrayList<ElementContainer> nodes = new ArrayList<ElementContainer>();
        for (LibraryNode n : this.getRoot()) {
            this.addToList(nodes, n, "");
        }
        return nodes.iterator();
    }

    private void addToList(ArrayList<ElementContainer> nodes, LibraryNode node, String path) {
        if (node.isLeaf()) {
            if (node.isDescriptionLoaded()) {
                try {
                    nodes.add(new ElementContainer(node.getDescription(), path));
                }
                catch (IOException iOException) {}
            }
        } else {
            for (LibraryNode n : node) {
                this.addToList(nodes, n, this.concat(path, node.getName()));
            }
        }
    }

    private String concat(String path, String name) {
        if (path.length() == 0) {
            return name;
        }
        return path + " - " + name;
    }

    public void invalidateElement(File name) throws IOException {
        LibraryNode n = this.map.get(name.getName());
        if (n != null) {
            n.invalidate();
        } else if (this.rootLibraryPath != null && this.isFileAccessible(name)) {
            this.rescanFolder();
        }
    }

    public void updateEntries() throws IOException {
        this.rescanFolder();
    }

    public LibraryNode getRoot() {
        return this.root;
    }

    ElementTypeDescription importElement(File file) throws IOException {
        try {
            Circuit circuit;
            LOGGER.debug("load element " + file);
            try {
                circuit = Circuit.loadCircuit(file, this.shapeFactory);
            }
            catch (FileNotFoundException e) {
                throw new IOException(Lang.get("err_couldNotFindIncludedFile_N0", file));
            }
            ElementTypeDescriptionCustom description = ElementLibrary.createCustomDescription(file, circuit, this);
            description.setShortName(this.createShortName(file.getName(), circuit.getAttributes().getLabel()));
            String descriptionText = Lang.evalMultilingualContent(circuit.getAttributes().get(Keys.DESCRIPTION));
            if (descriptionText != null && descriptionText.length() > 0) {
                description.setDescription(descriptionText);
            }
            return description;
        }
        catch (PinException e) {
            throw new IOException(Lang.get("msg_errorImportingModel_N0", file), e);
        }
    }

    private String createShortName(String name, String userDefined) {
        if (userDefined.isEmpty()) {
            if (name.endsWith(".dig")) {
                return name.substring(0, name.length() - 4).replace("_", "\\_");
            }
            String transName = Lang.getNull("elem_" + name, new Object[0]);
            if (transName == null) {
                return name;
            }
            return transName;
        }
        return userDefined;
    }

    public static ElementTypeDescriptionCustom createCustomDescription(File file, Circuit circuit, ElementLibrary library) throws PinException {
        ElementTypeDescriptionCustom d = new ElementTypeDescriptionCustom(file, circuit, library);
        d.setElementFactory(attributes -> new CustomElement(d));
        return d;
    }

    private static final class PopulateMapVisitor
    implements Visitor {
        private static final int MAX_WARNING_ENTRIES = 15;
        private final HashMap<String, LibraryNode> map;
        private StringBuilder warningMessage;
        private int warningEntries = 0;

        private PopulateMapVisitor(HashMap<String, LibraryNode> map) {
            this.map = map;
        }

        @Override
        public void visit(LibraryNode libraryNode) {
            if (libraryNode.isLeaf()) {
                String name = libraryNode.getName();
                LibraryNode presentNode = this.map.get(name);
                if (presentNode == null) {
                    this.map.put(name, libraryNode);
                    libraryNode.setUnique(true);
                } else if (presentNode.equalsFile(libraryNode)) {
                    libraryNode.setUnique(true);
                } else {
                    presentNode.setUnique(false);
                    libraryNode.setUnique(false);
                    if (this.warningMessage == null) {
                        this.warningMessage = new StringBuilder(Lang.get("msg_duplicateLibraryFiles", new Object[0]));
                    }
                    if (this.warningEntries <= 15) {
                        this.warningMessage.append("\n\n").append(presentNode.getFile()).append("\n").append(libraryNode.getFile());
                    }
                    ++this.warningEntries;
                }
            }
        }

        private StringBuilder getWarningMessage() {
            if (this.warningEntries >= 15) {
                this.warningMessage.append("\n\n").append(Lang.get("msg_and_N_More", this.warningEntries - 15));
                this.warningEntries = 0;
            }
            return this.warningMessage;
        }
    }

    public static class ElementContainer {
        private final ElementTypeDescription name;
        private final String treePath;

        ElementContainer(ElementTypeDescription typeDescription, String treePath) {
            this.name = typeDescription;
            this.treePath = treePath;
        }

        public ElementTypeDescription getDescription() {
            return this.name;
        }

        public String getTreePath() {
            return this.treePath;
        }
    }
}

