/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics.text.text;

import de.neemann.digital.draw.graphics.text.ParseException;
import de.neemann.digital.draw.graphics.text.text.Blank;
import de.neemann.digital.draw.graphics.text.text.Index;
import de.neemann.digital.draw.graphics.text.text.Text;
import java.util.ArrayList;
import java.util.Iterator;

public class Sentence
implements Text,
Iterable<Text> {
    private final ArrayList<Text> list = new ArrayList();

    public Sentence add(Text text) {
        if (text != null) {
            this.list.add(text);
        }
        return this;
    }

    @Override
    public Text simplify() {
        if (this.list.size() == 1) {
            return this.list.get(0);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Text t : this.list) {
            sb.append(t.toString());
        }
        return sb.toString();
    }

    public Index getIndex() throws ParseException {
        if (this.list.isEmpty()) {
            throw new ParseException("no previous text element");
        }
        Text last = this.list.get(this.list.size() - 1);
        if (last instanceof Index) {
            return (Index)last;
        }
        Index index = new Index(last);
        this.list.set(this.list.size() - 1, index);
        return index;
    }

    @Override
    public Iterator<Text> iterator() {
        return this.list.iterator();
    }

    public boolean lastIsBlank() {
        if (this.list.isEmpty()) {
            return true;
        }
        return this.list.get(this.list.size() - 1) instanceof Blank;
    }

    public int size() {
        return this.list.size();
    }
}

