/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics.text.formatter;

import de.neemann.digital.draw.graphics.text.text.Blank;
import de.neemann.digital.draw.graphics.text.text.Character;
import de.neemann.digital.draw.graphics.text.text.Decorate;
import de.neemann.digital.draw.graphics.text.text.Index;
import de.neemann.digital.draw.graphics.text.text.Sentence;
import de.neemann.digital.draw.graphics.text.text.Simple;
import de.neemann.digital.draw.graphics.text.text.Text;

public final class SVGFormatter {
    private SVGFormatter() {
    }

    public static String format(Text text) {
        return SVGFormatter.format(text, false);
    }

    private static String format(Text text, boolean mathMode) {
        if (text instanceof Simple) {
            return ((Simple)text).getText();
        }
        if (text instanceof Blank) {
            return " ";
        }
        if (text instanceof Character) {
            return SVGFormatter.character(((Character)text).getChar());
        }
        if (text instanceof Decorate) {
            Decorate d = (Decorate)text;
            switch (d.getStyle()) {
                case MATH: {
                    if (mathMode) {
                        return SVGFormatter.format(d.getContent(), true);
                    }
                    return "<tspan style=\"font-style:italic;\">" + SVGFormatter.format(d.getContent(), true) + "</tspan>";
                }
                case OVERLINE: {
                    return "<tspan style=\"text-decoration:overline;\">" + SVGFormatter.format(d.getContent(), mathMode) + "</tspan>";
                }
            }
            return SVGFormatter.format(d.getContent(), mathMode);
        }
        if (text instanceof Index) {
            Index i = (Index)text;
            String str = SVGFormatter.format(i.getVar(), true);
            if (i.getSubScript() != null) {
                str = str + "<tspan style=\"font-size:80%;baseline-shift:sub;\">" + SVGFormatter.format(i.getSubScript(), mathMode) + "</tspan>";
            }
            if (i.getSuperScript() != null) {
                str = str + "<tspan style=\"font-size:80%;baseline-shift:super;\">" + SVGFormatter.format(i.getSuperScript(), mathMode) + "</tspan>";
            }
            return str;
        }
        if (text instanceof Sentence) {
            Sentence s = (Sentence)text;
            StringBuilder sb = new StringBuilder();
            for (Text t : s) {
                sb.append(SVGFormatter.format(t, mathMode));
            }
            return sb.toString();
        }
        return "";
    }

    private static String character(char aChar) {
        switch (aChar) {
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
        }
        return "" + aChar;
    }
}

