/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics.text.formatter;

import de.neemann.digital.analyse.expression.format.FormatToExpression;
import de.neemann.digital.draw.graphics.text.text.Blank;
import de.neemann.digital.draw.graphics.text.text.Character;
import de.neemann.digital.draw.graphics.text.text.Decorate;
import de.neemann.digital.draw.graphics.text.text.Index;
import de.neemann.digital.draw.graphics.text.text.Sentence;
import de.neemann.digital.draw.graphics.text.text.Simple;
import de.neemann.digital.draw.graphics.text.text.Text;

public final class PlainTextFormatter {
    private PlainTextFormatter() {
    }

    public static String format(Text text) {
        return PlainTextFormatter.format(text, FormatToExpression.getDefaultFormat());
    }

    public static String format(Text text, FormatToExpression format) {
        if (text instanceof Simple) {
            return ((Simple)text).getText();
        }
        if (text instanceof Blank) {
            return " ";
        }
        if (text instanceof Character) {
            return "" + ((Character)text).getChar();
        }
        if (text instanceof Decorate) {
            Decorate d = (Decorate)text;
            if (d.getStyle() == Decorate.Style.OVERLINE) {
                Text content = d.getContent();
                if (content instanceof Simple || content instanceof Index) {
                    return format.getNot() + PlainTextFormatter.format(content, format);
                }
                return format.getNot() + "(" + PlainTextFormatter.format(content, format) + ")";
            }
            return PlainTextFormatter.format(d.getContent(), format);
        }
        if (text instanceof Index) {
            Index i = (Index)text;
            String str = PlainTextFormatter.format(i.getVar(), format);
            if (i.getSubScript() != null) {
                str = str + PlainTextFormatter.format(i.getSubScript(), format);
            }
            if (i.getSuperScript() != null) {
                str = str + PlainTextFormatter.format(i.getSuperScript(), format);
            }
            return str;
        }
        if (text instanceof Sentence) {
            Sentence s = (Sentence)text;
            StringBuilder sb = new StringBuilder();
            for (Text t : s) {
                sb.append(PlainTextFormatter.format(t, format));
            }
            return sb.toString();
        }
        return "";
    }
}

