/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics.text.formatter;

import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.format.FormatToExpression;
import de.neemann.digital.draw.graphics.text.text.Blank;
import de.neemann.digital.draw.graphics.text.text.Character;
import de.neemann.digital.draw.graphics.text.text.Decorate;
import de.neemann.digital.draw.graphics.text.text.ExpressionToText;
import de.neemann.digital.draw.graphics.text.text.Index;
import de.neemann.digital.draw.graphics.text.text.Sentence;
import de.neemann.digital.draw.graphics.text.text.Simple;
import de.neemann.digital.draw.graphics.text.text.Text;

public final class LaTeXFormatter {
    private LaTeXFormatter() {
    }

    public static String format(Expression exp) {
        return LaTeXFormatter.format(new ExpressionToText().createText(exp, FormatToExpression.LATEX), true);
    }

    public static String format(Text text) {
        return LaTeXFormatter.format(text, false);
    }

    private static String format(Text text, boolean mathMode) {
        if (text instanceof Simple) {
            return ((Simple)text).getText();
        }
        if (text instanceof Blank) {
            return " ";
        }
        if (text instanceof Character) {
            return LaTeXFormatter.character(((Character)text).getChar(), mathMode);
        }
        if (text instanceof Decorate) {
            Decorate d = (Decorate)text;
            switch (d.getStyle()) {
                case MATH: {
                    if (mathMode) {
                        return LaTeXFormatter.format(d.getContent(), true);
                    }
                    return "$" + LaTeXFormatter.format(d.getContent(), true) + "$";
                }
                case OVERLINE: {
                    if (mathMode) {
                        return "\\overline{" + LaTeXFormatter.format(d.getContent(), true) + "}";
                    }
                    Text c = d.getContent();
                    if (c instanceof Index) {
                        return "$\\overline{" + LaTeXFormatter.format(c, true) + "}$";
                    }
                    return "$\\overline{\\mbox{" + LaTeXFormatter.format(c, true) + "}}$";
                }
            }
            return LaTeXFormatter.format(d.getContent(), mathMode);
        }
        if (text instanceof Index) {
            Index i = (Index)text;
            String str = LaTeXFormatter.format(i.getVar(), true);
            if (i.getSuperScript() != null) {
                str = str + '^' + LaTeXFormatter.brace(LaTeXFormatter.format(i.getSuperScript(), true));
            }
            if (i.getSubScript() != null) {
                str = str + '_' + LaTeXFormatter.brace(LaTeXFormatter.format(i.getSubScript(), true));
            }
            if (mathMode) {
                return str;
            }
            return "$" + str + "$";
        }
        if (text instanceof Sentence) {
            Sentence s = (Sentence)text;
            StringBuilder sb = new StringBuilder();
            for (Text t : s) {
                sb.append(LaTeXFormatter.format(t, mathMode));
            }
            return sb.toString();
        }
        return "";
    }

    private static String character(char aChar, boolean inMath) {
        switch (aChar) {
            case '\u00ac': {
                if (inMath) {
                    return "\\neg{}";
                }
                return "$\\neg{}$";
            }
            case '\u2265': {
                if (inMath) {
                    return "\\geq\\!\\!{}";
                }
                return "$\\geq\\!\\!{}$";
            }
            case '<': {
                if (inMath) {
                    return "" + aChar;
                }
                return "\\textless{}";
            }
            case '>': {
                if (inMath) {
                    return "" + aChar;
                }
                return "\\textgreater{}";
            }
            case '&': {
                if (inMath) {
                    return "\\ \\&\\ ";
                }
                return "\\&";
            }
            case '|': {
                if (inMath) {
                    return "\\ |\\ ";
                }
                return "|";
            }
            case '_': {
                return "\\_";
            }
            case '\\': {
                return "\\\\";
            }
            case '\u2211': {
                if (inMath) {
                    return "\\sum ";
                }
                return "$\\sum$";
            }
            case '\u220f': {
                if (inMath) {
                    return "\\prod ";
                }
                return "$\\prod$";
            }
            case '\u2227': {
                if (inMath) {
                    return "\\wedge ";
                }
                return "$\\wedge$";
            }
            case '\u2228': {
                if (inMath) {
                    return "\\vee ";
                }
                return "$\\vee$";
            }
        }
        return "" + aChar;
    }

    private static String brace(String format) {
        if (format.length() == 1) {
            return format;
        }
        return "{" + format + "}";
    }
}

