/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics.linemerger;

import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.VectorInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class GraphicLineCollector
extends Graphic {
    private final HashMap<Style, PolygonSet> polys = new HashMap();

    @Override
    public void drawLine(VectorInterface p1, VectorInterface p2, Style style) {
        PolygonSet polyList = this.polys.get(style);
        if (polyList == null) {
            polyList = new PolygonSet(style);
            this.polys.put(style, polyList);
        }
        polyList.add(p1, p2);
    }

    @Override
    public void drawPolygon(Polygon p, Style style) {
    }

    @Override
    public void drawCircle(VectorInterface p1, VectorInterface p2, Style style) {
    }

    @Override
    public void drawText(VectorInterface p1, VectorInterface p2, VectorInterface p3, String text, Orientation orientation, Style style) {
    }

    public void drawTo(Graphic gr) {
        for (PolygonSet p : this.polys.values()) {
            p.drawTo(gr);
        }
    }

    private static final class PolygonSet
    implements Iterable<Polygon> {
        private final ArrayList<Polygon> polyList;
        private final Style style;

        private PolygonSet(Style style) {
            this.style = style;
            this.polyList = new ArrayList();
        }

        private void add(VectorInterface p1, VectorInterface p2) {
            for (Polygon p : this.polyList) {
                if (!p.addLine(p1, p2)) continue;
                this.tryMerge(p);
                return;
            }
            Polygon p = new Polygon(false).add(p1).add(p2);
            this.polyList.add(p);
        }

        @Override
        public Iterator<Polygon> iterator() {
            return this.polyList.iterator();
        }

        private void tryMerge(Polygon p1) {
            for (Polygon p2 : this.polyList) {
                if (p1 == p2 || p1.isClosed() || p2.isClosed()) continue;
                if (p1.getLast().equals(p2.getFirst())) {
                    p1.append(p2);
                    this.polyList.remove(p2);
                    return;
                }
                if (p2.getLast().equals(p1.getFirst())) {
                    p2.append(p1);
                    this.polyList.remove(p1);
                    return;
                }
                if (p1.getLast().equals(p2.getLast())) {
                    p1.append(p2.reverse());
                    this.polyList.remove(p2);
                    return;
                }
                if (!p1.getFirst().equals(p2.getFirst())) continue;
                this.polyList.remove(p1);
                this.polyList.remove(p2);
                this.polyList.add(p1.reverse().append(p2));
                return;
            }
        }

        public void drawTo(Graphic gr) {
            for (Polygon p : this.polyList) {
                gr.drawPolygon(p, this.style);
            }
        }
    }
}

