/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics;

import de.neemann.digital.draw.graphics.Transform;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.graphics.VectorInterface;
import java.util.Objects;

public class VectorFloat
implements VectorInterface {
    private final float x;
    private final float y;

    public VectorFloat(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public VectorFloat(VectorInterface v) {
        this.x = v.getXFloat();
        this.y = v.getYFloat();
    }

    @Override
    public int getX() {
        return Math.round(this.x);
    }

    @Override
    public int getY() {
        return Math.round(this.y);
    }

    @Override
    public float getXFloat() {
        return this.x;
    }

    @Override
    public float getYFloat() {
        return this.y;
    }

    @Override
    public VectorInterface transform(Transform tr) {
        return tr.transform(this);
    }

    @Override
    public VectorFloat add(VectorInterface a) {
        return new VectorFloat(this.x + a.getXFloat(), this.y + a.getYFloat());
    }

    public VectorFloat add(float dx, float dy) {
        return new VectorFloat(this.x + dx, this.y + dy);
    }

    @Override
    public VectorFloat sub(VectorInterface sub) {
        return new VectorFloat(this.x - sub.getXFloat(), this.y - sub.getYFloat());
    }

    @Override
    public VectorFloat norm() {
        float l = (float)Math.sqrt(this.x * this.x + this.y * this.y);
        return new VectorFloat(this.x / l, this.y / l);
    }

    @Override
    public VectorFloat mul(float a) {
        return new VectorFloat(this.x * a, this.y * a);
    }

    public float mul(VectorFloat p) {
        return this.x * p.x + this.y * p.y;
    }

    @Override
    public VectorFloat div(int d) {
        return new VectorFloat(this.x / (float)d, this.y / (float)d);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VectorFloat that = (VectorFloat)o;
        return Float.compare(that.x, this.x) == 0 && Float.compare(that.y, this.y) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y));
    }

    public String toString() {
        return "(x=" + this.x + ", y=" + this.y + ')';
    }

    @Override
    public Vector round() {
        return new Vector(this.getX(), this.getY());
    }

    @Override
    public float len() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    @Override
    public VectorFloat toFloat() {
        return this;
    }

    @Override
    public VectorFloat getOrthogonal() {
        return new VectorFloat(this.y, -this.x);
    }
}

